/*
 * Decompiled with CFR 0.152.
 */
package tnt.tarkovcraft.core.common.skill.tracker;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.util.ExtraCodecs;
import tnt.tarkovcraft.core.common.data.number.NumberProvider;
import tnt.tarkovcraft.core.common.data.number.NumberProviderType;
import tnt.tarkovcraft.core.common.init.CoreSkillTrackers;
import tnt.tarkovcraft.core.common.skill.SkillContextKeys;
import tnt.tarkovcraft.core.common.skill.tracker.SkillTracker;
import tnt.tarkovcraft.core.common.skill.tracker.SkillTrackerType;
import tnt.tarkovcraft.core.util.context.Context;

public class SimpleSkillTracker
implements SkillTracker {
    public static final MapCodec<SimpleSkillTracker> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)NumberProviderType.complexCodecNoDuration(ExtraCodecs.POSITIVE_FLOAT).fieldOf("value").forGetter(t -> Either.left((Object)t.value))).apply((Applicative)instance, SimpleSkillTracker::new));
    private final NumberProvider value;

    public SimpleSkillTracker(Either<NumberProvider, Float> value) {
        this.value = NumberProviderType.resolveNoDuration(value);
    }

    @Override
    public boolean isTriggerable(Context context) {
        return true;
    }

    @Override
    public float trigger(Context context) {
        return this.value.floatValue() * context.getOrDefault(SkillContextKeys.SKILL_GAIN_MULTIPLIER, Float.valueOf(1.0f)).floatValue();
    }

    @Override
    public SkillTrackerType<?> getType() {
        return CoreSkillTrackers.SIMPLE.get();
    }
}

