/*
 * Decompiled with CFR 0.152.
 */
package tnt.tarkovcraft.core.util.context;

import java.util.Collection;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.util.context.ContextKey;
import tnt.tarkovcraft.core.util.context.ContextImpl;

public interface Context {
    public static final Context NONE = ContextImpl.empty();

    public Set<ContextKey<?>> listKeys();

    public <T> Optional<T> get(ContextKey<T> var1);

    public boolean containsKey(ContextKey<?> var1);

    public boolean containsKeys(Collection<ContextKey<?>> var1);

    default public <T> T getOrDefault(ContextKey<T> k, T defaultValue) {
        return this.get(k).orElse(defaultValue);
    }

    default public <T> T getOrSupplyDefault(ContextKey<T> k, Supplier<T> defaultSupplier) {
        return this.get(k).orElseGet(defaultSupplier);
    }

    default public <T> T getOrThrow(ContextKey<T> k) {
        return this.getOrThrow(k, () -> new NoSuchElementException("Context missing value for key " + String.valueOf(k)));
    }

    default public <T, X extends Throwable> T getOrThrow(ContextKey<T> k, Supplier<X> exception) throws X {
        return this.get(k).orElseThrow(exception);
    }
}

