/*
 * Decompiled with CFR 0.152.
 */
package tnt.tarkovcraft.core.util.helper;

import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ARGB;
import org.joml.Matrix4f;
import org.joml.Vector2f;
import tnt.tarkovcraft.core.util.ScreenPositionCalculator;

public final class RenderUtils {
    public static boolean isVisibleColor(int color) {
        return RenderUtils.isNotTransparent(color, 0);
    }

    public static boolean isNotTransparent(int color, int limit) {
        int a = ARGB.alpha((int)color);
        return a > limit;
    }

    public static void blitFull(GuiGraphics graphics, ResourceLocation icon, int x1, int y1, int x2, int y2) {
        RenderUtils.blitFull(graphics, icon, x1, y1, x2, y2, -1);
    }

    public static void blitFull(GuiGraphics graphics, ResourceLocation icon, int x1, int y1, int x2, int y2, int color) {
        graphics.innerBlit(RenderType::guiTextured, icon, x1, x2, y1, y2, 0.0f, 1.0f, 0.0f, 1.0f, color);
    }

    public static void fill(GuiGraphics graphics, float x1, float y1, float x2, float y2, float z, int color) {
        Matrix4f pose = graphics.pose().last().pose();
        VertexConsumer consumer = graphics.bufferSource.getBuffer(RenderType.gui());
        consumer.addVertex(pose, x1, y1, z).setColor(color);
        consumer.addVertex(pose, x1, y2, z).setColor(color);
        consumer.addVertex(pose, x2, y2, z).setColor(color);
        consumer.addVertex(pose, x2, y1, z).setColor(color);
    }

    public static void fill(GuiGraphics graphics, float x1, float y1, float x2, float y2, int color) {
        RenderUtils.fill(graphics, x1, y1, x2, y2, 0.0f, color);
    }

    public static void fillGradient(GuiGraphics graphics, float x1, float y1, float x2, float y2, float z, int colorFrom, int colorTo) {
        Matrix4f pose = graphics.pose().last().pose();
        VertexConsumer consumer = graphics.bufferSource.getBuffer(RenderType.gui());
        consumer.addVertex(pose, x1, y1, z).setColor(colorFrom);
        consumer.addVertex(pose, x1, y2, z).setColor(colorTo);
        consumer.addVertex(pose, x2, y2, z).setColor(colorTo);
        consumer.addVertex(pose, x2, y1, z).setColor(colorFrom);
    }

    public static void fillGradient(GuiGraphics graphics, float x1, float y1, float x2, float y2, int colorFrom, int colorTo) {
        RenderUtils.fillGradient(graphics, x1, y1, x2, y2, 0.0f, colorFrom, colorTo);
    }

    public static void fillDarkenGradient(GuiGraphics graphics, float x1, float y1, float x2, float y2, float z, int colorFrom, float rgbScale) {
        RenderUtils.fillGradient(graphics, x1, y1, x2, y2, z, colorFrom, ARGB.scaleRGB((int)colorFrom, (float)rgbScale));
    }

    public static void fillDarkenGradient(GuiGraphics graphics, float x1, float y1, float x2, float y2, int colorFrom, float rgbScale) {
        RenderUtils.fillGradient(graphics, x1, y1, x2, y2, 0.0f, colorFrom, ARGB.scaleRGB((int)colorFrom, (float)rgbScale));
    }

    public static void fillDarkenGradient(GuiGraphics graphics, float x1, float y1, float x2, float y2, float z, int colorFrom) {
        RenderUtils.fillDarkenGradient(graphics, x1, y1, x2, y2, z, colorFrom, 0.8f);
    }

    public static void fillDarkenGradient(GuiGraphics graphics, float x1, float y1, float x2, float y2, int colorFrom) {
        RenderUtils.fillDarkenGradient(graphics, x1, y1, x2, y2, colorFrom, 0.8f);
    }

    public static Vector2f getPosition(float x1, float y1, float x2, float y2, float width, float height, ScreenPositionCalculator horizontal, ScreenPositionCalculator vertical) {
        float x = horizontal.getPosition(x1, x2, width);
        float y = vertical.getPosition(y1, y2, height);
        return new Vector2f(x, y);
    }
}

