/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.configuration.client.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.toma.configuration.client.theme.ConfigTheme;
import dev.toma.configuration.client.widget.ThemedButtonWidget;
import dev.toma.configuration.config.value.EnumValue;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;

public class EnumWidget<E extends Enum<E>>
extends ThemedButtonWidget {
    private final EnumValue<E> value;

    public EnumWidget(int x, int y, int w, int h, ConfigTheme theme, EnumValue<E> value) {
        super(x, y, w, h, CommonComponents.EMPTY, theme);
        this.value = value;
        this.updateText();
    }

    @Override
    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        Minecraft minecraft = Minecraft.getInstance();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)this.alpha);
        this.renderBackground(graphics);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int textColor = this.theme.getWidgetTextColor(this.active, this.isHovered);
        this.renderString(graphics, minecraft.font, textColor);
    }

    private void renderString(GuiGraphics graphics, Font font, int color) {
        this.renderScrollingString(graphics, font, 2, color);
    }

    @Override
    public void onClick(double p_230982_1_, double p_230982_3_) {
        this.nextValue();
        this.updateText();
    }

    @Override
    public void updateWidgetNarration(NarrationElementOutput p_169152_) {
    }

    public void setValue(E value) {
        this.value.setValue(value);
        this.updateText();
        this.setChanged();
    }

    private void nextValue() {
        Enum e = (Enum)this.value.get();
        Enum[] values = (Enum[])e.getDeclaringClass().getEnumConstants();
        int i = e.ordinal();
        int j = (i + 1) % values.length;
        Enum next = values[j];
        this.value.setValue(next);
        this.setChanged();
    }

    private void updateText() {
        Enum e = (Enum)this.value.get();
        this.setMessage((Component)Component.literal((String)e.name()));
    }
}

