/*
 * Decompiled with CFR 0.152.
 */
package tnt.tarkovcraft.medsystem.api.heal;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipProvider;
import tnt.tarkovcraft.core.common.attribute.AttributeSystem;
import tnt.tarkovcraft.core.common.data.duration.Duration;
import tnt.tarkovcraft.core.common.data.duration.TickValue;
import tnt.tarkovcraft.core.util.Codecs;
import tnt.tarkovcraft.medsystem.common.effect.InjuryRecoveryStatusEffect;
import tnt.tarkovcraft.medsystem.common.effect.util.StatusEffectHelper;
import tnt.tarkovcraft.medsystem.common.health.HealthContainer;
import tnt.tarkovcraft.medsystem.common.health.Limb;
import tnt.tarkovcraft.medsystem.common.init.MedSystemAttributes;

public record Surgery(float healthAfterHeal, float maxHealthMultiplier, float minLimbHealth, int recoveryTime, int useTime) implements TooltipProvider
{
    public static final Codec<Surgery> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ExtraCodecs.POSITIVE_FLOAT.optionalFieldOf("healthAfterHeal", (Object)Float.valueOf(1.0f)).forGetter(Surgery::healthAfterHeal), (App)ExtraCodecs.POSITIVE_FLOAT.optionalFieldOf("maxHealthMultiplier", (Object)Float.valueOf(1.0f)).forGetter(Surgery::maxHealthMultiplier), (App)Codecs.NON_NEGATIVE_FLOAT.optionalFieldOf("minLimbHealth", (Object)Float.valueOf(0.0f)).forGetter(Surgery::minLimbHealth), (App)Codecs.NON_NEGATIVE_INT.optionalFieldOf("recoveryTime", (Object)Duration.minutes((int)10).tickValue()).forGetter(Surgery::recoveryTime), (App)Codecs.NON_NEGATIVE_INT.fieldOf("useTime").forGetter(Surgery::useTime)).apply((Applicative)instance, Surgery::new));

    public boolean canHeal(HealthContainer container) {
        return container.getLimbsAsStream().anyMatch(part -> part.isDead() && part.getMaxHealth() >= this.minLimbHealth);
    }

    public boolean hasPostRecovery() {
        return this.recoveryTime > 0 && this.maxHealthMultiplier < 1.0f;
    }

    public void addRecoveryAttributes(LivingEntity entity, Limb part) {
        if (this.hasPostRecovery()) {
            float reductionScale = AttributeSystem.getFloatValue((Entity)entity, MedSystemAttributes.INJURY_RECOVERY_AMOUNT, (float)1.0f);
            float durationScale = AttributeSystem.getFloatValue((Entity)entity, MedSystemAttributes.INJURY_RECOVERY_DURATION, (float)1.0f);
            if (durationScale > 0.0f && reductionScale > 0.0f) {
                int reduction = Mth.ceil((float)(part.getMaxHealth() * (1.0f - this.maxHealthMultiplier) * reductionScale));
                int duration = Mth.ceil((float)((float)this.recoveryTime * durationScale));
                InjuryRecoveryStatusEffect effect = InjuryRecoveryStatusEffect.createTemplate(reduction);
                effect.setDuration(duration);
                StatusEffectHelper.addEffect(part.getStatusEffects(), entity, part, effect);
            }
        }
    }

    public void addToTooltip(Item.TooltipContext context, Consumer<Component> tooltipAdder, TooltipFlag flag) {
        MutableComponent health = Component.literal((String)String.valueOf(Mth.ceil((float)this.healthAfterHeal))).withStyle(ChatFormatting.YELLOW);
        tooltipAdder.accept((Component)Component.translatable((String)"tooltip.medsystem.heal_attributes.dead_limb.recovery", (Object[])new Object[]{health}).withStyle(ChatFormatting.DARK_GRAY));
        MutableComponent maxHealth = Component.literal((String)((int)((1.0f - this.maxHealthMultiplier) * 100.0f) + "%")).withStyle(ChatFormatting.YELLOW);
        if (this.hasPostRecovery()) {
            MutableComponent duration = Duration.format((int)this.recoveryTime).copy().withStyle(ChatFormatting.YELLOW);
            tooltipAdder.accept((Component)Component.translatable((String)"tooltip.medsystem.heal_attributes.dead_limb.max_health", (Object[])new Object[]{maxHealth, duration}).withStyle(ChatFormatting.DARK_GRAY));
        }
    }

    public static class SurgeryBuilder {
        private float healthAfterHeal = 1.0f;
        private float maxHealthMultiplier = 1.0f;
        private float minLimbHealth = 0.0f;
        private int recoveryTime = 0;
        private int useTime = 100;

        public SurgeryBuilder useTime(int useTime) {
            this.useTime = useTime;
            return this;
        }

        public SurgeryBuilder useTime(TickValue useTime) {
            return this.useTime(useTime.tickValue());
        }

        public SurgeryBuilder recoverHealth(float healthAfterHeal) {
            this.healthAfterHeal = healthAfterHeal;
            return this;
        }

        public SurgeryBuilder minLimbHealth(float minLimbHealth) {
            this.minLimbHealth = minLimbHealth;
            return this;
        }

        public SurgeryBuilder recovery(int recoveryTime, float maxHealthMultiplier) {
            this.recoveryTime = recoveryTime;
            this.maxHealthMultiplier = maxHealthMultiplier;
            return this;
        }

        public SurgeryBuilder recovery(TickValue duration, float maxHealthMultiplier) {
            return this.recovery(duration.tickValue(), maxHealthMultiplier);
        }

        Surgery buildSurgeryAttributes() {
            return new Surgery(this.healthAfterHeal, this.maxHealthMultiplier, this.minLimbHealth, this.recoveryTime, this.useTime);
        }
    }
}

