/*
 * Decompiled with CFR 0.152.
 */
package tnt.tarkovcraft.medsystem.client.screen;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.attachment.IAttachmentHolder;
import net.neoforged.neoforge.network.PacketDistributor;
import org.joml.Vector2f;
import org.joml.Vector4i;
import tnt.tarkovcraft.core.client.screen.renderable.LabelRenderable;
import tnt.tarkovcraft.core.client.screen.renderable.ShapeRenderable;
import tnt.tarkovcraft.core.util.HorizontalAlignment;
import tnt.tarkovcraft.core.util.helper.TextHelper;
import tnt.tarkovcraft.medsystem.api.heal.HealItemAttributes;
import tnt.tarkovcraft.medsystem.client.MedicalSystemClient;
import tnt.tarkovcraft.medsystem.client.config.HealthOverlayConfiguration;
import tnt.tarkovcraft.medsystem.client.overlay.HealthLayer;
import tnt.tarkovcraft.medsystem.client.screen.HealthContainerScreen;
import tnt.tarkovcraft.medsystem.client.screen.HealthScreen;
import tnt.tarkovcraft.medsystem.client.screen.widget.BodyPartHealthWidget;
import tnt.tarkovcraft.medsystem.client.screen.widget.BodyPartWidget;
import tnt.tarkovcraft.medsystem.common.effect.StatusEffect;
import tnt.tarkovcraft.medsystem.common.effect.StatusEffectType;
import tnt.tarkovcraft.medsystem.common.effect.util.EffectVisibility;
import tnt.tarkovcraft.medsystem.common.health.BodyPartDisplay;
import tnt.tarkovcraft.medsystem.common.health.HealthContainer;
import tnt.tarkovcraft.medsystem.common.health.HealthContainerDefinition;
import tnt.tarkovcraft.medsystem.common.health.Limb;
import tnt.tarkovcraft.medsystem.common.init.MedSystemDataAttachments;
import tnt.tarkovcraft.medsystem.common.init.MedSystemItemComponents;
import tnt.tarkovcraft.medsystem.common.item.InteractionTarget;
import tnt.tarkovcraft.medsystem.network.message.C2S_SelectBodyPart;

public class SelectBodyPartScreen
extends Screen
implements HealthContainerScreen {
    public static final Component TITLE = TextHelper.createScreenTitle((String)"medsystem", (String)"select_body_part").withStyle(ChatFormatting.BOLD).withColor(-2039584);
    public static final Component LABEL_ERROR = TextHelper.createScreenComponent((String)"medsystem", (String)"select_body_part", (String)"error.invalid_item");
    public static final Component LABEL_NOT_HEALABLE = TextHelper.createScreenComponent((String)"medsystem", (String)"select_body_part", (String)"error.not_healable").withStyle(ChatFormatting.RED);
    public static final Component LABEL_CLICK_TO_SELECT = TextHelper.createScreenComponent((String)"medsystem", (String)"select_body_part", (String)"text.click_to_select").withStyle(ChatFormatting.GREEN);
    private final boolean selfHealing;
    private final int entityId;

    public SelectBodyPartScreen(boolean selfHealing, int entityID) {
        super(TITLE);
        this.selfHealing = selfHealing;
        this.entityId = entityID;
    }

    @Override
    public void onHealthContainerUpdated(IAttachmentHolder holder, HealthContainer container) {
        if (!(holder instanceof LivingEntity)) {
            return;
        }
        LivingEntity entity = (LivingEntity)holder;
        if (entity.getId() == this.entityId) {
            this.init(this.minecraft, this.width, this.height);
        }
    }

    protected void init() {
        LocalPlayer target;
        MutableComponent subtitle;
        ItemStack itemStack = this.minecraft.player.getMainHandItem();
        if (this.selfHealing) {
            subtitle = Component.translatable((String)"label.medsystem.healing.self.target");
            target = this.minecraft.player;
        } else {
            Entity entity = this.minecraft.level.getEntity(this.entityId);
            if (!(entity instanceof LivingEntity)) {
                this.minecraft.setScreen(null);
                return;
            }
            LivingEntity livingEntity = (LivingEntity)entity;
            subtitle = Component.translatable((String)"label.medsystem.healing.other.target", (Object[])new Object[]{entity.getDisplayName()}).withStyle(ChatFormatting.YELLOW);
            target = livingEntity;
        }
        this.addRenderableOnly((Renderable)new ShapeRenderable(0, 0, this.width, this.height, -1157627904));
        LabelRenderable titleLabel = (LabelRenderable)this.addRenderableOnly((Renderable)LabelRenderable.fromComponent((int)0, (int)0, (int)this.width, (int)20, (Font)this.font, (Component)TITLE));
        titleLabel.setShadow(true);
        titleLabel.setTextColor(-1);
        titleLabel.setHorizontalAlignment(HorizontalAlignment.CENTER);
        LabelRenderable subtitleLabel = (LabelRenderable)this.addRenderableOnly((Renderable)LabelRenderable.fromComponent((int)0, (int)20, (int)this.width, (int)10, (Font)this.font, (Component)subtitle));
        subtitleLabel.setShadow(true);
        subtitleLabel.setTextColor(-1);
        subtitleLabel.setHorizontalAlignment(HorizontalAlignment.CENTER);
        if (itemStack.isEmpty()) {
            this.addError();
            return;
        }
        HealItemAttributes attributes = (HealItemAttributes)itemStack.get(MedSystemItemComponents.HEAL_ATTRIBUTES);
        if (attributes == null) {
            this.addError();
            return;
        }
        HealthContainer container = (HealthContainer)target.getData(MedSystemDataAttachments.HEALTH_CONTAINER);
        HealthContainerDefinition definition = container.getDefinition();
        List<BodyPartDisplay> displays = definition.getDisplayConfiguration();
        Vector2f center = new Vector2f((float)this.width / 2.0f, (float)this.height / 2.0f);
        float scale = (float)this.width / 256.0f;
        ArrayList<BodyPartHealthWidget> healthWidgets = new ArrayList<BodyPartHealthWidget>();
        for (BodyPartDisplay display : displays) {
            Limb part = container.getLimb(display.source());
            if (part == null) continue;
            Vector4i rect = display.getPositionForGui(scale, center);
            boolean isPartHealable = attributes.canUseOnPart(part, itemStack, container, this.selfHealing, (LivingEntity)target);
            BodyPartWidget widget = (BodyPartWidget)this.addRenderableWidget((GuiEventListener)new BodyPartWidget(rect.x, rect.y, rect.z, rect.w, part, this.font, this));
            widget.setScale(3);
            widget.setColorProvider(value -> {
                HealthOverlayConfiguration overlay = MedicalSystemClient.getConfig().healthOverlay;
                if (isPartHealable) {
                    return HealthLayer.getColor(overlay.deadLimbColor, overlay.colorSchema, value) | 0xFF000000;
                }
                return Integer.decode(overlay.deadLimbColor) | 0xFF000000;
            });
            widget.addTooltip((Component)part.getDisplayName().copy().withStyle(new ChatFormatting[]{ChatFormatting.BOLD, isPartHealable ? ChatFormatting.GREEN : ChatFormatting.RED}));
            Stream<StatusEffect> stream = part.getStatusEffects().getEffectsStream();
            if (container.getRootLimb().getLimbCode().equals(part.getLimbCode())) {
                stream = Stream.concat(container.getGlobalStatusEffects().getEffectsStream(), stream);
            }
            List<StatusEffect> effects = stream.filter(ef -> StatusEffectType.isVisible(ef, EffectVisibility.UI)).toList();
            int healthWidth = 80;
            int healthHeight = effects.isEmpty() ? 20 : 33;
            int xOffset = (int)((float)rect.x + (float)rect.z / 2.0f - center.x);
            int healthX = HealthScreen.getHealthLabelWidgetX(xOffset, rect.x, healthWidth, rect.z);
            int healthY = rect.y + (rect.w - healthHeight) / 2;
            BodyPartHealthWidget healthWidget = new BodyPartHealthWidget(healthX, healthY, healthWidth, healthHeight, this.font, part, this);
            healthWidget.setHealthUnitScale(10.0f);
            healthWidget.setEffects(effects);
            healthWidget.setFrameColor(isPartHealable ? widget.getColor() : -16777216);
            healthWidget.setFrameHoverColor(isPartHealable ? -256 : -16777216);
            healthWidget.setTextColor(isPartHealable ? widget.getColor() : -12303292);
            healthWidget.setEffectDetail(false);
            healthWidget.setTextHoverColor(isPartHealable ? -256 : -6710887);
            healthWidget.setClickListener(() -> this.bodyPartClicked(part));
            healthWidgets.add(healthWidget);
            if (isPartHealable) {
                widget.setOnClick(() -> this.bodyPartClicked(part));
                widget.addTooltip(LABEL_CLICK_TO_SELECT);
                continue;
            }
            widget.addTooltip(LABEL_NOT_HEALABLE);
        }
        healthWidgets.forEach(x$0 -> {
            BodyPartHealthWidget cfr_ignored_0 = (BodyPartHealthWidget)this.addRenderableWidget((GuiEventListener)x$0);
        });
    }

    public boolean isPauseScreen() {
        return false;
    }

    private void bodyPartClicked(Limb part) {
        InteractionTarget target = new InteractionTarget(this.selfHealing, this.entityId, part.getLimbCode());
        PacketDistributor.sendToServer((CustomPacketPayload)new C2S_SelectBodyPart(target), (CustomPacketPayload[])new CustomPacketPayload[0]);
        this.minecraft.setScreen(null);
    }

    private void addError() {
        LabelRenderable error = (LabelRenderable)this.addRenderableOnly((Renderable)LabelRenderable.fromComponent((int)0, (int)0, (int)this.width, (int)this.height, (Font)this.font, (Component)LABEL_ERROR));
        error.setHorizontalAlignment(HorizontalAlignment.CENTER);
        error.setTextColor(-65536);
        error.setShadow(true);
    }
}

