/*
 * Decompiled with CFR 0.152.
 */
package tnt.tarkovcraft.medsystem.common.health.math;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import tnt.tarkovcraft.medsystem.common.health.DamageContext;
import tnt.tarkovcraft.medsystem.common.health.HealthContainer;
import tnt.tarkovcraft.medsystem.common.health.HitResult;
import tnt.tarkovcraft.medsystem.common.health.Limb;
import tnt.tarkovcraft.medsystem.common.health.math.DamageDistributor;

public class PoisonDamageDistributor
implements DamageDistributor {
    public static final PoisonDamageDistributor INSTANCE = new PoisonDamageDistributor();

    @Override
    public Map<Limb, Float> distribute(DamageContext context, HealthContainer container, float damage) {
        int vitalLimbsCount = container.getVitalLimbs().size();
        float vitalDmgCutoff = 1.0f / (float)vitalLimbsCount - 0.01f;
        List<Limb> limbs = context.getHits().stream().map(HitResult::limb).filter(limb -> {
            if (limb.isVital()) {
                return limb.getHealth() > vitalDmgCutoff;
            }
            return !limb.isDead();
        }).toList();
        float perLimb = damage / (float)limbs.size();
        HashMap<Limb, Float> damageMap = new HashMap<Limb, Float>();
        for (HitResult hit : context.getHits()) {
            Limb limb2 = hit.limb();
            float f = limb2.isVital() ? limb2.getHealth() - vitalDmgCutoff : limb2.getHealth();
            float amount = Math.min(perLimb, f);
            if (!(amount > 0.0f)) continue;
            damageMap.put(limb2, Float.valueOf(amount));
        }
        return damageMap;
    }
}

