/*
 * Decompiled with CFR 0.152.
 */
package tnt.tarkovcraft.medsystem.common.init;

import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import tnt.tarkovcraft.medsystem.MedicalSystem;

public interface MedSystemDamageTypes {
    public static final ResourceKey<DamageType> FRACTURE = ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)MedicalSystem.resource("fracture"));
    public static final ResourceKey<DamageType> BLEED = ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)MedicalSystem.resource("bleed"));
    public static final ResourceKey<DamageType> TOXIC_SIDE_EFFECT = ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)MedicalSystem.resource("toxic_side_effect"));

    public static DamageSource causeFractureDamage(RegistryAccess access) {
        return new DamageSource(MedSystemDamageTypes.of(access, FRACTURE));
    }

    public static DamageSource causeBleedDamage(RegistryAccess access, Optional<Entity> cause) {
        Entity causingEntity = cause.orElse(null);
        return new DamageSource(MedSystemDamageTypes.of(access, BLEED), causingEntity);
    }

    public static DamageSource causeToxinDamage(RegistryAccess access) {
        return new DamageSource(MedSystemDamageTypes.of(access, TOXIC_SIDE_EFFECT));
    }

    public static Holder<DamageType> of(RegistryAccess access, ResourceKey<DamageType> type) {
        HolderLookup.RegistryLookup registry = access.lookupOrThrow(Registries.DAMAGE_TYPE);
        return registry.getOrThrow(type);
    }
}

