/*
 * Decompiled with CFR 0.152.
 */
package tnt.tarkovcraft.medsystem.common.status;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.Mth;
import tnt.tarkovcraft.medsystem.util.MedsystemCodecs;

public record BloodContainer(float capacity, float value, boolean refillable) {
    public static final Codec<BloodContainer> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)MedsystemCodecs.NON_NEGATIVE_FLOAT.fieldOf("capacity").forGetter(BloodContainer::capacity), (App)MedsystemCodecs.NON_NEGATIVE_FLOAT.optionalFieldOf("value", (Object)Float.valueOf(0.0f)).forGetter(BloodContainer::value), (App)Codec.BOOL.optionalFieldOf("refillable", (Object)true).forGetter(BloodContainer::refillable)).apply((Applicative)instance, BloodContainer::new));
    public static final StreamCodec<ByteBuf, BloodContainer> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.FLOAT, BloodContainer::capacity, (StreamCodec)ByteBufCodecs.FLOAT, BloodContainer::value, (StreamCodec)ByteBufCodecs.BOOL, BloodContainer::refillable, BloodContainer::new);

    public boolean isEmpty() {
        return this.value <= 0.0f;
    }

    public boolean isFull() {
        return this.value >= this.capacity;
    }

    public float getMissingCapacity() {
        return this.capacity - this.value;
    }

    public BloodContainer fill(float amount) {
        float newAmount = Mth.clamp((float)(this.value + amount), (float)0.0f, (float)this.capacity);
        return new BloodContainer(this.capacity, newAmount, this.refillable);
    }

    public BloodContainer extract(float amount) {
        float newAmount = Mth.clamp((float)(this.value - amount), (float)0.0f, (float)this.capacity);
        return new BloodContainer(this.capacity, newAmount, this.refillable);
    }
}

