/*
 * Decompiled with CFR 0.152.
 */
package tnt.tarkovcraft.core.client.screen;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import tnt.tarkovcraft.core.client.screen.CharacterSubScreen;
import tnt.tarkovcraft.core.client.screen.navigation.CoreNavigators;
import tnt.tarkovcraft.core.client.screen.widget.ListWidget;
import tnt.tarkovcraft.core.client.screen.widget.ScrollbarWidget;
import tnt.tarkovcraft.core.common.init.CoreDataAttachments;
import tnt.tarkovcraft.core.common.init.CoreRegistries;
import tnt.tarkovcraft.core.common.skill.Skill;
import tnt.tarkovcraft.core.common.skill.SkillData;
import tnt.tarkovcraft.core.common.skill.SkillDefinition;
import tnt.tarkovcraft.core.common.skill.stat.SkillStatDefinition;
import tnt.tarkovcraft.core.common.skill.stat.SkillStatDisplayInformation;
import tnt.tarkovcraft.core.common.skill.tracker.SkillTrackerDefinition;
import tnt.tarkovcraft.core.util.helper.ARGB;
import tnt.tarkovcraft.core.util.helper.Helper;
import tnt.tarkovcraft.core.util.helper.MathHelper;
import tnt.tarkovcraft.core.util.helper.RenderUtils;

public class SkillScreen
extends CharacterSubScreen {
    private SkillData skillData;
    private double scroll;

    public SkillScreen(Screen parent, UUID userId) {
        super(userId, CoreNavigators.SKILL_ENTRY);
    }

    @Override
    protected void init() {
        super.init();
        Player player = this.minecraft.level.getPlayerByUUID(this.characterProfileId);
        if (player == null) {
            return;
        }
        this.skillData = (SkillData)player.getData(CoreDataAttachments.SKILL);
        HolderLookup.RegistryLookup registry = this.minecraft.getConnection().registryAccess().lookupOrThrow(CoreRegistries.DatapackKeys.SKILL_DEFINITION);
        List<Skill> skills = registry.listElements().map(reference -> this.skillData.getSkill((SkillDefinition)reference.value())).toList();
        ListWidget skillView = (ListWidget)this.addRenderableWidget((GuiEventListener)new ListWidget<SkillWidget>(0, 25, this.width - 4, this.height - 25, skills, (skill, i) -> this.buildSkillWidget(player, (Skill)skill, i)));
        skillView.setBackgroundColor(0x44000000);
        skillView.setAdditionalItemSpacing(5);
        skillView.setScrollListener((x, y) -> {
            this.scroll = y;
        });
        skillView.setScroll(this.scroll);
        ScrollbarWidget scrollbar = (ScrollbarWidget)this.addRenderableWidget((GuiEventListener)new ScrollbarWidget(this.width - 4, 25, 4, this.height - 25, skillView));
        scrollbar.setBackground(0x44000000);
        this.initNotificationLayer();
    }

    private SkillWidget buildSkillWidget(Player player, Skill skill, int index) {
        SkillWidget widget = new SkillWidget(5, 5 + index * 40, this.width - 15, 35, this.font, skill, player, this);
        SkillDefinition definition = (SkillDefinition)skill.getDefinition().value();
        Collection<SkillTrackerDefinition> trackers = definition.getTrackers();
        ArrayList<Component> tooltip = new ArrayList<Component>();
        tooltip.add((Component)Component.translatable((String)"tooltip.tarkovcraft_core.skill.skill_info").withStyle(new ChatFormatting[]{ChatFormatting.BOLD, ChatFormatting.YELLOW}));
        trackers.stream().flatMap(def -> def.getInfoComponents().stream()).forEach(tooltip::add);
        widget.setDescription(tooltip);
        return widget;
    }

    public static final class SkillWidget
    extends AbstractWidget {
        private final Screen parent;
        private final Player player;
        private final Font font;
        private final Skill skill;
        private final ResourceLocation skillIcon;
        private List<Component> description;

        public SkillWidget(int x, int y, int width, int height, Font font, Skill skill, Player player, Screen parent) {
            super(x, y, width, height, CommonComponents.EMPTY);
            this.parent = parent;
            this.font = font;
            this.skill = skill;
            this.player = player;
            MutableComponent title = ((SkillDefinition)skill.getDefinition().value()).getName().copy();
            this.setMessage((Component)title.withStyle(new ChatFormatting[]{ChatFormatting.BOLD, ChatFormatting.UNDERLINE}));
            this.skillIcon = SkillDefinition.getIcon(skill.getDefinition());
        }

        public void setDescription(List<Component> description) {
            this.description = description;
        }

        protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
            boolean isMaxLevel = this.skill.isMaxLevel();
            guiGraphics.drawString(this.font, this.getMessage(), this.getX() + this.height + 3, this.getY() + 1, -1, true);
            RenderUtils.blitFull(guiGraphics, this.skillIcon, this.getX() + 1, this.getY() + 1, this.getX() + this.height - 1, this.getY() + this.height - 1, -1);
            guiGraphics.fillGradient(this.getX() + this.height + 2, this.getY() + 13, this.getRight(), this.getBottom() - 11, -9408400, ARGB.scaleRGB(-9408400, 0.6f));
            float experienceProgress = isMaxLevel ? 1.0f : this.skill.getExperience() / this.skill.getRequiredExperience();
            int width = this.getRight() - 1 - (this.getX() + this.height + 3);
            int expColor = -1520079;
            guiGraphics.fillGradient(this.getX() + this.height + 3, this.getY() + 14, this.getX() + this.height + 3 + Mth.ceil((float)(experienceProgress * (float)width)), this.getBottom() - 12, expColor, ARGB.scaleRGB(expColor, 0.8f));
            if (!isMaxLevel) {
                String expLabel = String.format(Locale.ROOT, "%.1f / %.1f", Float.valueOf(this.skill.getExperience()), Float.valueOf(this.skill.getRequiredExperience()));
                guiGraphics.drawString(this.font, expLabel, this.getRight() - this.font.width(expLabel), this.getBottom() - 9, ARGB.scaleRGB(-2039584, 0.7f), false);
            }
            Component levelMessage = isMaxLevel ? Skill.MAX_LEVEL : Component.translatable((String)"label.tarkovcraft_core.skill.level", (Object[])new Object[]{this.skill.getLevel(), this.skill.getMaxLevel()}).withColor(-2039584);
            guiGraphics.drawString(this.font, levelMessage, this.getX() + this.height + 3, this.getBottom() - 9, -1, false);
            int index = 0;
            SkillDefinition definition = (SkillDefinition)this.skill.getDefinition().value();
            for (SkillStatDefinition statDefinition : definition.getStats()) {
                if (!statDefinition.isAvailable(definition, this.skill, (Entity)this.player)) continue;
                SkillStatDisplayInformation displayInfo = statDefinition.display();
                int left = this.getRight() - 10 - index * 12;
                int right = left + 10;
                int top = this.getY();
                int bottom = top + 10;
                RenderUtils.blitFull(guiGraphics, displayInfo.icon(), left + 1, top + 1, right - 1, bottom - 1, -1);
                if (MathHelper.isWithinBounds(mouseX, mouseY, left, top, right - left, bottom - top)) {
                    MutableComponent name = displayInfo.name().copy().withStyle(ChatFormatting.UNDERLINE).withStyle(ChatFormatting.YELLOW);
                    Component statDescription = displayInfo.getDescription(definition, this.skill, (Entity)this.player, statDefinition.stat());
                    this.parent.setTooltipForNextRenderPass(RenderUtils.splitTooltip(Arrays.asList(name, statDescription), this.font));
                }
                ++index;
            }
            if (MathHelper.isWithinBounds(mouseX, mouseY, this.getX(), this.getY(), this.height, this.height) && Helper.isNotEmpty(this.description)) {
                this.parent.setTooltipForNextRenderPass(RenderUtils.splitTooltip(this.description, this.font));
            }
        }

        public boolean mouseClicked(double mouseX, double mouseY, int button) {
            return false;
        }

        protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
        }
    }
}

