/*
 * Decompiled with CFR 0.152.
 */
package tnt.tarkovcraft.core.common.attribute;

import java.util.Objects;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import tnt.tarkovcraft.core.common.attribute.AttributeInstance;

public final class Attribute {
    private final ResourceLocation identifier;
    private final double baseValue;

    private Attribute(ResourceLocation identifier, double baseValue) {
        this.identifier = identifier;
        this.baseValue = baseValue;
    }

    public AttributeInstance createInstance(Entity holder) {
        return new AttributeInstance(this, holder);
    }

    public static Attribute create(ResourceLocation identifier, double baseValue) {
        return new Attribute(identifier, baseValue);
    }

    public static Attribute createBool(ResourceLocation identifier, boolean value) {
        return Attribute.create(identifier, value ? 1.0 : 0.0);
    }

    public static Attribute trueBool(ResourceLocation identifier) {
        return Attribute.createBool(identifier, true);
    }

    public static Attribute falseBool(ResourceLocation identifier) {
        return Attribute.createBool(identifier, false);
    }

    public static Attribute create(ResourceLocation identifier) {
        return Attribute.create(identifier, 0.0);
    }

    public ResourceLocation identifier() {
        return this.identifier;
    }

    public double getBaseValue() {
        return this.baseValue;
    }

    public Component getDisplayName() {
        return Component.translatable((String)this.identifier.toLanguageKey("attribute"));
    }

    public boolean equals(Object o) {
        if (!(o instanceof Attribute)) {
            return false;
        }
        Attribute attribute = (Attribute)o;
        return Objects.equals(this.identifier, attribute.identifier);
    }

    public int hashCode() {
        return Objects.hashCode(this.identifier);
    }

    public String toString() {
        return "Attribute{identifier=" + String.valueOf(this.identifier) + ", baseValue=" + this.baseValue + "}";
    }
}

