/*
 * Decompiled with CFR 0.152.
 */
package tnt.tarkovcraft.core.common.skill;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.resources.RegistryFixedCodec;
import net.minecraft.resources.ResourceLocation;
import tnt.tarkovcraft.core.common.attribute.Attribute;
import tnt.tarkovcraft.core.common.init.CoreRegistries;
import tnt.tarkovcraft.core.common.skill.Skill;
import tnt.tarkovcraft.core.common.skill.SkillLevelDefinition;
import tnt.tarkovcraft.core.common.skill.SkillMemoryConfiguration;
import tnt.tarkovcraft.core.common.skill.stat.SkillStatDefinition;
import tnt.tarkovcraft.core.common.skill.tracker.SkillTrackerDefinition;

public class SkillDefinition {
    public static final Codec<SkillDefinition> DIRECT_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.optionalFieldOf("enabled", (Object)true).forGetter(t -> t.enabled), (App)ResourceLocation.CODEC.fieldOf("identifier").forGetter(t -> t.identifier), (App)ComponentSerialization.CODEC.fieldOf("description").forGetter(t -> t.name), (App)SkillLevelDefinition.CODEC.optionalFieldOf("leveling", (Object)SkillLevelDefinition.DEFAULT).forGetter(t -> t.levelDefinition), (App)SkillMemoryConfiguration.CODEC.optionalFieldOf("memory", (Object)SkillMemoryConfiguration.NO_LOSS).forGetter(t -> t.memory), (App)CoreRegistries.ATTRIBUTE.holderByNameCodec().listOf().optionalFieldOf("groupLevelModifiers", Collections.emptyList()).forGetter(t -> t.groupLevelingModifiers), (App)SkillTrackerDefinition.CODEC.listOf().fieldOf("trackers").forGetter(t -> t.trackers), (App)SkillStatDefinition.CODEC.listOf().fieldOf("stats").forGetter(t -> t.stats)).apply((Applicative)instance, SkillDefinition::new));
    public static final Codec<Holder<SkillDefinition>> CODEC = RegistryFixedCodec.create(CoreRegistries.DatapackKeys.SKILL_DEFINITION);
    private final boolean enabled;
    private final ResourceLocation identifier;
    private final Component name;
    private final SkillLevelDefinition levelDefinition;
    private final SkillMemoryConfiguration memory;
    private final List<Holder<Attribute>> groupLevelingModifiers;
    private final List<SkillTrackerDefinition> trackers;
    private final List<SkillStatDefinition> stats;

    public SkillDefinition(boolean enabled, ResourceLocation identifier, Component name, SkillLevelDefinition levelDefinition, SkillMemoryConfiguration memory, List<Holder<Attribute>> groupLevelingModifiers, List<SkillTrackerDefinition> trackers, List<SkillStatDefinition> stats) {
        this.enabled = enabled;
        this.identifier = identifier;
        this.name = name;
        this.levelDefinition = levelDefinition;
        this.memory = memory;
        this.groupLevelingModifiers = groupLevelingModifiers;
        this.trackers = trackers;
        this.stats = stats;
    }

    public static ResourceLocation getIcon(Holder<SkillDefinition> holder) {
        ResourceLocation skillIdentifier = holder.getKey().location();
        return skillIdentifier.withPath(pth -> "textures/icons/skill/" + pth + ".png");
    }

    public Skill instance(RegistryAccess access) {
        HolderLookup.RegistryLookup registry = access.lookupOrThrow(CoreRegistries.DatapackKeys.SKILL_DEFINITION);
        Holder.Reference reference = registry.listElements().filter(ref -> ((SkillDefinition)ref.value()).getIdentifier().equals((Object)this.identifier)).findFirst().orElseThrow();
        return new Skill((Holder<SkillDefinition>)reference);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public ResourceLocation getIdentifier() {
        return this.identifier;
    }

    public SkillLevelDefinition getLevelDefinition() {
        return this.levelDefinition;
    }

    public SkillMemoryConfiguration getMemory() {
        return this.memory;
    }

    public List<Holder<Attribute>> getGroupLevelingModifiers() {
        return this.groupLevelingModifiers;
    }

    public Collection<SkillTrackerDefinition> getTrackers() {
        return this.trackers;
    }

    public List<SkillStatDefinition> getStats() {
        return this.stats;
    }

    public Component getName() {
        return this.name;
    }
}

