/*
 * Decompiled with CFR 0.152.
 */
package tnt.tarkovcraft.core.compatibility;

import java.util.concurrent.Callable;
import net.neoforged.fml.ModList;

public final class ModIntegrationHelper {
    public static boolean isLoaded(String modId) {
        return ModList.get().isLoaded(modId);
    }

    public static void run(String modId, Runnable action) {
        if (ModIntegrationHelper.isLoaded(modId)) {
            action.run();
        }
    }

    public static <T> T call(String modId, Callable<T> action) {
        return ModIntegrationHelper.call(modId, action, null);
    }

    public static <T> T call(String modId, Callable<T> action, T defaultValue) {
        if (ModIntegrationHelper.isLoaded(modId)) {
            try {
                return action.call();
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to execute mod specific action for mod " + modId, e);
            }
        }
        return defaultValue;
    }
}

