/*
 * Decompiled with CFR 0.152.
 */
package tnt.tarkovcraft.core.util;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Encoder;
import io.netty.buffer.ByteBuf;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ExtraCodecs;
import tnt.tarkovcraft.core.util.helper.ARGB;

public final class Codecs {
    public static final Codec<ZonedDateTime> ZONED_DATE_TIME_CODEC = Codec.STRING.comapFlatMap(raw -> {
        try {
            ZonedDateTime zdt = ZonedDateTime.parse(raw);
            return DataResult.success((Object)zdt);
        }
        catch (Exception e) {
            return DataResult.error(() -> "Failed to parse ZonedDateTime due to error " + e.getMessage());
        }
    }, ZonedDateTime::toString);
    public static final Codec<Integer> HEX_RGB_COLOR_CODEC = Codec.STRING.comapFlatMap(string -> {
        try {
            int value = Integer.decode(string);
            return DataResult.success((Object)(value & 0xFFFFFF));
        }
        catch (NumberFormatException e) {
            return DataResult.error(() -> "Failed to parse hex color due to error " + e.getMessage());
        }
    }, Integer::toHexString);
    public static final Codec<Integer> RGB_COLOR_CODEC = Codec.withAlternative((Codec)Codec.INT, (Codec)ExtraCodecs.VECTOR3F, p_370488_ -> ARGB.colorFromFloat(1.0f, p_370488_.x(), p_370488_.y(), p_370488_.z()));
    public static final Codec<Integer> RGB_COLOR = Codec.withAlternative(RGB_COLOR_CODEC, HEX_RGB_COLOR_CODEC);
    public static final Codec<Integer> NON_NEGATIVE_INT = Codec.intRange((int)0, (int)Integer.MAX_VALUE);
    public static final Codec<Float> NON_NEGATIVE_FLOAT = Codec.floatRange((float)0.0f, (float)Float.MAX_VALUE);
    public static final StreamCodec<ByteBuf, Long> LONG_STREAM_CODEC = new StreamCodec<ByteBuf, Long>(){

        public Long decode(ByteBuf buffer) {
            return buffer.readLong();
        }

        public void encode(ByteBuf buffer, Long value) {
            buffer.writeLong(value.longValue());
        }
    };

    @Deprecated
    public static <E extends Enum<E>> Codec<E> simpleEnumCodec(Class<E> type) {
        return Codecs.enumCodec(type, Function.identity());
    }

    @Deprecated
    public static <E extends Enum<E>> Codec<E> enumCodec(Class<E> type) {
        return Codecs.enumCodec(type, str -> str.toUpperCase(Locale.ROOT));
    }

    @Deprecated
    public static <E extends Enum<E>> Codec<E> enumCodec(Class<E> type, Function<String, String> inputOp) {
        return Codec.STRING.comapFlatMap(str -> {
            try {
                return DataResult.success(Enum.valueOf(type, (String)inputOp.apply((String)str)));
            }
            catch (IllegalArgumentException e) {
                return DataResult.error(() -> "Failed to parse enum value due to error " + e.getMessage());
            }
        }, Enum::name);
    }

    @Deprecated
    public static <R, T> R serialize(DynamicOps<R> ops, Codec<T> codec, T data) {
        DataResult result = codec.encodeStart(ops, data);
        return (R)result.getOrThrow();
    }

    @Deprecated
    public static <R, T> T deserialize(DynamicOps<R> ops, Codec<T> codec, R input) {
        DataResult result = codec.parse(ops, input);
        return (T)result.getOrThrow();
    }

    @Deprecated
    public static <T> CompoundTag serializeNbtCompound(Codec<T> codec, T obj) {
        DataResult result = codec.encodeStart((DynamicOps)NbtOps.INSTANCE, obj);
        CompoundTag tag = new CompoundTag();
        tag.put("data", (Tag)result.getOrThrow());
        return tag;
    }

    public static <T> Codec<List<T>> list(Codec<T> elementCodec, int minCount, int maxCount) {
        return Codec.withAlternative((Codec)elementCodec.listOf(minCount, maxCount), elementCodec, Collections::singletonList);
    }

    public static <T> Codec<List<T>> lowerBoundList(Codec<T> elementCodec, int minCount) {
        return Codecs.list(elementCodec, minCount, Integer.MAX_VALUE);
    }

    public static <T> Codec<List<T>> upperBoundList(Codec<T> elementCodec, int maxCount) {
        return Codecs.list(elementCodec, 0, maxCount);
    }

    public static <T> Codec<List<T>> list(Codec<T> elementCodec) {
        return Codecs.list(elementCodec, 0, Integer.MAX_VALUE);
    }

    public static <T> Codec<Set<T>> hashSet(Codec<T> elementCodec) {
        return Codecs.set(elementCodec, HashSet::new);
    }

    public static <T> Codec<Set<T>> linkedHashSet(Codec<T> elementCodec) {
        return Codecs.set(elementCodec, LinkedHashSet::new);
    }

    @Deprecated
    public static <E extends Enum<E>> Codec<Set<E>> enumSet(Codec<E> enumCodec) {
        return Codecs.set(enumCodec, EnumSet::copyOf);
    }

    @Deprecated
    public static <E extends Enum<E>> Codec<Set<E>> enumSet(Class<E> enumType) {
        return Codecs.enumSet(Codecs.enumCodec(enumType));
    }

    public static <T> Codec<Set<T>> set(Codec<T> codec, Function<List<T>, Set<T>> setProvider) {
        return Codecs.list(codec).xmap(setProvider, ArrayList::new);
    }

    public static <T, C extends Collection<T>> Codec<C> collection(Codec<T> codec, int minCount, int maxCount, Function<List<T>, C> toCollection, Function<C, List<T>> fromCollection) {
        return Codecs.list(codec, minCount, maxCount).xmap(toCollection, fromCollection);
    }

    public static <T, C extends Collection<T>> Codec<C> lowerBoundCollection(Codec<T> codec, int minCount, Function<List<T>, C> toCollection, Function<C, List<T>> fromCollection) {
        return Codecs.lowerBoundList(codec, minCount).xmap(toCollection, fromCollection);
    }

    public static <T, C extends Collection<T>> Codec<C> upperBoundCollection(Codec<T> codec, int maxCount, Function<List<T>, C> toCollection, Function<C, List<T>> fromCollection) {
        return Codecs.upperBoundList(codec, maxCount).xmap(toCollection, fromCollection);
    }

    public static <T, C extends Collection<T>> Codec<C> collection(Codec<T> codec, Function<List<T>, C> toCollection, Function<C, List<T>> fromCollection) {
        return Codecs.collection(codec, 0, Integer.MAX_VALUE, toCollection, fromCollection);
    }

    @Deprecated
    public static <T> T deserializeNbtCompound(Codec<T> codec, CompoundTag tag) {
        Tag data = tag.get("data");
        DataResult result = codec.parse((DynamicOps)NbtOps.INSTANCE, (Object)data);
        return (T)result.getOrThrow();
    }

    @Deprecated
    public static <T> Codec<T> dynamicCodec(final Encoder<T> encoder, final Decoder<T> decoder) {
        return new Codec<T>(){

            public <T1> DataResult<Pair<T, T1>> decode(DynamicOps<T1> ops, T1 input) {
                return decoder.decode(ops, input);
            }

            public <T1> DataResult<T1> encode(T input, DynamicOps<T1> ops, T1 prefix) {
                return encoder.encode(input, ops, prefix);
            }
        };
    }
}

