/*
 * Decompiled with CFR 0.152.
 */
package tnt.tarkovcraft.core.util.helper;

import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import org.joml.Matrix4f;
import org.joml.Vector2f;
import tnt.tarkovcraft.core.util.ScreenPositionCalculator;
import tnt.tarkovcraft.core.util.helper.ARGB;

public final class RenderUtils {
    public static boolean isVisibleColor(int color) {
        return RenderUtils.isNotTransparent(color, 0);
    }

    public static boolean isNotTransparent(int color, int limit) {
        int a = ARGB.alpha(color);
        return a > limit;
    }

    public static void blitFull(GuiGraphics graphics, ResourceLocation icon, int x1, int y1, int x2, int y2) {
        RenderUtils.blitFull(graphics, icon, x1, y1, x2, y2, -1);
    }

    public static void blitFull(GuiGraphics graphics, ResourceLocation icon, int x1, int y1, int x2, int y2, int color) {
        graphics.innerBlit(icon, x1, x2, y1, y2, 0, 0.0f, 1.0f, 0.0f, 1.0f, ARGB.redFloat(color), ARGB.greenFloat(color), ARGB.blueFloat(color), ARGB.alphaFloat(color));
    }

    public static void fill(GuiGraphics graphics, float x1, float y1, float x2, float y2, int color) {
        RenderUtils.fillGradient(graphics, x1, y1, x2, y2, color, color);
    }

    public static void fillGradient(GuiGraphics graphics, float x1, float y1, float x2, float y2, int colorFrom, int colorTo) {
        VertexConsumer consumer = graphics.bufferSource().getBuffer(RenderType.gui());
        Matrix4f matrix4f = graphics.pose().last().pose();
        consumer.addVertex(matrix4f, x1, y1, 0.0f).setColor(colorFrom);
        consumer.addVertex(matrix4f, x1, y2, 0.0f).setColor(colorTo);
        consumer.addVertex(matrix4f, x2, y2, 0.0f).setColor(colorTo);
        consumer.addVertex(matrix4f, x2, y1, 0.0f).setColor(colorFrom);
        graphics.flushIfUnmanaged();
    }

    public static void fillDarkenGradient(GuiGraphics graphics, float x1, float y1, float x2, float y2, int colorFrom, float rgbScale) {
        RenderUtils.fillGradient(graphics, x1, y1, x2, y2, colorFrom, ARGB.scaleRGB(colorFrom, rgbScale));
    }

    public static void fillDarkenGradient(GuiGraphics graphics, float x1, float y1, float x2, float y2, int colorFrom) {
        RenderUtils.fillDarkenGradient(graphics, x1, y1, x2, y2, colorFrom, 0.8f);
    }

    public static Vector2f getPosition(float x1, float y1, float x2, float y2, float width, float height, ScreenPositionCalculator horizontal, ScreenPositionCalculator vertical) {
        float x = horizontal.getPosition(x1, x2, width);
        float y = vertical.getPosition(y1, y2, height);
        return new Vector2f(x, y);
    }

    public static List<FormattedCharSequence> splitTooltip(List<Component> lines, Font font) {
        return lines.stream().flatMap(text -> font.split((FormattedText)text, 170).stream()).toList();
    }
}

