/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.configuration.client.screen;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.toma.configuration.Configuration;
import dev.toma.configuration.ConfigurationSettings;
import dev.toma.configuration.client.ConfigurationClient;
import dev.toma.configuration.client.screen.ConfigSettingsScreen;
import dev.toma.configuration.client.screen.DialogScreen;
import dev.toma.configuration.client.theme.ConfigTheme;
import dev.toma.configuration.client.widget.ConfigEntryWidget;
import dev.toma.configuration.client.widget.ThemedButtonWidget;
import dev.toma.configuration.client.widget.render.TextureRenderer;
import dev.toma.configuration.config.ConfigHolder;
import dev.toma.configuration.config.io.ConfigIO;
import dev.toma.configuration.config.validate.IValidationResult;
import dev.toma.configuration.config.value.ConfigValue;
import dev.toma.configuration.config.value.ObjectValue;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public abstract class AbstractConfigScreen
extends Screen
implements ConfigEntryWidget.IValidationRenderer {
    public static final int HEADER_HEIGHT = 35;
    public static final int FOOTER_HEIGHT = 30;
    public static final WidgetSprites BUTTON_SPRITES = new WidgetSprites(ResourceLocation.withDefaultNamespace((String)"widget/button"), ResourceLocation.withDefaultNamespace((String)"widget/button_disabled"), ResourceLocation.withDefaultNamespace((String)"widget/button_highlighted"));
    public static final Marker MARKER = MarkerManager.getMarker((String)"Screen");
    public static final Component LABEL_BACK = Component.translatable((String)"text.configuration.value.back");
    public static final Component LABEL_SAVE_AND_CLOSE = Component.translatable((String)"text.configuration.value.save_and_close");
    public static final ResourceLocation ICON_REVERT = ResourceLocation.fromNamespaceAndPath((String)"configuration", (String)"textures/icons/revert.png");
    public static final ResourceLocation ICON_REVERT_DEFAULT = ResourceLocation.fromNamespaceAndPath((String)"configuration", (String)"textures/icons/revert_default.png");
    public static final ResourceLocation ICON_APPLY = ResourceLocation.fromNamespaceAndPath((String)"configuration", (String)"textures/icons/apply.png");
    protected final ConfigHolder<?> holder;
    protected final ConfigTheme theme;
    protected final Screen last;
    protected int index;
    protected int pageSize;
    private ThemedButtonWidget applyButton;
    private ThemedButtonWidget revertButton;
    private ThemedButtonWidget revertDefaultButton;

    public AbstractConfigScreen(Component title, Screen previous, ConfigHolder<?> configHolder) {
        super(title);
        this.holder = configHolder;
        this.theme = ConfigurationClient.getConfigTheme(configHolder);
        this.last = previous;
        ConfigurationSettings.loadSettings();
    }

    public String getConfigId() {
        return this.holder.getConfigId();
    }

    public void onClose() {
        super.onClose();
        this.saveConfig(true);
    }

    public static void renderScrollbar(GuiGraphics graphics, int x, int y, int width, int height, int index, int valueCount, int paging, int bgColor) {
        if (valueCount <= paging) {
            return;
        }
        double step = (double)height / (double)valueCount;
        int min = Mth.floor((double)((double)index * step));
        int max = Mth.ceil((double)((double)(index + paging) * step));
        int y1 = y + min;
        int y2 = y + max;
        graphics.fill(x, y, x + width, y + height, bgColor);
        graphics.fill(x, y1, x + width, y2, -7829368);
        graphics.fill(x, y1, x + width - 1, y2 - 1, -1118482);
        graphics.fill(x + 1, y1 + 1, x + width - 1, y2 - 1, -3355444);
    }

    protected void addSettingsButton() {
        ThemedButtonWidget settings = (ThemedButtonWidget)this.addRenderableWidget((GuiEventListener)new ThemedButtonWidget(this.width - 25, 5, 20, 20, (Component)Component.literal((String)"..."), this.theme));
        settings.setBackgroundRenderer(this.theme.getButtonBackground(settings));
        settings.setClickListener((widget, mouseX, mouseY) -> {
            ConfigSettingsScreen settingsScreen = new ConfigSettingsScreen(this);
            this.minecraft.setScreen((Screen)settingsScreen);
        });
        settings.setTooltip(Tooltip.create((Component)Component.translatable((String)"options.title")));
        settings.setTooltipDelay(Duration.ofMillis(300L));
    }

    protected void addFooter() {
        int centerY = this.height - 30 + 5;
        Component backLabel = this.isRoot() ? LABEL_SAVE_AND_CLOSE : LABEL_BACK;
        ThemedButtonWidget backButton = (ThemedButtonWidget)this.addRenderableWidget((GuiEventListener)new ThemedButtonWidget(5, centerY, 120, 20, backLabel, this.theme));
        backButton.setBackgroundRenderer(this.theme.getButtonBackground(backButton));
        backButton.setClickListener((widget, mouseX, mouseY) -> this.buttonBackClicked());
        this.applyButton = (ThemedButtonWidget)this.addRenderableWidget((GuiEventListener)new ThemedButtonWidget(this.width - 25, centerY, 20, 20, CommonComponents.EMPTY, this.theme));
        this.applyButton.setBackgroundRenderer(this.theme.getButtonBackground(this.applyButton));
        this.applyButton.setForegroundRenderer(new TextureRenderer(ICON_APPLY, 2, 2, 16, 16));
        this.applyButton.setClickListener((widget, mouseX, mouseY) -> {
            if (this.holder.isChanged()) {
                this.holder.save();
                this.init(this.minecraft, this.width, this.height);
            }
        });
        this.applyButton.setTooltip(Tooltip.create((Component)ConfigEntryWidget.APPLY));
        this.applyButton.setTooltipDelay(Duration.ofMillis(300L));
        this.applyButton.active = this.holder.isChanged();
        this.revertDefaultButton = (ThemedButtonWidget)this.addRenderableWidget((GuiEventListener)new ThemedButtonWidget(this.width - 50, centerY, 20, 20, CommonComponents.EMPTY, this.theme));
        this.revertDefaultButton.setBackgroundRenderer(this.theme.getButtonBackground(this.revertDefaultButton));
        this.revertDefaultButton.setForegroundRenderer(new TextureRenderer(ICON_REVERT_DEFAULT, 2, 2, 16, 16));
        this.revertDefaultButton.setClickListener((widget, mouseX, mouseY) -> this.buttonRevertToDefaultClicked());
        this.revertDefaultButton.setTooltip(Tooltip.create((Component)ConfigEntryWidget.REVERT_DEFAULTS));
        this.revertDefaultButton.setTooltipDelay(Duration.ofMillis(300L));
        this.revertDefaultButton.active = this.holder.isChangedFromDefault();
        this.revertButton = (ThemedButtonWidget)this.addRenderableWidget((GuiEventListener)new ThemedButtonWidget(this.width - 75, centerY, 20, 20, CommonComponents.EMPTY, this.theme));
        this.revertButton.setBackgroundRenderer(this.theme.getButtonBackground(this.revertButton));
        this.revertButton.setForegroundRenderer(new TextureRenderer(ICON_REVERT, 2, 2, 16, 16));
        this.revertButton.setClickListener((widget, mouseX, mouseY) -> this.buttonRevertChangesClicked());
        this.revertButton.setTooltip(Tooltip.create((Component)ConfigEntryWidget.REVERT_CHANGES));
        this.revertButton.setTooltipDelay(Duration.ofMillis(300L));
        this.revertButton.active = this.holder.isChanged();
    }

    public void tick() {
        if (this.applyButton != null) {
            this.applyButton.active = this.holder.isChanged();
        }
        if (this.revertDefaultButton != null) {
            this.revertDefaultButton.active = this.holder.isChangedFromDefault();
        }
        if (this.revertButton != null) {
            this.revertButton.active = this.holder.isChanged();
        }
    }

    protected void correctScrollingIndex(int count) {
        if (this.index + this.pageSize > count) {
            this.index = Math.max(count - this.pageSize, 0);
        }
    }

    protected boolean isRoot() {
        return !(this.last instanceof AbstractConfigScreen);
    }

    private void buttonBackClicked() {
        this.minecraft.setScreen(this.last);
        this.saveConfig();
    }

    private void buttonRevertToDefaultClicked() {
        DialogScreen dialog = new DialogScreen(ConfigEntryWidget.REVERT_DEFAULTS, new Component[]{ConfigEntryWidget.REVERT_DEFAULTS_DIALOG_TEXT}, this);
        dialog.onConfirmed(screen -> {
            Configuration.LOGGER.info(MARKER, "Reverting config {} to default values", (Object)this.getConfigId());
            this.revertToDefault(this.holder.values());
            ConfigIO.saveClientValues(this.holder);
            dialog.displayPreviousScreen();
        });
        this.minecraft.setScreen((Screen)dialog);
    }

    private void buttonRevertChangesClicked() {
        DialogScreen dialog = new DialogScreen(ConfigEntryWidget.REVERT_CHANGES, new Component[]{ConfigEntryWidget.REVERT_CHANGES_DIALOG_TEXT}, this);
        dialog.onConfirmed(screen -> {
            ConfigIO.reloadClientValues(this.holder);
            dialog.displayPreviousScreen();
        });
        this.minecraft.setScreen((Screen)dialog);
    }

    private void revertToDefault(Collection<ConfigValue<?>> configValues) {
        configValues.forEach(val -> {
            if (val instanceof ObjectValue) {
                ObjectValue objVal = (ObjectValue)val;
                this.revertToDefault(((Map)objVal.get()).values());
            } else if (val.isChangedFromDefault()) {
                val.forceSetDefaultValue();
            }
        });
    }

    private void saveConfig() {
        this.saveConfig(false);
    }

    private void saveConfig(boolean force) {
        if (force || this.isRoot()) {
            ConfigIO.saveClientValues(this.holder);
        }
    }

    @Override
    public void drawDescription(GuiGraphics graphics, AbstractWidget widget, List<FormattedCharSequence> text, IValidationResult.Severity severity, int textColor) {
        this.renderValidationText(severity, graphics, text, widget.getX() + 5, widget.getY() + widget.getHeight() + 10, textColor);
    }

    @Override
    public void drawIcon(GuiGraphics graphics, AbstractWidget widget, IValidationResult.Severity severity) {
        this.renderValidationIcon(severity, graphics, widget, widget.getX() - 22, widget.getY() + 1);
    }

    public void renderValidationIcon(IValidationResult.Severity severity, GuiGraphics graphics, AbstractWidget widget, int x, int y) {
        ResourceLocation icon = severity.iconPath;
        graphics.blit(icon, x, y, 0, 0.0f, 0.0f, 16, 16, 16, 16);
    }

    public void renderValidationText(IValidationResult.Severity severity, GuiGraphics graphics, List<FormattedCharSequence> texts, int mouseX, int mouseY, int textColor) {
        if (!texts.isEmpty()) {
            int maxTextWidth = 0;
            for (FormattedCharSequence textComponent : texts) {
                int textWidth = this.font.width(textComponent);
                if (textWidth <= maxTextWidth) continue;
                maxTextWidth = textWidth;
            }
            int startX = mouseX + 12;
            int startY = mouseY - 12;
            int heightOffset = 8;
            if (texts.size() > 1) {
                heightOffset += 2 + (texts.size() - 1) * 10;
            }
            if (startX + maxTextWidth > this.width) {
                startX -= 28 + maxTextWidth;
            }
            if (startY + heightOffset + 6 > this.height) {
                startY = this.height - heightOffset - 6;
            }
            PoseStack stack = graphics.pose();
            stack.pushPose();
            int background = severity.backgroundColor;
            int fadeMin = severity.backgroundFadeMinColor;
            int fadeMax = severity.backgroundFadeMaxColor;
            int zIndex = 400;
            graphics.fillGradient(startX - 3, startY - 4, startX + maxTextWidth + 3, startY - 3, zIndex, background, background);
            graphics.fillGradient(startX - 3, startY + heightOffset + 3, startX + maxTextWidth + 3, startY + heightOffset + 4, zIndex, background, background);
            graphics.fillGradient(startX - 3, startY - 3, startX + maxTextWidth + 3, startY + heightOffset + 3, zIndex, background, background);
            graphics.fillGradient(startX - 4, startY - 3, startX - 3, startY + heightOffset + 3, zIndex, background, background);
            graphics.fillGradient(startX + maxTextWidth + 3, startY - 3, startX + maxTextWidth + 4, startY + heightOffset + 3, zIndex, background, background);
            graphics.fillGradient(startX - 3, startY - 3 + 1, startX - 3 + 1, startY + heightOffset + 3 - 1, zIndex, fadeMin, fadeMax);
            graphics.fillGradient(startX + maxTextWidth + 2, startY - 3 + 1, startX + maxTextWidth + 3, startY + heightOffset + 3 - 1, zIndex, fadeMin, fadeMax);
            graphics.fillGradient(startX - 3, startY - 3, startX + maxTextWidth + 3, startY - 3 + 1, zIndex, fadeMin, fadeMin);
            graphics.fillGradient(startX - 3, startY + heightOffset + 2, startX + maxTextWidth + 3, startY + heightOffset + 3, zIndex, fadeMax, fadeMax);
            stack.translate(0.0, 0.0, (double)zIndex);
            for (int i = 0; i < texts.size(); ++i) {
                FormattedCharSequence textComponent = texts.get(i);
                graphics.drawString(this.font, textComponent, startX, startY, textColor, false);
                if (i == 0) {
                    startY += 2;
                }
                startY += 10;
            }
            stack.popPose();
        }
    }
}

