#version 150

uniform sampler2D DiffuseSampler;
uniform float Strength;

in vec2 texCoord;
out vec4 fragColor;

vec3 rgb2hsv(vec3 rgb) {
    float maxc = max(rgb.r, max(rgb.g, rgb.b));
    float minc = min(rgb.r, min(rgb.g, rgb.b));
    float delta = maxc - minc;

    float h = 0.0;
    if (delta > 0.00001) {
        if (maxc == rgb.r) {
            h = mod((rgb.g - rgb.b) / delta, 6.0);
        } else if (maxc == rgb.g) {
            h = (rgb.b - rgb.r) / delta + 2.0;
        } else {
            h = (rgb.r - rgb.g) / delta + 4.0;
        }
        h /= 6.0;
    }

    float s = (maxc <= 0.0) ? 0.0 : delta / maxc;
    float v = maxc;

    return vec3(h, s, v);
}

vec3 hsv2rgb(vec3 hsv) {
    float h = hsv.x * 6.0;
    float s = hsv.y;
    float v = hsv.z;

    int i = int(floor(h));
    float f = h - float(i);
    float p = v * (1.0 - s);
    float q = v * (1.0 - s * f);
    float t = v * (1.0 - s * (1.0 - f));

    if (i == 0) return vec3(v, t, p);
    if (i == 1) return vec3(q, v, p);
    if (i == 2) return vec3(p, v, t);
    if (i == 3) return vec3(p, q, v);
    if (i == 4) return vec3(t, p, v);
    return vec3(v, p, q);
}

void main() {
    vec4 color = texture(DiffuseSampler, texCoord);
    vec3 hsv = rgb2hsv(color.rgb);
    hsv.y = clamp(hsv.y * (1.0 + Strength), 0.0, 1.0);
    vec3 saturated = hsv2rgb(hsv);

    fragColor = vec4(saturated, color.a);
}