/*
 * Decompiled with CFR 0.152.
 */
package daot;

import com.mojang.blaze3d.systems.RenderSystem;
import daot.HookPoint;
import daot.ODMTickHandler;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.minecraft.class_1921;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_746;
import org.joml.Matrix4f;

@Environment(value=EnvType.CLIENT)
public class HookLineRenderer {
    private static final int SEGMENTS = 30;
    private static final double BASE_SAG = 0.2;
    private static final double VELOCITY_BEND_FACTOR = 0.5;
    private static final double MAX_BEND = 0.1;
    private static final double REFERENCE_DISTANCE = 15.0;
    private static final double ZIGZAG_AMPLITUDE = 0.3;
    private static final int ZIGZAG_FREQUENCY = 4;
    private static final double MAX_NORMAL_DISTANCE = 65.0;
    private static class_243 smoothedLeftBend = class_243.field_1353;
    private static class_243 smoothedRightBend = class_243.field_1353;
    private static final double SMOOTHING_FACTOR = 0.15;

    public static void register() {
        WorldRenderEvents.BEFORE_DEBUG_RENDER.register(HookLineRenderer::renderHookLines);
    }

    private static void renderHookLines(WorldRenderContext context) {
        class_243 hookEnd;
        class_310 mc = class_310.method_1551();
        class_746 player = mc.field_1724;
        if (player == null) {
            return;
        }
        HookPoint leftHook = ODMTickHandler.getLeftHook(player.method_5667());
        HookPoint rightHook = ODMTickHandler.getRightHook(player.method_5667());
        class_4587 poseStack = context.matrixStack();
        class_4597.class_4598 bufferSource = mc.method_22940().method_23000();
        RenderSystem.enableDepthTest();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.lineWidth((float)12.0f);
        class_243 cameraPos = context.camera().method_19326();
        float partialTick = context.tickCounter().method_60637(true);
        class_243 playerPos = player.method_30950(partialTick);
        float yaw = (float)Math.toRadians(player.method_36454());
        double legOffset = 0.3;
        class_243 leftLegPos = playerPos.method_1031(Math.cos(yaw) * legOffset, 0.6, Math.sin(yaw) * legOffset);
        class_243 rightLegPos = playerPos.method_1031(-Math.cos(yaw) * legOffset, 0.6, -Math.sin(yaw) * legOffset);
        if (leftHook != null && leftHook.active) {
            hookEnd = leftHook.getCurrentPosition();
            smoothedLeftBend = HookLineRenderer.smoothBend(smoothedLeftBend, leftHook);
            if (leftHook.isExtending) {
                HookLineRenderer.renderZigzagLine(poseStack, bufferSource, leftLegPos, hookEnd, cameraPos, leftHook.getExtensionProgress());
            } else if (leftHook.isRetracting) {
                HookLineRenderer.renderZigzagLine(poseStack, bufferSource, leftLegPos, hookEnd, cameraPos, leftHook.getRetractionProgress());
            } else {
                HookLineRenderer.renderCurvedLine(poseStack, bufferSource, leftLegPos, hookEnd, cameraPos, smoothedLeftBend);
            }
        } else {
            smoothedLeftBend = class_243.field_1353;
        }
        if (rightHook != null && rightHook.active) {
            hookEnd = rightHook.getCurrentPosition();
            smoothedRightBend = HookLineRenderer.smoothBend(smoothedRightBend, rightHook);
            if (rightHook.isExtending) {
                HookLineRenderer.renderZigzagLine(poseStack, bufferSource, rightLegPos, hookEnd, cameraPos, rightHook.getExtensionProgress());
            } else if (rightHook.isRetracting) {
                HookLineRenderer.renderZigzagLine(poseStack, bufferSource, rightLegPos, hookEnd, cameraPos, rightHook.getRetractionProgress());
            } else {
                HookLineRenderer.renderCurvedLine(poseStack, bufferSource, rightLegPos, hookEnd, cameraPos, smoothedRightBend);
            }
        } else {
            smoothedRightBend = class_243.field_1353;
        }
        bufferSource.method_22993();
        RenderSystem.lineWidth((float)1.0f);
    }

    private static class_243 smoothBend(class_243 currentSmoothed, HookPoint hook) {
        class_243 velocity = hook.playerVelocity;
        class_243 targetBend = velocity.method_1021(-0.5);
        double bendMagnitude = targetBend.method_1033();
        if (bendMagnitude > 0.1) {
            targetBend = targetBend.method_1029().method_1021(0.1);
        }
        return currentSmoothed.method_35590(targetBend, 0.15);
    }

    private static void renderZigzagLine(class_4587 poseStack, class_4597.class_4598 bufferSource, class_243 start, class_243 end, class_243 cameraPos, float progress) {
        double effectiveFrequency;
        class_243 up;
        poseStack.method_22903();
        class_4588 buffer = bufferSource.getBuffer(class_1921.method_23594());
        Matrix4f matrix = poseStack.method_23760().method_23761();
        class_243 relativeStart = start.method_1020(cameraPos);
        class_243 relativeEnd = end.method_1020(cameraPos);
        double distance = start.method_1022(end);
        if (distance < 0.1) {
            buffer.method_22918(matrix, (float)relativeStart.field_1352, (float)relativeStart.field_1351, (float)relativeStart.field_1350).method_1336(0, 0, 0, 255).method_22914(0.0f, 1.0f, 0.0f);
            buffer.method_22918(matrix, (float)relativeEnd.field_1352, (float)relativeEnd.field_1351, (float)relativeEnd.field_1350).method_1336(0, 0, 0, 255).method_22914(0.0f, 1.0f, 0.0f);
            poseStack.method_22909();
            return;
        }
        class_243 direction = end.method_1020(start).method_1029();
        class_243 perpendicular = direction.method_1036(up = new class_243(0.0, 1.0, 0.0)).method_1029();
        if (perpendicular.method_1027() < 0.01) {
            perpendicular = direction.method_1036(new class_243(1.0, 0.0, 0.0)).method_1029();
        }
        class_243 prevPoint = relativeStart;
        if (distance <= 65.0) {
            effectiveFrequency = 4.0 * (distance / 15.0);
        } else {
            double baseFrequency = 17.333333333333332;
            int halvings = (int)Math.ceil((distance - 65.0) / 65.0);
            effectiveFrequency = baseFrequency / Math.pow(2.0, halvings);
        }
        for (int i = 1; i <= 30; ++i) {
            float t = (float)i / 30.0f;
            class_243 linearPoint = relativeStart.method_1019(relativeEnd.method_1020(relativeStart).method_1021((double)t));
            double wavePhase = (double)t * Math.PI * effectiveFrequency * 2.0;
            double waveOffset = Math.sin(wavePhase) * 0.3;
            double zigzagIntensity = 1.0 - (double)progress;
            class_243 offset = perpendicular.method_1021(waveOffset *= zigzagIntensity);
            class_243 zigzagPoint = linearPoint.method_1019(offset);
            buffer.method_22918(matrix, (float)prevPoint.field_1352, (float)prevPoint.field_1351, (float)prevPoint.field_1350).method_1336(0, 0, 0, 255).method_22914(0.0f, 1.0f, 0.0f);
            buffer.method_22918(matrix, (float)zigzagPoint.field_1352, (float)zigzagPoint.field_1351, (float)zigzagPoint.field_1350).method_1336(0, 0, 0, 255).method_22914(0.0f, 1.0f, 0.0f);
            prevPoint = zigzagPoint;
        }
        poseStack.method_22909();
    }

    private static void renderCurvedLine(class_4587 poseStack, class_4597.class_4598 bufferSource, class_243 start, class_243 end, class_243 cameraPos, class_243 bendOffset) {
        poseStack.method_22903();
        class_4588 buffer = bufferSource.getBuffer(class_1921.method_23594());
        Matrix4f matrix = poseStack.method_23760().method_23761();
        class_243 relativeStart = start.method_1020(cameraPos);
        class_243 relativeEnd = end.method_1020(cameraPos);
        double distance = start.method_1022(end);
        class_243 prevPoint = relativeStart;
        for (int i = 1; i <= 30; ++i) {
            float t = (float)i / 30.0f;
            class_243 linearPoint = relativeStart.method_1019(relativeEnd.method_1020(relativeStart).method_1021((double)t));
            double gravitySag = 0.2 * Math.sin((double)t * Math.PI) * distance / 10.0;
            double bendStrength = Math.sin((double)t * Math.PI);
            class_243 bend = bendOffset.method_1021(bendStrength * distance / 10.0);
            class_243 curvePoint = linearPoint.method_1031(0.0, -gravitySag, 0.0).method_1019(bend);
            buffer.method_22918(matrix, (float)prevPoint.field_1352, (float)prevPoint.field_1351, (float)prevPoint.field_1350).method_1336(0, 0, 0, 255).method_22914(0.0f, 1.0f, 0.0f);
            buffer.method_22918(matrix, (float)curvePoint.field_1352, (float)curvePoint.field_1351, (float)curvePoint.field_1350).method_1336(0, 0, 0, 255).method_22914(0.0f, 1.0f, 0.0f);
            prevPoint = curvePoint;
        }
        poseStack.method_22909();
    }
}

