/*
 * Decompiled with CFR 0.152.
 */
package daot;

import net.minecraft.class_1297;
import net.minecraft.class_243;

public class HookPoint {
    public class_243 position;
    public boolean active = false;
    public boolean isExtending = false;
    public boolean isRetracting = false;
    public class_243 startPosition;
    public long shootTime;
    public long retractTime;
    public class_243 playerVelocity = class_243.field_1353;
    public double maxRopeLength = 0.0;
    public class_1297 hookedEntity = null;
    public class_243 entityOffset = class_243.field_1353;
    public static final long SHOOT_DURATION = 150L;
    public static final long RETRACT_DURATION = 200L;

    public void setHook(class_243 targetPos, class_243 startPos) {
        this.position = targetPos;
        this.startPosition = startPos;
        this.active = true;
        this.isExtending = true;
        this.isRetracting = false;
        this.shootTime = System.currentTimeMillis();
    }

    public void setHookOnEntity(class_243 targetPos, class_243 startPos, class_1297 entity) {
        this.position = targetPos;
        this.startPosition = startPos;
        this.active = true;
        this.isExtending = true;
        this.isRetracting = false;
        this.shootTime = System.currentTimeMillis();
        this.hookedEntity = entity;
        this.entityOffset = targetPos.method_1020(entity.method_19538());
    }

    public void updateEntityPosition() {
        if (this.hookedEntity != null && !this.hookedEntity.method_31481()) {
            this.position = this.hookedEntity.method_19538().method_1019(this.entityOffset);
        } else if (this.hookedEntity != null && this.hookedEntity.method_31481()) {
            this.release();
        }
    }

    public void startRetract(class_243 playerPos) {
        this.isRetracting = true;
        this.isExtending = false;
        this.retractTime = System.currentTimeMillis();
        this.startPosition = playerPos;
    }

    public void release() {
        this.active = false;
        this.isExtending = false;
        this.isRetracting = false;
        this.playerVelocity = class_243.field_1353;
        this.maxRopeLength = 0.0;
        this.hookedEntity = null;
        this.entityOffset = class_243.field_1353;
    }

    public void updateVelocity(class_243 velocity) {
        this.playerVelocity = velocity;
    }

    public float getExtensionProgress() {
        if (!this.isExtending) {
            return 1.0f;
        }
        long elapsed = System.currentTimeMillis() - this.shootTime;
        float progress = Math.min(1.0f, (float)elapsed / 150.0f);
        if (progress >= 1.0f) {
            this.isExtending = false;
        }
        return progress;
    }

    public float getRetractionProgress() {
        if (!this.isRetracting) {
            return 0.0f;
        }
        long elapsed = System.currentTimeMillis() - this.retractTime;
        float progress = Math.min(1.0f, (float)elapsed / 200.0f);
        if (progress >= 1.0f) {
            this.release();
        }
        return progress;
    }

    public class_243 getCurrentPosition() {
        if (this.isRetracting) {
            float progress = this.getRetractionProgress();
            return this.position.method_35590(this.startPosition, (double)progress);
        }
        if (this.isExtending) {
            float progress = this.getExtensionProgress();
            return this.startPosition.method_35590(this.position, (double)progress);
        }
        return this.position;
    }
}

