/*
 * Decompiled with CFR 0.152.
 */
package daot;

import daot.DannysAot;
import daot.HookPoint;
import daot.ODMGearItem;
import daot.ODMTickHandler;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.minecraft.class_124;
import net.minecraft.class_1304;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_746;

@Environment(value=EnvType.CLIENT)
public class ODMGasHUD {
    private static String warningMessage = null;
    private static long warningEndTime = 0L;
    private static final String BAR_LEFT = "\u2282";
    private static final String BAR_RIGHT = "\u2283";
    private static final String BAR_FILLED = "\u039e";
    private static final String LEFT_HOOK_INDICATOR = "\u22d8 ";
    private static final String RIGHT_HOOK_INDICATOR = " \u22d9";
    private static final int GAS_FILLED_COLOR = 13937277;
    private static final int GAS_EMPTY_COLOR = 0x555555;
    private static final int BRACKET_COLOR = 0xFFFFFF;

    public static void register() {
        HudRenderCallback.EVENT.register((guiGraphics, tickCounter) -> {
            class_310 mc = class_310.method_1551();
            if (mc.field_1724 == null || mc.field_1690.field_1842) {
                return;
            }
            class_746 player = mc.field_1724;
            class_1799 chestItem = player.method_6118(class_1304.field_6174);
            if (chestItem.method_7909() != DannysAot.ODM_GEAR) {
                return;
            }
            int gas = ODMGearItem.getGas(chestItem);
            if (player.method_7337()) {
                gas = 500;
            }
            HookPoint leftHook = ODMTickHandler.getLeftHook(player.method_5667());
            HookPoint rightHook = ODMTickHandler.getRightHook(player.method_5667());
            boolean leftActive = leftHook != null && leftHook.active;
            boolean rightActive = rightHook != null && rightHook.active;
            long currentTime = System.currentTimeMillis();
            if (warningMessage != null && currentTime < warningEndTime) {
                ODMGasHUD.renderWarning(guiGraphics, mc, warningMessage);
            } else {
                warningMessage = null;
                ODMGasHUD.renderGasBar(guiGraphics, mc, gas, leftActive, rightActive);
            }
        });
    }

    private static int getActionBarY(class_332 guiGraphics) {
        return guiGraphics.method_51443() - 59;
    }

    private static void renderWarning(class_332 guiGraphics, class_310 mc, String message) {
        class_5250 text = class_2561.method_43470((String)message).method_27695(new class_124[]{class_124.field_1061, class_124.field_1067});
        int width = mc.field_1772.method_27525((class_5348)text);
        int x = (guiGraphics.method_51421() - width) / 2;
        int y = ODMGasHUD.getActionBarY(guiGraphics);
        guiGraphics.method_51439(mc.field_1772, (class_2561)text, x, y, 0xFF5555, true);
    }

    private static void renderGasBar(class_332 guiGraphics, class_310 mc, int gas, boolean leftActive, boolean rightActive) {
        int barsTotal = 10;
        int barsFilled = (int)Math.ceil((double)gas / 50.0);
        barsFilled = Math.min(barsTotal, Math.max(0, barsFilled));
        class_5250 gasBar = class_2561.method_43473();
        gasBar.method_10852((class_2561)class_2561.method_43470((String)BAR_LEFT).method_27696(class_2583.field_24360.method_36139(0xFFFFFF).method_10982(Boolean.valueOf(true))));
        for (int i = 0; i < barsTotal; ++i) {
            int color = i < barsFilled ? 13937277 : 0x555555;
            gasBar.method_10852((class_2561)class_2561.method_43470((String)BAR_FILLED).method_27696(class_2583.field_24360.method_36139(color)));
        }
        gasBar.method_10852((class_2561)class_2561.method_43470((String)BAR_RIGHT).method_27696(class_2583.field_24360.method_36139(0xFFFFFF).method_10982(Boolean.valueOf(true))));
        int gasBarWidth = mc.field_1772.method_27525((class_5348)gasBar);
        int gasBarX = (guiGraphics.method_51421() - gasBarWidth) / 2;
        int y = ODMGasHUD.getActionBarY(guiGraphics);
        guiGraphics.method_51439(mc.field_1772, (class_2561)gasBar, gasBarX, y, 0xFFFFFF, true);
        if (leftActive) {
            class_5250 leftIndicator = class_2561.method_43470((String)LEFT_HOOK_INDICATOR).method_27695(new class_124[]{class_124.field_1068, class_124.field_1067});
            int leftIndicatorWidth = mc.field_1772.method_27525((class_5348)leftIndicator);
            guiGraphics.method_51439(mc.field_1772, (class_2561)leftIndicator, gasBarX - leftIndicatorWidth, y, 0xFFFFFF, true);
        }
        if (rightActive) {
            class_5250 rightIndicator = class_2561.method_43470((String)RIGHT_HOOK_INDICATOR).method_27695(new class_124[]{class_124.field_1068, class_124.field_1067});
            guiGraphics.method_51439(mc.field_1772, (class_2561)rightIndicator, gasBarX + gasBarWidth, y, 0xFFFFFF, true);
        }
    }

    public static void showWarning(String message, int durationMs) {
        warningMessage = message;
        warningEndTime = System.currentTimeMillis() + (long)durationMs;
    }

    public static void showOutOfGas() {
        ODMGasHUD.showWarning("Out of gas!", 1500);
    }

    public static void showNoBladeOffhand() {
        ODMGasHUD.showWarning("No blade in offhand!", 1000);
    }

    public static void showNoBladeMainhand() {
        ODMGasHUD.showWarning("No blade in main hand!", 1000);
    }
}

