/*
 * Decompiled with CFR 0.152.
 */
package daot;

import daot.DannysAot;
import daot.DannysAotClient;
import daot.HookPoint;
import daot.ModSounds;
import daot.ODMGasHUD;
import daot.ODMGearItem;
import daot.ODMSoundManager;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_2388;
import net.minecraft.class_239;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3419;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_746;

@Environment(value=EnvType.CLIENT)
public class ODMTickHandler {
    private static final Map<UUID, HookPoint> leftHooks = new HashMap<UUID, HookPoint>();
    private static final Map<UUID, HookPoint> rightHooks = new HashMap<UUID, HookPoint>();
    private static final Map<UUID, Long> lastHookTime = new HashMap<UUID, Long>();
    private static final Map<UUID, Boolean> lastHookSide = new HashMap<UUID, Boolean>();
    private static final Map<UUID, Double> boostLevels = new HashMap<UUID, Double>();
    private static final Map<UUID, class_243> storedMomentum = new HashMap<UUID, class_243>();
    private static final Map<UUID, Integer> gasTickCounter = new HashMap<UUID, Integer>();
    private static final Map<UUID, Boolean> wasDualHooking = new HashMap<UUID, Boolean>();
    private static final Map<UUID, Long> dualHookStartTime = new HashMap<UUID, Long>();
    private static final long DUAL_HOOK_EASE_TIME = 2000L;
    private static final int GAS_TICK_INTERVAL = 10;
    private static final int GAS_CONSUMPTION_NORMAL = 1;
    private static final int GAS_CONSUMPTION_BOOST = 3;
    private static final double BASE_PULL_SPEED = 0.12;
    private static final double DUAL_HOOK_PULL_MULTIPLIER = 2.4;
    private static final double DUAL_HOOK_BOOST_PULL_MULTIPLIER = 1.5;
    private static final double ORBIT_PULL_MULTIPLIER = 1.8;
    private static final double BASE_ORBIT_SPEED = 0.08;
    private static final double DUAL_HOOK_ORBIT_MULTIPLIER = 0.4;
    private static final double UPWARD_LIFT = 0.05;
    private static final double BOOST_PULL_MULTIPLIER = 1.0;
    private static final double BOOST_ORBIT_MULTIPLIER = 2.5;
    private static final double BOOST_RAMP_RATE = 0.058823529411764705;
    private static final double BOOST_DECAY_RATE = 0.0125;
    private static final double MAX_HOOK_DISTANCE = 250.0;
    private static final long MOMENTUM_PRESERVE_TIME = 4500L;
    private static final double FLIGHT_SOUND_VELOCITY_THRESHOLD = 0.3;

    public static void register() {
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            class_243 momentum;
            long timeSinceHook;
            Long lastHook;
            boolean isHooked;
            class_1297 entity;
            boolean useFirstSound;
            class_243 hookPos;
            class_239 hit;
            if (client.field_1724 == null) {
                return;
            }
            class_746 player = client.field_1724;
            if (!ODMTickHandler.isWearingODMGear(player)) {
                ODMTickHandler.clearHooks(player);
                lastHookTime.remove(player.method_5667());
                ODMSoundManager.stopAllSounds(player);
                return;
            }
            HookPoint leftHook = leftHooks.computeIfAbsent(player.method_5667(), k -> new HookPoint());
            HookPoint rightHook = rightHooks.computeIfAbsent(player.method_5667(), k -> new HookPoint());
            leftHook.updateEntityPosition();
            rightHook.updateEntityPosition();
            boolean wasHooked = leftHook.active && !leftHook.isExtending && !leftHook.isRetracting || rightHook.active && !rightHook.isExtending && !rightHook.isRetracting;
            class_243 velocity = player.method_18798();
            leftHook.updateVelocity(velocity);
            rightHook.updateVelocity(velocity);
            float yaw = (float)Math.toRadians(player.method_36454());
            double legOffset = 0.3;
            class_243 playerPos = player.method_19538();
            class_243 leftLegPos = playerPos.method_1031(Math.cos(yaw) * legOffset, 0.1, Math.sin(yaw) * legOffset);
            class_243 rightLegPos = playerPos.method_1031(-Math.cos(yaw) * legOffset, 0.1, -Math.sin(yaw) * legOffset);
            boolean hasOffhandBlade = player.method_6079().method_7909() == DannysAot.BLADE;
            boolean hasMainhandBlade = player.method_6047().method_7909() == DannysAot.BLADE;
            class_1799 odmGear = player.method_6118(class_1304.field_6174);
            boolean hasGas = ODMGearItem.hasGas(odmGear, (class_1657)player);
            if (DannysAotClient.LEFT_HOOK_KEY.method_1434()) {
                if (!hasOffhandBlade) {
                    if (!leftHook.active) {
                        ODMGasHUD.showNoBladeOffhand();
                    }
                } else if (!hasGas) {
                    if (!leftHook.active) {
                        ODMGasHUD.showOutOfGas();
                    }
                } else if (!leftHook.active && (hit = ODMTickHandler.getPlayerLookTarget(player)) != null && hit.method_17783() != class_239.class_240.field_1333) {
                    hookPos = hit.method_17784();
                    useFirstSound = lastHookSide.getOrDefault(player.method_5667(), true);
                    player.method_5783(useFirstSound ? ModSounds.HOOK_SHOOT_1 : ModSounds.HOOK_SHOOT_2, 1.0f, 1.0f);
                    lastHookSide.put(player.method_5667(), !useFirstSound);
                    if (hit.method_17783() == class_239.class_240.field_1331) {
                        entity = ((class_3966)hit).method_17782();
                        leftHook.setHookOnEntity(hookPos, leftLegPos, entity);
                    } else {
                        leftHook.setHook(hookPos, leftLegPos);
                        client.field_1687.method_8486(hookPos.field_1352, hookPos.field_1351, hookPos.field_1350, ModSounds.HOOK_IMPACT, class_3419.field_15248, 0.8f, 1.0f, false);
                        ODMTickHandler.spawnHookImpactParticles(player, hookPos, hit);
                    }
                    leftHook.maxRopeLength = leftLegPos.method_1022(hookPos);
                }
            } else if (leftHook.active && !leftHook.isRetracting) {
                player.method_5783(ModSounds.HOOK_RETRACT, 0.7f, 1.0f);
                leftHook.startRetract(leftLegPos);
            }
            if (DannysAotClient.RIGHT_HOOK_KEY.method_1434()) {
                if (!hasMainhandBlade) {
                    if (!rightHook.active) {
                        ODMGasHUD.showNoBladeMainhand();
                    }
                } else if (!hasGas) {
                    if (!rightHook.active) {
                        ODMGasHUD.showOutOfGas();
                    }
                } else if (!rightHook.active && (hit = ODMTickHandler.getPlayerLookTarget(player)) != null && hit.method_17783() != class_239.class_240.field_1333) {
                    hookPos = hit.method_17784();
                    useFirstSound = lastHookSide.getOrDefault(player.method_5667(), true);
                    player.method_5783(useFirstSound ? ModSounds.HOOK_SHOOT_1 : ModSounds.HOOK_SHOOT_2, 1.0f, 1.0f);
                    lastHookSide.put(player.method_5667(), !useFirstSound);
                    if (hit.method_17783() == class_239.class_240.field_1331) {
                        entity = ((class_3966)hit).method_17782();
                        rightHook.setHookOnEntity(hookPos, rightLegPos, entity);
                    } else {
                        rightHook.setHook(hookPos, rightLegPos);
                        client.field_1687.method_8486(hookPos.field_1352, hookPos.field_1351, hookPos.field_1350, ModSounds.HOOK_IMPACT, class_3419.field_15248, 0.8f, 1.0f, false);
                        ODMTickHandler.spawnHookImpactParticles(player, hookPos, hit);
                    }
                    rightHook.maxRopeLength = rightLegPos.method_1022(hookPos);
                }
            } else if (rightHook.active && !rightHook.isRetracting) {
                player.method_5783(ModSounds.HOOK_RETRACT, 0.7f, 1.0f);
                rightHook.startRetract(rightLegPos);
            }
            boolean bl = isHooked = leftHook.active && !leftHook.isExtending && !leftHook.isRetracting || rightHook.active && !rightHook.isExtending && !rightHook.isRetracting;
            if (isHooked) {
                ODMTickHandler.applyHookMovement(player, leftHook, rightHook);
                lastHookTime.put(player.method_5667(), System.currentTimeMillis());
            } else {
                if (wasHooked && !isHooked) {
                    lastHookTime.put(player.method_5667(), System.currentTimeMillis());
                }
                ODMSoundManager.stopFlightSound(player);
                ODMSoundManager.stopGasBoostSound(player);
            }
            if (player.method_24828()) {
                boostLevels.put(player.method_5667(), 0.0);
                storedMomentum.remove(player.method_5667());
                lastHookTime.remove(player.method_5667());
            }
            if (!isHooked && !player.method_24828() && (lastHook = lastHookTime.get(player.method_5667())) != null && (timeSinceHook = System.currentTimeMillis() - lastHook) < 4500L && (momentum = storedMomentum.get(player.method_5667())) != null) {
                class_243 currentVel = player.method_18798();
                double blend = 1.0 - (double)timeSinceHook / 4500.0;
                blend = Math.max(0.0, Math.min(1.0, blend));
                class_243 blendedVel = new class_243(currentVel.field_1352 + momentum.field_1352 * blend * 0.02, currentVel.field_1351, currentVel.field_1350 + momentum.field_1350 * blend * 0.02);
                player.method_18799(blendedVel);
            }
        });
    }

    private static boolean isWearingODMGear(class_746 player) {
        return player.method_6118(class_1304.field_6174).method_7909() == DannysAot.ODM_GEAR;
    }

    private static class_239 getPlayerLookTarget(class_746 player) {
        double reachDistance = 250.0;
        class_243 eyePosition = player.method_33571();
        class_243 lookVector = player.method_5720();
        class_243 reachVector = eyePosition.method_1019(lookVector.method_1021(reachDistance));
        class_3966 entityHit = ODMTickHandler.projectileUtil_getEntityHitResult(player.method_37908(), (class_1297)player, eyePosition, reachVector, player.method_5829().method_18804(lookVector.method_1021(reachDistance)).method_1014(1.0), entity -> !entity.method_7325() && entity.method_5863() && entity != player);
        if (entityHit != null) {
            return entityHit;
        }
        class_239 blockHit = player.method_5745(reachDistance, 0.0f, false);
        if (blockHit.method_17783() != class_239.class_240.field_1333) {
            return blockHit;
        }
        return null;
    }

    private static class_3966 projectileUtil_getEntityHitResult(class_1937 level, class_1297 shooter, class_243 startVec, class_243 endVec, class_238 boundingBox, Predicate<class_1297> filter) {
        double closestDistance = Double.MAX_VALUE;
        class_1297 closestEntity = null;
        class_243 closestHitPos = null;
        for (class_1297 entity : level.method_8333(shooter, boundingBox, filter)) {
            class_243 hitPos;
            double distance;
            class_238 entityBox = entity.method_5829().method_1014(0.3);
            Optional optional = entityBox.method_992(startVec, endVec);
            if (!optional.isPresent() || !((distance = startVec.method_1025(hitPos = (class_243)optional.get())) < closestDistance)) continue;
            closestDistance = distance;
            closestEntity = entity;
            closestHitPos = hitPos;
        }
        if (closestEntity != null) {
            return new class_3966(closestEntity, closestHitPos);
        }
        return null;
    }

    private static void applyHookMovement(class_746 player, HookPoint leftHook, HookPoint rightHook) {
        class_243 newVelocity;
        double pullSpeed;
        Long startTime;
        boolean justStartedDualHook;
        class_310 mc = class_310.method_1551();
        class_243 targetPos = null;
        boolean bothHooksActive = false;
        if (leftHook.active && !leftHook.isExtending && !leftHook.isRetracting && rightHook.active && !rightHook.isExtending && !rightHook.isRetracting) {
            targetPos = leftHook.position.method_1019(rightHook.position).method_1021(0.5);
            bothHooksActive = true;
        } else if (leftHook.active && !leftHook.isExtending && !leftHook.isRetracting) {
            targetPos = leftHook.position;
        } else if (rightHook.active && !rightHook.isExtending && !rightHook.isRetracting) {
            targetPos = rightHook.position;
        }
        if (targetPos == null) {
            wasDualHooking.put(player.method_5667(), false);
            dualHookStartTime.remove(player.method_5667());
            return;
        }
        boolean wasDoublehooking = wasDualHooking.getOrDefault(player.method_5667(), false);
        boolean justReleasedOneHook = wasDoublehooking && !bothHooksActive;
        boolean bl = justStartedDualHook = !wasDoublehooking && bothHooksActive;
        if (justStartedDualHook) {
            dualHookStartTime.put(player.method_5667(), System.currentTimeMillis());
        } else if (!bothHooksActive) {
            dualHookStartTime.remove(player.method_5667());
        }
        double dualHookDirectness = 0.0;
        if (bothHooksActive && (startTime = dualHookStartTime.get(player.method_5667())) != null) {
            long elapsed = System.currentTimeMillis() - startTime;
            dualHookDirectness = Math.min(1.0, (double)elapsed / 2000.0);
        }
        wasDualHooking.put(player.method_5667(), bothHooksActive);
        class_243 playerPos = player.method_19538();
        class_243 toHook = targetPos.method_1020(playerPos);
        class_243 direction = toHook.method_1029();
        boolean isBoosting = mc.field_1690.field_1903.method_1434();
        boolean pressingA = mc.field_1690.field_1913.method_1434();
        boolean pressingD = mc.field_1690.field_1849.method_1434();
        boolean isOrbiting = (pressingA || pressingD) && !bothHooksActive;
        double currentBoostLevel = boostLevels.getOrDefault(player.method_5667(), 0.0);
        currentBoostLevel = isBoosting ? Math.min(1.0, currentBoostLevel + 0.058823529411764705) : Math.max(0.0, currentBoostLevel - 0.0125);
        boostLevels.put(player.method_5667(), currentBoostLevel);
        class_1799 odmGear = player.method_6118(class_1304.field_6174);
        int tickCount = gasTickCounter.getOrDefault(player.method_5667(), 0) + 1;
        if (tickCount >= 10) {
            tickCount = 0;
            int gasToConsume = isBoosting ? 3 : 1;
            ODMGearItem.consumeGas(odmGear, gasToConsume, (class_1657)player);
            odmGear.method_7956(1, (class_1309)player, p -> p.method_20235(class_1304.field_6174));
            if (!ODMGearItem.hasGas(odmGear, (class_1657)player)) {
                ODMGasHUD.showOutOfGas();
                ODMTickHandler.forceRetractHooks(player, leftHook, rightHook);
                boostLevels.put(player.method_5667(), 0.0);
                return;
            }
        }
        gasTickCounter.put(player.method_5667(), tickCount);
        double orbitSpeed = 0.08;
        if (bothHooksActive) {
            orbitSpeed *= 0.4;
        }
        if (currentBoostLevel > 0.01) {
            orbitSpeed *= 1.0 + 1.5 * currentBoostLevel;
        }
        if (isOrbiting) {
            pullSpeed = orbitSpeed * 1.8;
        } else {
            pullSpeed = 0.12;
            if (bothHooksActive) {
                pullSpeed *= 2.4;
                if (currentBoostLevel > 0.01) {
                    pullSpeed *= 1.0 + 0.5 * currentBoostLevel;
                }
            }
            if (!bothHooksActive && currentBoostLevel > 0.01) {
                pullSpeed *= 1.0 + 0.0 * currentBoostLevel;
            }
        }
        double lift = 0.05;
        if (currentBoostLevel > 0.01) {
            lift *= 1.0 + currentBoostLevel;
        }
        class_243 currentVel = player.method_18798();
        class_243 pullForce = direction.method_1021(pullSpeed);
        if (playerPos.field_1351 < targetPos.field_1351) {
            pullForce = pullForce.method_1031(0.0, lift, 0.0);
        }
        class_243 orbitForce = class_243.field_1353;
        if (isOrbiting) {
            class_243 right = direction.method_1036(new class_243(0.0, 1.0, 0.0)).method_1029();
            if (right.method_1027() < 0.01) {
                right = direction.method_1036(new class_243(1.0, 0.0, 0.0)).method_1029();
            }
            if (pressingD) {
                orbitForce = right.method_1021(orbitSpeed);
            }
            if (pressingA) {
                orbitForce = right.method_1021(-orbitSpeed);
            }
        }
        double drag = 0.98;
        if (justReleasedOneHook) {
            class_243 preserved = storedMomentum.getOrDefault(player.method_5667(), currentVel);
            newVelocity = preserved.method_1021(drag).method_1019(pullForce.method_1021(0.3)).method_1019(orbitForce);
        } else if (bothHooksActive) {
            class_243 normalVelocity = currentVel.method_1021(drag).method_1019(pullForce);
            double towardsSpeed = currentVel.method_1026(direction);
            class_243 towardsVelocity = direction.method_1021(Math.max(0.0, towardsSpeed));
            class_243 directVelocity = towardsVelocity.method_1021(drag).method_1019(pullForce);
            newVelocity = normalVelocity.method_35590(directVelocity, dualHookDirectness);
        } else {
            newVelocity = currentVel.method_1021(drag).method_1019(pullForce).method_1019(orbitForce);
        }
        storedMomentum.put(player.method_5667(), newVelocity);
        player.method_18799(newVelocity);
        if (!player.method_24828() && player.method_18798().method_37267() > 0.3) {
            ODMSoundManager.playFlightSound(player);
        } else {
            ODMSoundManager.stopFlightSound(player);
        }
        if (isBoosting && currentBoostLevel > 0.1) {
            ODMSoundManager.playGasBoostSound(player);
            ODMTickHandler.spawnBoostParticles(player);
        } else {
            ODMSoundManager.stopGasBoostSound(player);
        }
    }

    private static void spawnBoostParticles(class_746 player) {
        double velZ;
        double velY;
        double velX;
        double particleZ;
        double particleY;
        double particleX;
        double offsetZ;
        double offsetY;
        double offsetX;
        int i;
        class_243 velocity = player.method_18798();
        class_243 playerPos = player.method_19538();
        class_243 particleDirection = velocity.method_1029().method_1021(-1.0);
        for (i = 0; i < 2; ++i) {
            offsetX = (player.method_6051().method_43058() - 0.5) * 0.3;
            offsetY = (player.method_6051().method_43058() - 0.5) * 0.3;
            offsetZ = (player.method_6051().method_43058() - 0.5) * 0.3;
            particleX = playerPos.field_1352 + particleDirection.field_1352 * 0.5 + offsetX;
            particleY = playerPos.field_1351 + 0.5 + offsetY;
            particleZ = playerPos.field_1350 + particleDirection.field_1350 * 0.5 + offsetZ;
            velX = (player.method_6051().method_43058() - 0.5) * 0.05;
            velY = (player.method_6051().method_43058() - 0.5) * 0.05;
            velZ = (player.method_6051().method_43058() - 0.5) * 0.05;
            player.method_37908().method_8406((class_2394)class_2398.field_11251, particleX, particleY, particleZ, velX, velY, velZ);
        }
        for (i = 0; i < 2; ++i) {
            offsetX = (player.method_6051().method_43058() - 0.5) * 0.4;
            offsetY = (player.method_6051().method_43058() - 0.5) * 0.4;
            offsetZ = (player.method_6051().method_43058() - 0.5) * 0.4;
            particleX = playerPos.field_1352 + particleDirection.field_1352 * 0.5 + offsetX;
            particleY = playerPos.field_1351 + 0.5 + offsetY;
            particleZ = playerPos.field_1350 + particleDirection.field_1350 * 0.5 + offsetZ;
            velX = (player.method_6051().method_43058() - 0.5) * 0.03;
            velY = (player.method_6051().method_43058() - 0.5) * 0.03;
            velZ = (player.method_6051().method_43058() - 0.5) * 0.03;
            player.method_37908().method_8406((class_2394)class_2398.field_11204, particleX, particleY, particleZ, velX, velY, velZ);
        }
        for (i = 0; i < 3; ++i) {
            offsetX = (player.method_6051().method_43058() - 0.5) * 0.5;
            offsetY = (player.method_6051().method_43058() - 0.5) * 0.5;
            offsetZ = (player.method_6051().method_43058() - 0.5) * 0.5;
            particleX = playerPos.field_1352 + particleDirection.field_1352 * 0.5 + offsetX;
            particleY = playerPos.field_1351 + 0.5 + offsetY;
            particleZ = playerPos.field_1350 + particleDirection.field_1350 * 0.5 + offsetZ;
            velX = (player.method_6051().method_43058() - 0.5) * 0.02;
            velY = -0.01;
            velZ = (player.method_6051().method_43058() - 0.5) * 0.02;
            player.method_37908().method_8406((class_2394)class_2398.field_23956, particleX, particleY, particleZ, velX, velY, velZ);
        }
    }

    private static void spawnHookImpactParticles(class_746 player, class_243 hookPos, class_239 hit) {
        class_2338 blockPos;
        if (hit instanceof class_3965) {
            class_3965 blockHit = (class_3965)hit;
            blockPos = blockHit.method_17777();
        } else {
            blockPos = class_2338.method_49638((class_2374)hookPos);
        }
        class_2680 blockState = player.method_37908().method_8320(blockPos);
        if (!blockState.method_26215()) {
            for (int i = 0; i < 10; ++i) {
                double offsetX = (player.method_6051().method_43058() - 0.5) * 0.4;
                double offsetY = (player.method_6051().method_43058() - 0.5) * 0.4;
                double offsetZ = (player.method_6051().method_43058() - 0.5) * 0.4;
                double velX = (player.method_6051().method_43058() - 0.5) * 0.3;
                double velY = player.method_6051().method_43058() * 0.3;
                double velZ = (player.method_6051().method_43058() - 0.5) * 0.3;
                player.method_37908().method_8406((class_2394)new class_2388(class_2398.field_11217, blockState), hookPos.field_1352 + offsetX, hookPos.field_1351 + offsetY, hookPos.field_1350 + offsetZ, velX, velY, velZ);
            }
        }
    }

    private static void clearHooks(class_746 player) {
        leftHooks.remove(player.method_5667());
        rightHooks.remove(player.method_5667());
        boostLevels.remove(player.method_5667());
        storedMomentum.remove(player.method_5667());
        gasTickCounter.remove(player.method_5667());
        wasDualHooking.remove(player.method_5667());
        dualHookStartTime.remove(player.method_5667());
    }

    private static void forceRetractHooks(class_746 player, HookPoint leftHook, HookPoint rightHook) {
        float yaw = (float)Math.toRadians(player.method_36454());
        double legOffset = 0.3;
        class_243 playerPos = player.method_19538();
        class_243 leftLegPos = playerPos.method_1031(Math.cos(yaw) * legOffset, 0.1, Math.sin(yaw) * legOffset);
        class_243 rightLegPos = playerPos.method_1031(-Math.cos(yaw) * legOffset, 0.1, -Math.sin(yaw) * legOffset);
        if (leftHook.active && !leftHook.isRetracting) {
            player.method_5783(ModSounds.HOOK_RETRACT, 0.7f, 1.0f);
            leftHook.startRetract(leftLegPos);
        }
        if (rightHook.active && !rightHook.isRetracting) {
            player.method_5783(ModSounds.HOOK_RETRACT, 0.7f, 1.0f);
            rightHook.startRetract(rightLegPos);
        }
        ODMSoundManager.stopFlightSound(player);
        ODMSoundManager.stopGasBoostSound(player);
    }

    public static HookPoint getLeftHook(UUID playerId) {
        return leftHooks.get(playerId);
    }

    public static HookPoint getRightHook(UUID playerId) {
        return rightHooks.get(playerId);
    }
}

