/*
 * Decompiled with CFR 0.152.
 */
package com.kekecreations.jinxedlib.core.mixin;

import com.kekecreations.jinxedlib.common.data.CompostableUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ComposterBlock.class})
public class ComposterBlockMixin {
    @Shadow
    static BlockState addItem(@Nullable Entity entity, BlockState state, LevelAccessor level, BlockPos pos, ItemStack stack) {
        return null;
    }

    @Inject(method={"useItemOn"}, at={@At(value="HEAD")}, cancellable=true)
    private void jinxedlib_useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult, CallbackInfoReturnable<ItemInteractionResult> cir) {
        int i = (Integer)state.getValue((Property)ComposterBlock.LEVEL);
        if (!level.isClientSide() && i < 8 && CompostableUtils.isItemCompostable(level.registryAccess(), stack)) {
            if (i < 7) {
                BlockState blockState = ComposterBlockMixin.addItem((Entity)player, state, (LevelAccessor)level, pos, stack);
                level.levelEvent(1500, pos, state != blockState ? 1 : 0);
                player.awardStat(Stats.ITEM_USED.get((Object)stack.getItem()));
                stack.consume(1, (LivingEntity)player);
            }
            cir.setReturnValue((Object)ItemInteractionResult.SUCCESS);
        }
    }

    @Inject(method={"addItem"}, at={@At(value="HEAD")}, cancellable=true)
    private static void jinxedlib_addItem(Entity entity, BlockState state, LevelAccessor level, BlockPos pos, ItemStack stack, CallbackInfoReturnable<BlockState> cir) {
        if (CompostableUtils.isItemCompostable(level.registryAccess(), stack)) {
            int i = (Integer)state.getValue((Property)ComposterBlock.LEVEL);
            float f = CompostableUtils.getCompostableValue(level.registryAccess(), stack).floatValue();
            if (!(i == 0 && f > 0.0f || level.getRandom().nextDouble() < (double)f)) {
                cir.setReturnValue((Object)state);
            } else {
                int j = i + 1;
                BlockState blockState = (BlockState)state.setValue((Property)ComposterBlock.LEVEL, (Comparable)Integer.valueOf(j));
                level.setBlock(pos, blockState, 3);
                level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((Entity)entity, (BlockState)blockState));
                if (j == 7) {
                    level.scheduleTick(pos, state.getBlock(), 20);
                }
                cir.setReturnValue((Object)blockState);
            }
        }
    }

    @Inject(method={"insertItem"}, at={@At(value="HEAD")}, cancellable=true)
    private static void jinxedlib_insertItem(Entity pEntity, BlockState pState, ServerLevel pLevel, ItemStack pStack, BlockPos pPos, CallbackInfoReturnable<BlockState> cir) {
        int i = (Integer)pState.getValue((Property)ComposterBlock.LEVEL);
        if (CompostableUtils.isItemCompostable(pLevel.registryAccess(), pStack)) {
            if (i < 7 && CompostableUtils.getCompostableValue(pLevel.registryAccess(), pStack).floatValue() > 0.0f) {
                BlockState blockstate = ComposterBlockMixin.addItem(pEntity, pState, (LevelAccessor)pLevel, pPos, pStack);
                pStack.shrink(1);
                cir.setReturnValue((Object)blockstate);
            } else {
                cir.setReturnValue((Object)pState);
            }
        }
    }
}

