/*
 * Decompiled with CFR 0.152.
 */
package com.kekecreations.jinxedlib.core.util;

import com.kekecreations.jinxedlib.JinxedLib;
import com.kekecreations.jinxedlib.core.mixin.SpriteSourcesInvoker;
import com.kekecreations.jinxedlib.core.mixin.WoodTypeInvoker;
import com.kekecreations.jinxedlib.core.platform.Services;
import com.mojang.serialization.MapCodec;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.client.renderer.texture.atlas.SpriteSource;
import net.minecraft.client.renderer.texture.atlas.SpriteSourceType;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.grower.TreeGrower;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.storage.loot.LootTable;

public class JinxedRegistryHelper {
    private static final Set<ResourceKey<LootTable>> LOCATIONS = new HashSet<ResourceKey<LootTable>>();
    private static final Set<ResourceKey<LootTable>> IMMUTABLE_LOCATIONS = Collections.unmodifiableSet(LOCATIONS);

    public static <T> Supplier<T> register(Registry<T> registry, String modID, String name, Supplier<T> supplier) {
        return Services.REGISTRY.register(registry, modID, name, supplier);
    }

    public static Supplier<Item> registerItem(String modID, String name, Supplier<Item> supplier) {
        return Services.REGISTRY.register(BuiltInRegistries.ITEM, modID, name, supplier);
    }

    public static Supplier<Block> registerBlock(String modID, String name, boolean hasItem, Supplier<Block> supplier) {
        Supplier<Block> block = Services.REGISTRY.register(BuiltInRegistries.BLOCK, modID, name, supplier);
        if (hasItem) {
            JinxedRegistryHelper.registerItem(modID, name, () -> new BlockItem((Block)block.get(), new Item.Properties()));
        }
        return block;
    }

    public static WoodType registerWoodType(WoodType woodType) {
        return WoodTypeInvoker.invokeRegister(woodType);
    }

    public static TreeGrower register(String modID, String name, Optional<ResourceKey<ConfiguredFeature<?, ?>>> tree, Optional<ResourceKey<ConfiguredFeature<?, ?>>> secondaryTree) {
        return JinxedRegistryHelper.register(modID, name, 0.0f, Optional.empty(), Optional.empty(), tree, secondaryTree, Optional.empty(), Optional.empty());
    }

    private static TreeGrower register(String modID, String name, float secondaryChance, Optional<ResourceKey<ConfiguredFeature<?, ?>>> megaTree, Optional<ResourceKey<ConfiguredFeature<?, ?>>> secondaryMegaTree, Optional<ResourceKey<ConfiguredFeature<?, ?>>> tree, Optional<ResourceKey<ConfiguredFeature<?, ?>>> secondaryTree, Optional<ResourceKey<ConfiguredFeature<?, ?>>> flowers, Optional<ResourceKey<ConfiguredFeature<?, ?>>> secondaryFlowers) {
        return new TreeGrower(String.format("%s:%s", modID, name), secondaryChance, megaTree, secondaryMegaTree, tree, secondaryTree, flowers, secondaryFlowers);
    }

    public static ResourceKey<LootTable> registerBuiltInLootTable(String modID, String name) {
        return JinxedRegistryHelper.register((ResourceKey<LootTable>)ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)JinxedLib.customId(modID, name)));
    }

    private static ResourceKey<LootTable> register(ResourceKey<LootTable> $$0) {
        if (LOCATIONS.add($$0)) {
            return $$0;
        }
        throw new IllegalArgumentException(String.valueOf($$0.location()) + " is already a registered built-in loot table");
    }

    public static Set<ResourceKey<LootTable>> all() {
        return IMMUTABLE_LOCATIONS;
    }

    public static SpriteSourceType registerSpriteSource(String id, MapCodec<? extends SpriteSource> codec) {
        return SpriteSourcesInvoker.invokeRegister(id, codec);
    }
}

