/*
 * Decompiled with CFR 0.152.
 */
package com.kekecreations.jinxedlib.client.renderer.atlas;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.kekecreations.jinxedlib.core.registry.JinxedSpriteSources;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.IntUnaryOperator;
import java.util.function.Predicate;
import net.minecraft.class_1011;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_5253;
import net.minecraft.class_7368;
import net.minecraft.class_7764;
import net.minecraft.class_7771;
import net.minecraft.class_7948;
import net.minecraft.class_7951;
import net.minecraft.class_7952;
import net.minecraft.class_7958;
import net.minecraft.class_8684;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class JinxedPalettedPermutations
implements class_7948 {
    static final Logger LOGGER = LogUtils.getLogger();
    public static final MapCodec<JinxedPalettedPermutations> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.list((Codec)class_7952.field_41396).fieldOf("sources").forGetter(palettedPermutations -> palettedPermutations.sources), (App)class_2960.field_25139.fieldOf("palette_key").forGetter(palettedPermutations -> palettedPermutations.paletteKey), (App)Codec.unboundedMap((Codec)Codec.STRING, (Codec)class_2960.field_25139).fieldOf("permutations").forGetter(palettedPermutations -> palettedPermutations.permutations)).apply((Applicative)instance, JinxedPalettedPermutations::new));
    private final List<class_7948> sources;
    private final Map<String, class_2960> permutations;
    private final class_2960 paletteKey;

    private JinxedPalettedPermutations(List<class_7948> list, class_2960 resourceLocation, Map<String, class_2960> map) {
        this.sources = list;
        this.permutations = map;
        this.paletteKey = resourceLocation;
    }

    public void method_47673(@NotNull class_3300 resourceManager, // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull class_7948.class_7949 output) {
        Supplier supplier = Suppliers.memoize(() -> JinxedPalettedPermutations.loadPaletteEntryFromImage(resourceManager, this.paletteKey));
        HashMap map = new HashMap();
        this.permutations.forEach((arg_0, arg_1) -> JinxedPalettedPermutations.lambda$run$6(map, (java.util.function.Supplier)supplier, resourceManager, arg_0, arg_1));
        final HashMap sourceOutputMap = new HashMap();
        class_7948.class_7949 sourceOutput = new class_7948.class_7949(){

            public void method_47670(@NotNull class_2960 location, @NotNull class_7948.class_7950 spriteSupplier) {
                class_7948.class_7950 supplier = sourceOutputMap.put(location, spriteSupplier);
                if (supplier != null) {
                    supplier.method_47676();
                }
            }

            public void method_47671(@NotNull Predicate<class_2960> predicate) {
                Iterator iterator = sourceOutputMap.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    if (!predicate.test((class_2960)entry.getKey())) continue;
                    ((class_7948.class_7950)entry.getValue()).method_47676();
                    iterator.remove();
                }
            }
        };
        for (class_7948 source : this.sources) {
            source.method_47673(resourceManager, sourceOutput);
        }
        for (class_2960 resourceLocation : sourceOutputMap.keySet()) {
            class_2960 resourceLocation2 = field_42075.method_45112(resourceLocation);
            Optional optional = resourceManager.method_14486(resourceLocation2);
            if (optional.isEmpty()) {
                LOGGER.warn("Unable to find texture {}", (Object)resourceLocation2);
                continue;
            }
            class_7958 lazyLoadedImage = new class_7958(resourceLocation2, (class_3298)optional.get(), map.size());
            for (Map.Entry entry : map.entrySet()) {
                class_2960 resourceLocation3 = resourceLocation.method_48331("_" + (String)entry.getKey());
                output.method_47670(resourceLocation3, (class_7948.class_7950)new JinxedPalettedSpriteSupplier(lazyLoadedImage, (java.util.function.Supplier)entry.getValue(), resourceLocation3));
            }
        }
    }

    private static IntUnaryOperator createPaletteMapping(int[] is, int[] js) {
        if (js.length != is.length) {
            LOGGER.warn("Palette mapping has different sizes: {} and {}", (Object)is.length, (Object)js.length);
            throw new IllegalArgumentException();
        }
        Int2IntOpenHashMap int2IntMap = new Int2IntOpenHashMap(js.length);
        for (int i = 0; i < is.length; ++i) {
            int j = is[i];
            if (class_5253.class_8045.method_48342((int)j) == 0) continue;
            int2IntMap.put(class_5253.class_8045.method_48348((int)j), js[i]);
        }
        return arg_0 -> JinxedPalettedPermutations.lambda$createPaletteMapping$7((Int2IntMap)int2IntMap, arg_0);
    }

    public static int[] loadPaletteEntryFromImage(class_3300 resourceManager, class_2960 resourceLocation) {
        Optional optional = resourceManager.method_14486(field_42075.method_45112(resourceLocation));
        if (optional.isEmpty()) {
            LOGGER.error("Failed to load palette image {}", (Object)resourceLocation);
            throw new IllegalArgumentException();
        }
        try {
            int[] var5;
            try (InputStream inputStream = ((class_3298)optional.get()).method_14482();
                 class_1011 nativeImage = class_1011.method_4309((InputStream)inputStream);){
                var5 = nativeImage.method_48463();
            }
            return var5;
        }
        catch (Exception var11) {
            Exception exception = var11;
            LOGGER.error("Couldn't load texture {}", (Object)resourceLocation, (Object)exception);
            throw new IllegalArgumentException();
        }
    }

    public class_7951 method_47672() {
        return JinxedSpriteSources.PALETTED_PERMUTATIONS;
    }

    private static /* synthetic */ int lambda$createPaletteMapping$7(Int2IntMap int2IntMap, int ix) {
        int j = class_5253.class_8045.method_48342((int)ix);
        if (j == 0) {
            return ix;
        }
        int k = class_5253.class_8045.method_48348((int)ix);
        int l = int2IntMap.getOrDefault(k, class_5253.class_8045.method_48548((int)k));
        int m = class_5253.class_8045.method_48342((int)l);
        return class_5253.class_8045.method_48343((int)(j * m / 255), (int)l);
    }

    private static /* synthetic */ void lambda$run$6(Map map, java.util.function.Supplier supplier, class_3300 resourceManager, String string, class_2960 resourceLocationx) {
        map.put(string, Suppliers.memoize(() -> JinxedPalettedPermutations.lambda$run$5((java.util.function.Supplier)supplier, resourceManager, resourceLocationx)));
    }

    private static /* synthetic */ IntUnaryOperator lambda$run$5(java.util.function.Supplier supplier, class_3300 resourceManager, class_2960 resourceLocationx) {
        return JinxedPalettedPermutations.createPaletteMapping((int[])supplier.get(), JinxedPalettedPermutations.loadPaletteEntryFromImage(resourceManager, resourceLocationx));
    }

    record JinxedPalettedSpriteSupplier(class_7958 baseImage, java.util.function.Supplier<IntUnaryOperator> paletteSupplier, class_2960 permutationLocation) implements class_7948.class_7950
    {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        public class_7764 apply(class_8684 loader) {
            class_7764 var2;
            try {
                class_7764 var22;
                class_1011 nativeImage = this.baseImage.method_47697().method_48462(this.paletteSupplier.get());
                class_7764 class_77642 = var22 = new class_7764(this.permutationLocation, new class_7771(nativeImage.method_4307(), nativeImage.method_4323()), nativeImage, class_7368.field_38688);
                return class_77642;
            }
            catch (IOException | IllegalArgumentException var6) {
                Exception exception = var6;
                LOGGER.error("unable to apply palette to {}", (Object)this.permutationLocation, (Object)exception);
                var2 = null;
            }
            finally {
                this.baseImage.method_47698();
            }
            return var2;
        }

        public void method_47676() {
            this.baseImage.method_47698();
        }

        public java.util.function.Supplier<IntUnaryOperator> palette() {
            return this.paletteSupplier;
        }
    }
}

