/*
 * Decompiled with CFR 0.152.
 */
package fin.starhud.config;

import fin.starhud.condition.Condition;
import me.shedaniel.autoconfig.annotation.ConfigEntry;
import me.shedaniel.cloth.clothconfig.shadowed.blue.endless.jankson.Comment;

public class ConditionalSettings {
    @Comment(value="Condition.")
    @ConfigEntry.Gui.EnumHandler(option=ConfigEntry.Gui.EnumHandler.EnumDisplayOption.BUTTON)
    public Condition condition = Condition.DEBUG_HUD_OPENED;
    @ConfigEntry.Gui.EnumHandler(option=ConfigEntry.Gui.EnumHandler.EnumDisplayOption.BUTTON)
    public PositionMode positionMode = PositionMode.NONE;
    @ConfigEntry.Gui.EnumHandler(option=ConfigEntry.Gui.EnumHandler.EnumDisplayOption.BUTTON)
    public RenderMode renderMode = RenderMode.SHOW;
    @Comment(value="Server IP Address and Mod ID requires this field.")
    public String additionalString = "";
    @Comment(value="Shifts this HUD in the X Axis")
    public int xOffset = 0;
    @Comment(value="Shifts this HUD in the Y Axis")
    public int yOffset = 0;

    public boolean renderIfActive() {
        return this.renderMode == RenderMode.RENDER_IF_ACTIVE && this.isConditionMet();
    }

    public boolean shouldRender() {
        return !this.shouldHide();
    }

    public boolean shouldHide() {
        return this.renderMode == RenderMode.HIDE && this.isConditionMet();
    }

    public int getXOffset(float scaleFactor) {
        if (this.positionMode == null) {
            this.positionMode = PositionMode.NONE;
        }
        return switch (this.positionMode.ordinal()) {
            case 1 -> this.xOffset + (int)((float)this.condition.getWidth() * scaleFactor);
            case 2 -> this.xOffset - (int)((float)this.condition.getWidth() * scaleFactor);
            default -> this.xOffset;
        };
    }

    public int getYOffset(float scaleFactor) {
        if (this.positionMode == null) {
            this.positionMode = PositionMode.NONE;
        }
        return switch (this.positionMode.ordinal()) {
            case 3 -> this.yOffset + (int)((float)this.condition.getHeight() * scaleFactor);
            case 4 -> this.yOffset - (int)((float)this.condition.getHeight() * scaleFactor);
            default -> this.yOffset;
        };
    }

    public boolean isConditionMet() {
        if (this.condition == null) {
            this.condition = Condition.DEBUG_HUD_OPENED;
        }
        return this.condition.isConditionMet(this.additionalString);
    }

    public static enum PositionMode {
        NONE,
        ADD_WIDTH,
        SUBTRACT_WIDTH,
        ADD_HEIGHT,
        SUBTRACT_HEIGHT;

    }

    public static enum RenderMode {
        SHOW,
        HIDE,
        RENDER_IF_ACTIVE;

    }
}

