/*
 * Decompiled with CFR 0.152.
 */
package fin.starhud.hud.implementation.statuseffect;

import fin.starhud.Helper;
import fin.starhud.Main;
import fin.starhud.config.GeneralSettings;
import fin.starhud.config.hud.EffectSettings;
import fin.starhud.helper.HUDDisplayMode;
import fin.starhud.helper.RenderUtils;
import fin.starhud.helper.StatusEffectAttribute;
import fin.starhud.hud.AbstractHUD;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1047;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_9848;

public abstract class AbstractEffectHUD
extends AbstractHUD {
    private static final class_310 CLIENT = class_310.method_1551();
    private static final GeneralSettings.HUDSettings HUD_SETTINGS = Main.settings.generalSettings.hudSettings;
    private static final class_2960 STATUS_EFFECT_BAR_TEXTURE = class_2960.method_60655((String)"starhud", (String)"hud/effect_bar.png");
    private static final class_2960 STATUS_EFFECT_BAR_BACKGROUND_TEXTURE = class_2960.method_60655((String)"starhud", (String)"hud/effect_bar_background.png");
    private static final class_2960 STATUS_EFFECT_TEXTURE = class_2960.method_60655((String)"starhud", (String)"hud/effect.png");
    private static final class_2960 STATUS_EFFECT_AMBIENT_TEXTURE = class_2960.method_60655((String)"starhud", (String)"hud/effect_ambient.png");
    private static final class_2960 STATUS_EFFECT_AMBIENT_COMBINED_TEXTURE = class_2960.method_60655((String)"starhud", (String)"hud/effect_ambient_combined.png");
    private static final int ICON_WIDTH = 24;
    private static final int ICON_HEIGHT = 24;
    private static final int INFO_HEIGHT = 7;
    private static final int STATUS_EFFECT_TEXTURE_HEIGHT = 32;
    private static final int STATUS_EFFECT_TEXTURE_WIDTH = 24;
    private static final int STATUS_EFFECT_BAR_TEXTURE_WIDTH = 21;
    private static final int STATUS_EFFECT_BAR_TEXTURE_HEIGHT = 3;
    private static final Map<class_6880<class_1291>, class_2960> STATUS_EFFECT_TEXTURE_MAP = new HashMap<class_6880<class_1291>, class_2960>();
    private final EffectSettings effectSettings;
    public int size;
    private int sameTypeGap;
    private int iconInfoGap;
    private boolean drawVertical;
    private boolean drawTimer;
    private boolean drawHidden;
    private boolean combineBackground;
    private HUDDisplayMode displayMode;
    private final List<String> effectDurationStrings = new ArrayList<String>();
    private final List<class_2960> effectTextures = new ArrayList<class_2960>();
    private final List<Integer> effectWidths = new ArrayList<Integer>();
    private final List<Integer> effectColors = new ArrayList<Integer>();
    private final List<Float> effectAlphas = new ArrayList<Float>();
    private final List<Integer> effectSteps = new ArrayList<Integer>();
    private final List<Boolean> effectAmbients = new ArrayList<Boolean>();
    private final List<String> effectAmplifiers = new ArrayList<String>();

    public AbstractEffectHUD(EffectSettings effectSettings) {
        super(effectSettings.base);
        this.effectSettings = effectSettings;
    }

    public abstract boolean isEffectAllowedToRender(class_6880<class_1291> var1);

    @Override
    public boolean shouldRender() {
        return super.shouldRender();
    }

    @Override
    public boolean collectHUDInformation() {
        if (AbstractEffectHUD.CLIENT.field_1724 == null) {
            return false;
        }
        this.effectDurationStrings.clear();
        this.effectColors.clear();
        this.effectTextures.clear();
        this.effectWidths.clear();
        this.effectAlphas.clear();
        this.effectSteps.clear();
        this.effectAmbients.clear();
        this.effectAmplifiers.clear();
        this.drawTimer = this.effectSettings.drawTimer;
        this.drawHidden = this.effectSettings.drawHidden;
        this.combineBackground = this.effectSettings.combineBackground;
        if (this.drawTimer) {
            return this.collectTimerHUDInformation();
        }
        return this.collectBarHUDInformation();
    }

    public boolean collectBarHUDInformation() {
        this.size = 0;
        this.iconInfoGap = Math.min(AbstractEffectHUD.HUD_SETTINGS.iconInfoGap, 1);
        for (class_1293 instance : AbstractEffectHUD.CLIENT.field_1724.method_6026()) {
            if (!instance.method_5592() && !this.drawHidden || !this.isEffectAllowedToRender((class_6880<class_1291>)instance.method_5579())) continue;
            ++this.size;
            StatusEffectAttribute statusEffectAttribute = StatusEffectAttribute.getStatusEffectAttribute(instance);
            class_2960 effectTexture = AbstractEffectHUD.getStatusEffectTexture((class_6880<class_1291>)instance.method_5579());
            boolean ambient = instance.method_5591();
            int duration = instance.method_5584();
            int maxDuration = statusEffectAttribute.maxDuration();
            int step = instance.method_48559() ? 7 : Helper.getStep(duration, maxDuration, 7);
            int color = this.getStatusEffectColor(instance, statusEffectAttribute) | 0xFF000000;
            float alpha = this.getStatusEffectAlpha(instance);
            int amplifier = instance.method_5578() + 1;
            String amplifierStr = amplifier <= 1 ? "" : Helper.toSubscript(Integer.toString(amplifier));
            this.effectTextures.add(effectTexture);
            this.effectSteps.add(step);
            this.effectColors.add(color);
            this.effectAlphas.add(Float.valueOf(alpha));
            this.effectAmplifiers.add(amplifierStr);
            this.effectAmbients.add(ambient);
        }
        if (this.size == 0) {
            return false;
        }
        int width = this.getDynamicWidth(this.size);
        int height = this.getDynamicHeight(this.size);
        this.drawVertical = this.effectSettings.drawVertical;
        this.sameTypeGap = this.getSameTypeGap();
        this.setWidthHeight(width, height);
        return true;
    }

    public boolean collectTimerHUDInformation() {
        this.drawVertical = this.effectSettings.drawVertical;
        this.sameTypeGap = this.effectSettings.sameTypeGap;
        this.displayMode = this.effectSettings.base.displayMode;
        int width = -this.sameTypeGap;
        int height = -this.sameTypeGap;
        for (class_1293 instance : AbstractEffectHUD.CLIENT.field_1724.method_6026()) {
            if (!instance.method_5592() && !this.drawHidden || !this.isEffectAllowedToRender((class_6880<class_1291>)instance.method_5579())) continue;
            StatusEffectAttribute statusEffectAttribute = StatusEffectAttribute.getStatusEffectAttribute(instance);
            int duration = instance.method_5584();
            String effectTimeStr = this.buildEffectDurationString(duration);
            class_2960 effectTexture = AbstractEffectHUD.getStatusEffectTexture((class_6880<class_1291>)instance.method_5579());
            int effectWidth = AbstractEffectHUD.CLIENT.field_1772.method_1727(effectTimeStr) - 1;
            int totalInstanceWidth = this.displayMode.calculateWidth(13, effectWidth);
            int color = this.getStatusEffectColor(instance, statusEffectAttribute) | 0xFF000000;
            float alpha = this.getStatusEffectAlpha(instance);
            this.effectDurationStrings.add(effectTimeStr);
            this.effectTextures.add(effectTexture);
            this.effectWidths.add(totalInstanceWidth);
            this.effectColors.add(color);
            this.effectAlphas.add(Float.valueOf(alpha));
            if (this.drawVertical) {
                width = Math.max(totalInstanceWidth, width);
                height += 13 + this.sameTypeGap;
                continue;
            }
            height = 13;
            width += this.sameTypeGap + totalInstanceWidth;
        }
        this.size = this.effectDurationStrings.size();
        if (this.effectDurationStrings.isEmpty()) {
            return false;
        }
        this.setWidthHeight(width, height);
        return true;
    }

    @Override
    public boolean renderHUD(class_332 context, int x, int y, boolean drawBackground) {
        if (AbstractEffectHUD.CLIENT.field_1724 == null) {
            return false;
        }
        if (this.size == 0) {
            return false;
        }
        if (drawBackground && this.combineBackground) {
            RenderUtils.fillRounded(context, x, y, x + this.getWidth(), y + this.getHeight(), Integer.MIN_VALUE);
            drawBackground = false;
        }
        if (this.drawTimer) {
            return this.renderTimerHUD(context, x, y, drawBackground);
        }
        return this.renderBarHUD(context, x, y, drawBackground);
    }

    public boolean renderBarHUD(class_332 context, int x, int y, boolean drawBackground) {
        for (int i = 0; i < this.size; ++i) {
            this.drawStatusEffectBarHUD(context, x, y, this.effectTextures.get(i), this.effectColors.get(i), this.effectAlphas.get(i).floatValue(), this.effectSteps.get(i), this.effectAmplifiers.get(i), this.effectAmbients.get(i), drawBackground);
            if (this.drawVertical) {
                y += this.sameTypeGap;
                continue;
            }
            x += this.sameTypeGap;
        }
        return true;
    }

    public boolean renderTimerHUD(class_332 context, int x, int y, boolean drawBackground) {
        for (int i = 0; i < this.size; ++i) {
            this.drawStatusEffectTimerHUD(context, x, y, this.effectTextures.get(i), this.effectDurationStrings.get(i), this.effectWidths.get(i), 13, this.effectColors.get(i), class_9848.method_61317((float)this.effectAlphas.get(i).floatValue()), drawBackground);
            if (this.drawVertical) {
                y += 13 + this.sameTypeGap;
                continue;
            }
            x += this.effectWidths.get(i) + this.sameTypeGap;
        }
        return true;
    }

    public boolean drawStatusEffectBarHUD(class_332 context, int x, int y, class_2960 effectTexture, int color, float alpha, int step, String amplifier, boolean isAmbient, boolean drawBackground) {
        int gap = this.iconInfoGap;
        if (drawBackground) {
            if (gap <= 0) {
                if (isAmbient) {
                    int iconHeight = 31;
                    int stretchHeight = 24 + gap + 7;
                    float uvScale = (float)stretchHeight / (float)iconHeight;
                    RenderUtils.drawTextureHUD(context, STATUS_EFFECT_AMBIENT_COMBINED_TEXTURE, x, y, 0.0f, 0.0f, 24, stretchHeight, 24, (int)((float)iconHeight * uvScale), color);
                } else {
                    RenderUtils.fillRounded(context, x, y, x + 24, y + 24 + gap + 7, Integer.MIN_VALUE);
                }
            } else {
                RenderUtils.drawTextureHUD(context, isAmbient ? STATUS_EFFECT_AMBIENT_TEXTURE : STATUS_EFFECT_TEXTURE, x, y, 0.0f, 0.0f, 24, 32, 24, 32, isAmbient ? color : -1);
            }
        }
        RenderUtils.drawTextureHUD(context, STATUS_EFFECT_BAR_BACKGROUND_TEXTURE, x + 2, y + 24 + gap + 2, 0.0f, 0.0f, 21, 3, 21, 3);
        RenderUtils.drawTextureHUD(context, STATUS_EFFECT_BAR_TEXTURE, x + 2, y + 24 + gap + 2, 0.0f, 0.0f, 3 * step, 3, 21, 3, color);
        RenderUtils.drawTextureHUD(context, effectTexture, x + 3, y + 3, 0.0f, 0.0f, 18, 18, 18, 18, class_9848.method_61317((float)alpha));
        if (amplifier.isEmpty()) {
            return true;
        }
        RenderUtils.drawTextHUD(context, amplifier, x + 3 + 18 - AbstractEffectHUD.CLIENT.field_1772.method_1727(amplifier) + 1, y + 2 + 18 - 7, -1, true);
        return true;
    }

    public void drawStatusEffectTimerHUD(class_332 context, int x, int y, class_2960 effectTexture, String timeStr, int width, int height, int textColor, int iconColor, boolean drawBackground) {
        int from = 18;
        int to = 9;
        float rat = (float)to / (float)from;
        AbstractEffectHUD.drawSmallHUD(context, timeStr, x, y, width, height, effectTexture, 0.0f, 0.0f, to, to, (int)((float)from * rat), (int)((float)from * rat), textColor, iconColor, this.displayMode, drawBackground);
    }

    public static boolean drawSmallHUD(class_332 context, String infoText, int x, int y, int width, int height, class_2960 iconTexture, float u, float v, int textureWidth, int textureHeight, int iconWidth, int iconHeight, int color, int iconColor, HUDDisplayMode displayMode, boolean drawBackground) {
        if (infoText == null || iconTexture == null || displayMode == null) {
            return false;
        }
        int padding = AbstractEffectHUD.HUD_SETTINGS.textPadding;
        int gap = AbstractEffectHUD.HUD_SETTINGS.iconInfoGap;
        int iconXOffset = 2;
        int iconYOffset = 2;
        switch (displayMode) {
            case ICON: {
                if (drawBackground) {
                    RenderUtils.fillRounded(context, x, y, x + 13, y + 13, Integer.MIN_VALUE);
                }
                RenderUtils.drawTextureHUD(context, iconTexture, x + iconXOffset, y + iconYOffset, u, v, iconWidth, iconHeight, textureWidth, textureHeight, iconColor);
                break;
            }
            case INFO: {
                if (drawBackground) {
                    RenderUtils.fillRounded(context, x, y, x + width, y + height, Integer.MIN_VALUE);
                }
                RenderUtils.drawTextHUD(context, infoText, x + padding, y + 3, color, false);
                break;
            }
            case BOTH: {
                if (drawBackground) {
                    if (gap <= 0) {
                        RenderUtils.fillRounded(context, x, y, x + width, y + height, Integer.MIN_VALUE);
                    } else {
                        RenderUtils.fillRoundedLeftSide(context, x, y, x + 13, y + height, Integer.MIN_VALUE);
                        RenderUtils.fillRoundedRightSide(context, x + 13 + gap, y, x + width, y + height, Integer.MIN_VALUE);
                    }
                }
                RenderUtils.drawTextureHUD(context, iconTexture, x + iconXOffset, y + iconYOffset, u, v, iconWidth, iconHeight, textureWidth, textureHeight, iconColor);
                RenderUtils.drawTextHUD(context, infoText, x + 13 + gap + padding, y + 3, color, false);
            }
        }
        return true;
    }

    public int getDynamicWidth(int size) {
        return this.effectSettings.drawVertical ? 24 : size * this.getSameTypeGap() - this.effectSettings.sameTypeGap;
    }

    public int getDynamicHeight(int size) {
        return this.effectSettings.drawVertical ? size * this.getSameTypeGap() - this.effectSettings.sameTypeGap : this.getInstanceHeight();
    }

    public int getInstanceHeight() {
        return 24 + this.iconInfoGap + 7;
    }

    public int getSameTypeGap() {
        return (this.effectSettings.drawVertical ? this.getInstanceHeight() : 24) + this.effectSettings.sameTypeGap;
    }

    public int getStatusEffectColor(class_1293 instance, StatusEffectAttribute attribute) {
        if (instance.method_48559()) {
            return this.effectSettings.infiniteColor;
        }
        if (instance.method_5591()) {
            return this.effectSettings.ambientColor;
        }
        return switch (this.effectSettings.getColorMode()) {
            default -> throw new MatchException(null, null);
            case EffectSettings.ColorMode.CUSTOM -> this.effectSettings.customColor;
            case EffectSettings.ColorMode.EFFECT -> ((class_1291)instance.method_5579().comp_349()).method_5556();
            case EffectSettings.ColorMode.DYNAMIC -> Helper.getItemBarColor(instance.method_5584(), attribute.maxDuration());
        };
    }

    public float getStatusEffectAlpha(class_1293 instance) {
        int duration = instance.method_5584();
        float alpha = 1.0f;
        if (duration <= 200 && !instance.method_48559()) {
            int n = 10 - duration / 20;
            alpha = class_3532.method_15363((float)((float)duration / 10.0f / 5.0f * 0.5f), (float)0.0f, (float)0.5f) + class_3532.method_15362((double)((float)duration * (float)Math.PI / 5.0f)) * class_3532.method_15363((float)((float)n / 10.0f * 0.25f), (float)0.0f, (float)0.25f);
            alpha = class_3532.method_15363((float)alpha, (float)0.0f, (float)1.0f);
        }
        return alpha;
    }

    public String buildEffectDurationString(int duration) {
        if (duration == -1) {
            return "--:--";
        }
        Object l = "";
        Object r = "";
        int seconds = duration / 20;
        int minutes = seconds / 60;
        int hours = minutes / 60;
        if (hours > 99) {
            return "--:--";
        }
        if (hours > 0) {
            if (hours < 10) {
                l = "0";
            }
            l = (String)l + hours;
            if ((minutes %= 60) < 10) {
                r = "0";
            }
            r = (String)r + minutes;
        } else {
            if (minutes < 10) {
                l = "0";
            }
            l = (String)l + minutes;
            if ((seconds %= 60) < 10) {
                r = "0";
            }
            r = (String)r + seconds;
        }
        return (String)l + ":" + (String)r;
    }

    public static class_2960 getStatusEffectTexture(class_6880<class_1291> effect) {
        return STATUS_EFFECT_TEXTURE_MAP.computeIfAbsent(effect, e -> e.method_40230().map(class_5321::method_29177).map(id -> class_2960.method_60655((String)id.method_12836(), (String)("textures/mob_effect/" + id.method_12832() + ".png"))).orElseGet(class_1047::method_4539));
    }
}

