/*
 * Decompiled with CFR 0.152.
 */
package fin.starhud.hud;

import fin.starhud.config.BaseHUDSettings;
import fin.starhud.config.ConditionalSettings;
import fin.starhud.helper.Box;
import fin.starhud.hud.HUDInterface;
import net.minecraft.class_310;
import net.minecraft.class_332;

public abstract class AbstractHUD
implements HUDInterface {
    protected final BaseHUDSettings baseHUDSettings;
    private int baseX;
    private int baseY;
    private int totalXOffset;
    private int totalYOffset;
    protected final Box boundingBox = new Box(-1, -1, -1, -1);
    public String groupId = null;

    public AbstractHUD(BaseHUDSettings baseHUDSettings) {
        this.baseHUDSettings = baseHUDSettings;
    }

    @Override
    public boolean shouldRender() {
        return this.getSettings().shouldRender();
    }

    @Override
    public void update() {
        this.baseX = this.getSettings().getCalculatedPosX();
        this.baseY = this.getSettings().getCalculatedPosY();
        if (!this.isInGroup()) {
            this.setXY(this.baseX + this.totalXOffset - this.getGrowthDirectionHorizontal(this.getWidth()), this.baseY + this.totalYOffset - this.getGrowthDirectionVertical(this.getHeight()));
            this.setScale(this.getSettings().getScale());
        }
    }

    @Override
    public boolean render(class_332 context) {
        if (!this.isScaled()) {
            return this.renderHUD(context, this.getX(), this.getY(), this.shouldDrawBackground());
        }
        context.method_51448().pushMatrix();
        this.scaleHUD(context);
        try {
            boolean bl = this.renderHUD(context, this.getX(), this.getY(), this.shouldDrawBackground());
            return bl;
        }
        finally {
            context.method_51448().popMatrix();
        }
    }

    @Override
    public boolean collect() {
        if (!this.collectHUDInformation()) {
            return false;
        }
        this.modifyXY();
        this.setXY(this.baseX + this.totalXOffset - this.getGrowthDirectionHorizontal(this.getWidth()), this.baseY + this.totalYOffset - this.getGrowthDirectionVertical(this.getHeight()));
        this.setScale(this.getSettings().getScale());
        return true;
    }

    public abstract boolean collectHUDInformation();

    public abstract boolean renderHUD(class_332 var1, int var2, int var3, boolean var4);

    public abstract String getName();

    public void scaleHUD(class_332 context) {
        float scaleFactor = this.getScale() / (float)class_310.method_1551().method_22683().method_4495();
        context.method_51448().scale(scaleFactor, scaleFactor);
    }

    public void modifyXY() {
        int xOffset = 0;
        int yOffset = 0;
        float scaleFactor = this.getSettings().getScaledFactor();
        for (ConditionalSettings condition : this.baseHUDSettings.getConditions()) {
            if (condition.renderMode == ConditionalSettings.RenderMode.HIDE || !condition.isConditionMet()) continue;
            xOffset += condition.getXOffset(scaleFactor);
            yOffset += condition.getYOffset(scaleFactor);
        }
        this.totalXOffset = xOffset;
        this.totalYOffset = yOffset;
    }

    public boolean isScaled() {
        return this.getScale() != 0.0f && this.getScale() != (float)class_310.method_1551().method_22683().method_4495();
    }

    public boolean isInGroup() {
        return this.groupId != null;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public BaseHUDSettings getSettings() {
        return this.baseHUDSettings;
    }

    public int getGrowthDirectionHorizontal(int dynamicWidth) {
        return this.getSettings().getGrowthDirectionHorizontal(dynamicWidth);
    }

    public int getGrowthDirectionVertical(int dynamicHeight) {
        return this.getSettings().getGrowthDirectionVertical(dynamicHeight);
    }

    public boolean shouldDrawBackground() {
        return this.getSettings().drawBackground;
    }

    public void setWidthHeight(int width, int height) {
        this.boundingBox.setWidthHeight(width, height);
    }

    public void setWidthHeightColor(int width, int height, int color) {
        this.boundingBox.setWidthHeightColor(width, height, color);
    }

    public void setXY(int x, int y) {
        this.boundingBox.setX(x);
        this.boundingBox.setY(y);
    }

    public void setScale(float scale) {
        this.boundingBox.setScale(scale);
    }

    public int getX() {
        return this.getBoundingBox().getX();
    }

    public int getY() {
        return this.getBoundingBox().getY();
    }

    public int getWidth() {
        return this.getBoundingBox().getWidth();
    }

    public int getHeight() {
        return this.getBoundingBox().getHeight();
    }

    public int getColor() {
        return this.getBoundingBox().getColor();
    }

    public float getScale() {
        return this.getBoundingBox().getScale();
    }

    public Box getBoundingBox() {
        return this.boundingBox;
    }

    public void copyBoundingBox(Box boundingBox) {
        if (boundingBox != null) {
            this.boundingBox.copyFrom(boundingBox);
        }
    }

    public void setBoundingBox(int x, int y, int width, int height, int color) {
        this.boundingBox.setBoundingBox(x, y, width, height, color);
    }

    public void setBoundingBox(int x, int y, int width, int height) {
        this.boundingBox.setBoundingBox(x, y, width, height);
    }

    public boolean isHovered(int mouseX, int mouseY) {
        int x = this.getX();
        int y = this.getY();
        int width = this.getWidth();
        int height = this.getHeight();
        if (this.isScaled()) {
            float scale = (float)class_310.method_1551().method_22683().method_4495() / this.getScale();
            int scaledMouseX = (int)((float)mouseX * scale);
            int scaledMouseY = (int)((float)mouseY * scale);
            return scaledMouseX >= x && scaledMouseX <= x + width && scaledMouseY >= y && scaledMouseY <= y + height;
        }
        return mouseX >= x && mouseX <= x + width && mouseY >= y && mouseY <= y + height;
    }

    public boolean intersects(int x1, int y1, int x2, int y2) {
        int hudLeft = this.getX();
        int hudTop = this.getY();
        int hudRight = this.getX() + this.getWidth();
        int hudBottom = this.getY() + this.getHeight();
        if (this.isScaled()) {
            float scaleFactor = (float)class_310.method_1551().method_22683().method_4495() / this.getScale();
            int scaledX1 = (int)((float)x1 * scaleFactor);
            int scaledY1 = (int)((float)y1 * scaleFactor);
            int scaledX2 = (int)((float)x2 * scaleFactor);
            int scaledY2 = (int)((float)y2 * scaleFactor);
            return hudRight >= Math.min(scaledX1, scaledX2) && hudLeft <= Math.max(scaledX1, scaledX2) && hudBottom >= Math.min(scaledY1, scaledY2) && hudTop <= Math.max(scaledY1, scaledY2);
        }
        return hudRight >= Math.min(x1, x2) && hudLeft <= Math.max(x1, x2) && hudBottom >= Math.min(y1, y2) && hudTop <= Math.max(y1, y2);
    }

    public void clampPos() {
        int scaledWidth = class_310.method_1551().method_22683().method_4486();
        int scaledHeight = class_310.method_1551().method_22683().method_4502();
        int x1 = 0;
        int y1 = 0;
        int x2 = scaledWidth;
        int y2 = scaledHeight;
        if (this.isScaled()) {
            float scaleFactor = (float)class_310.method_1551().method_22683().method_4495() / this.getScale();
            x1 = (int)((float)x1 * scaleFactor);
            y1 = (int)((float)y1 * scaleFactor);
            x2 = (int)((float)x2 * scaleFactor);
            y2 = (int)((float)y2 * scaleFactor);
        }
        int hudLeft = this.getX();
        int hudTop = this.getY();
        int hudRight = hudLeft + this.getWidth();
        int hudBottom = hudTop + this.getHeight();
        int xOffset = 0;
        int yOffset = 0;
        if (hudLeft < x1) {
            xOffset = x1 - hudLeft;
        } else if (hudRight > x2) {
            xOffset = x2 - hudRight;
        }
        if (hudTop < y1) {
            yOffset = y1 - hudTop;
        } else if (hudBottom > y2) {
            yOffset = y2 - hudBottom;
        }
        if (xOffset != 0 || yOffset != 0) {
            this.getSettings().x += xOffset;
            this.getSettings().y += yOffset;
            this.baseX = this.getSettings().getCalculatedPosX();
            this.baseY = this.getSettings().getCalculatedPosY();
            this.setXY(this.baseX + this.totalXOffset - this.getGrowthDirectionHorizontal(this.getWidth()), this.baseY + this.totalYOffset - this.getGrowthDirectionVertical(this.getHeight()));
        }
    }
}

