/*
 * Decompiled with CFR 0.152.
 */
package fin.starhud.config;

import fin.starhud.config.BaseHUDSettings;
import fin.starhud.helper.GrowthDirectionX;
import fin.starhud.helper.GrowthDirectionY;
import fin.starhud.helper.ScreenAlignmentX;
import fin.starhud.helper.ScreenAlignmentY;
import fin.starhud.hud.HUDComponent;
import java.util.ArrayList;
import java.util.List;
import me.shedaniel.autoconfig.annotation.ConfigEntry;
import me.shedaniel.cloth.clothconfig.shadowed.blue.endless.jankson.Comment;
import net.minecraft.class_1074;

public class GroupedHUDSettings {
    @ConfigEntry.Gui.TransitiveObject
    public BaseHUDSettings base;
    @ConfigEntry.Gui.Excluded
    public int gap = 0;
    @ConfigEntry.Gui.Excluded
    public boolean alignVertical = false;
    @ConfigEntry.Gui.EnumHandler(option=ConfigEntry.Gui.EnumHandler.EnumDisplayOption.BUTTON)
    @ConfigEntry.Gui.Excluded
    public ChildAlignment childAlignment = ChildAlignment.GROUP;
    @ConfigEntry.Gui.Excluded
    public ChildOrdering childOrdering = ChildOrdering.NONE;
    @ConfigEntry.ColorPicker
    public int boxColor = 0xFFFFFF;
    @Comment(value="DO NOT BY ANY MEANS CHANGE THIS DIRECTLY FROM THE CONFIG SCREEN. THIS IS FOR DISPLAY ONLY!")
    public List<String> hudIds = new ArrayList<String>();
    @ConfigEntry.Gui.Excluded
    public String id;

    public GroupedHUDSettings(BaseHUDSettings base) {
        this.base = base;
        this.id = HUDComponent.getInstance().generateNextGroupId();
    }

    public GroupedHUDSettings(BaseHUDSettings base, String id, int gap, boolean alignVertical, ChildAlignment childAlignment, int boxColor, List<String> hudIds) {
        this.base = base;
        this.id = id;
        this.gap = gap;
        this.alignVertical = alignVertical;
        this.childAlignment = childAlignment;
        this.boxColor = boxColor;
        this.hudIds = hudIds;
    }

    public GroupedHUDSettings(BaseHUDSettings base, int id, int gap, boolean alignVertical, int boxColor, List<String> hudIds) {
        this.base = base;
        this.id = "group_" + id;
        this.gap = gap;
        this.alignVertical = alignVertical;
        this.boxColor = boxColor;
        this.hudIds = hudIds;
    }

    public GroupedHUDSettings() {
        this(new BaseHUDSettings(true, 0, 0, ScreenAlignmentX.LEFT, ScreenAlignmentY.TOP, GrowthDirectionX.RIGHT, GrowthDirectionY.DOWN, false));
    }

    public ChildAlignment getChildAlignment() {
        if (this.childAlignment == null) {
            this.childAlignment = ChildAlignment.GROUP;
        }
        return this.childAlignment;
    }

    public ChildOrdering getChildOrdering() {
        if (this.childOrdering == null) {
            this.childOrdering = ChildOrdering.NONE;
        }
        return this.childOrdering;
    }

    public boolean isEqual(GroupedHUDSettings other) {
        return this.base.isEqual(other.base) && this.gap == other.gap && this.alignVertical == other.alignVertical && this.childAlignment == other.childAlignment && this.childOrdering == other.childOrdering && this.hudIds.equals(other.hudIds) && this.id.equals(other.id);
    }

    public void copyFrom(GroupedHUDSettings other) {
        this.base.copyFrom(other.base);
        this.gap = other.gap;
        this.alignVertical = other.alignVertical;
        this.childAlignment = other.childAlignment;
        this.childOrdering = other.childOrdering;
        this.hudIds = new ArrayList<String>(other.hudIds);
        this.id = other.id;
    }

    public GroupedHUDSettings copy() {
        GroupedHUDSettings newSettings = new GroupedHUDSettings();
        newSettings.copyFrom(this);
        return newSettings;
    }

    public String toString() {
        return "GroupedHUDSettings{id='" + this.id + "', hudIds=" + String.valueOf(this.hudIds) + ", gap=" + this.gap + ", alignVertical=" + this.alignVertical + ", childAlignment=" + String.valueOf((Object)this.childAlignment) + ", childOrdering" + String.valueOf((Object)this.childOrdering) + ", boxColor=0x" + Integer.toHexString(this.boxColor).toUpperCase() + ", base=" + String.valueOf(this.base) + ", ptr=" + this.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(this)) + "}";
    }

    public static enum ChildAlignment {
        GROUP,
        CHILD,
        START,
        CENTER,
        END;


        public ChildAlignment next() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> CHILD;
                case 1 -> START;
                case 2 -> CENTER;
                case 3 -> END;
                case 4 -> GROUP;
            };
        }

        public String toString() {
            return class_1074.method_4662((String)("starhud.option.childAlignment." + this.name().toLowerCase()), (Object[])new Object[0]);
        }
    }

    public static enum ChildOrdering {
        NONE,
        WIDTH_ASCENDING,
        WIDTH_DESCENDING,
        HEIGHT_ASCENDING,
        HEIGHT_DESCENDING;


        public ChildOrdering next() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> WIDTH_ASCENDING;
                case 1 -> WIDTH_DESCENDING;
                case 2 -> HEIGHT_ASCENDING;
                case 3 -> HEIGHT_DESCENDING;
                case 4 -> NONE;
            };
        }

        public String toString() {
            return class_1074.method_4662((String)("starhud.option.childOrdering." + this.name().toLowerCase()), (Object[])new Object[0]);
        }
    }
}

