/*
 * Decompiled with CFR 0.152.
 */
package fin.starhud.config;

import fin.starhud.config.BaseHUDSettings;
import fin.starhud.config.GroupedHUDSettings;
import fin.starhud.helper.GrowthDirectionX;
import fin.starhud.helper.GrowthDirectionY;
import fin.starhud.helper.ScreenAlignmentX;
import fin.starhud.helper.ScreenAlignmentY;
import fin.starhud.hud.HUDId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import me.shedaniel.autoconfig.annotation.ConfigEntry;
import me.shedaniel.cloth.clothconfig.shadowed.blue.endless.jankson.Comment;

public class HUDList {
    @ConfigEntry.Gui.Excluded
    public List<String> individualHudIds = new ArrayList<String>();
    @Comment(value="It's not recommended to modify grouped HUD directly on the configuration screen.")
    public List<GroupedHUDSettings> groupedHuds = new ArrayList<GroupedHUDSettings>();

    public HUDList(List<String> individualHudIds, List<GroupedHUDSettings> groupedHuds) {
        this.individualHudIds = individualHudIds;
        this.groupedHuds = groupedHuds;
    }

    public HUDList() {
        this.groupedHuds.add(new GroupedHUDSettings(new BaseHUDSettings(true, 5, 0, ScreenAlignmentX.LEFT, ScreenAlignmentY.MIDDLE, GrowthDirectionX.RIGHT, GrowthDirectionY.MIDDLE, false), 1, 1, true, 0xFFFFFF, new ArrayList<String>(List.of(HUDId.HELMET.toString(), HUDId.CHESTPLATE.toString(), HUDId.LEGGINGS.toString(), HUDId.BOOTS.toString()))));
        this.groupedHuds.add(new GroupedHUDSettings(new BaseHUDSettings(true, -5, 5, ScreenAlignmentX.RIGHT, ScreenAlignmentY.TOP, GrowthDirectionX.LEFT, GrowthDirectionY.DOWN, false), 2, 2, true, 14024431, new ArrayList<String>(List.of(HUDId.POSITIVE_EFFECT.toString(), HUDId.NEGATIVE_EFFECT.toString()))));
        this.groupedHuds.add(new GroupedHUDSettings(new BaseHUDSettings(true, 0, 5, ScreenAlignmentX.CENTER, ScreenAlignmentY.TOP, GrowthDirectionX.CENTER, GrowthDirectionY.DOWN, false), 3, 3, false, 0xFFFFFF, new ArrayList<String>(List.of(HUDId.BIOME.toString(), HUDId.CLOCK_INGAME.toString()))));
        this.groupedHuds.add(new GroupedHUDSettings(new BaseHUDSettings(true, -5, -5, ScreenAlignmentX.RIGHT, ScreenAlignmentY.BOTTOM, GrowthDirectionX.LEFT, GrowthDirectionY.UP, false), 4, 3, false, 8778384, new ArrayList<String>(List.of(HUDId.TPS.toString(), HUDId.PING.toString(), HUDId.CLOCK_SYSTEM.toString()))));
    }

    public void onConfigSaved() {
        Set validHudIds = Arrays.stream(HUDId.values()).map(Enum::toString).collect(Collectors.toSet());
        this.individualHudIds.removeIf(id -> !validHudIds.contains(id));
        Iterator<GroupedHUDSettings> it = this.groupedHuds.iterator();
        while (it.hasNext()) {
            Iterator<Object> group2 = it.next();
            ((GroupedHUDSettings)((Object)group2)).hudIds.removeIf(id -> !this.isValidHudOrGroupId((String)id, validHudIds));
            if (!((GroupedHUDSettings)((Object)group2)).hudIds.isEmpty()) continue;
            it.remove();
        }
        HashMap<String, Integer> appearanceMap = new HashMap<String, Integer>();
        for (String string : this.individualHudIds) {
            appearanceMap.put(string, appearanceMap.getOrDefault(string, 0) + 1);
        }
        for (GroupedHUDSettings groupedHUDSettings : this.groupedHuds) {
            for (String id3 : groupedHUDSettings.hudIds) {
                appearanceMap.put(id3, appearanceMap.getOrDefault(id3, 0) + 1);
            }
        }
        for (Map.Entry entry : appearanceMap.entrySet()) {
            String id4 = (String)entry.getKey();
            int count = (Integer)entry.getValue();
            if (count == 1) continue;
            boolean inIndividual = this.individualHudIds.contains(id4);
            boolean inGrouped = this.groupedHuds.stream().anyMatch(group -> group.hudIds.contains(id4));
            if (count == 2 && inIndividual && inGrouped) {
                this.individualHudIds.remove(id4);
                continue;
            }
            for (GroupedHUDSettings group4 : this.groupedHuds) {
                group4.hudIds.removeIf(hudId -> hudId.equals(id4));
            }
            this.individualHudIds.removeIf(hudId -> hudId.equals(id4));
        }
        HashSet<String> allRepresentedIds = new HashSet<String>(this.individualHudIds);
        for (GroupedHUDSettings group5 : this.groupedHuds) {
            allRepresentedIds.addAll(group5.hudIds);
        }
        for (HUDId id5 : HUDId.values()) {
            if (allRepresentedIds.contains(id5.toString())) continue;
            this.individualHudIds.add(id5.toString());
        }
    }

    private boolean isValidHudOrGroupId(String id, Set<String> validHudIds) {
        return validHudIds.contains(id) || id.matches("^group_\\d+$");
    }
}

