/*
 * Decompiled with CFR 0.152.
 */
package fin.starhud.hud.implementation.other;

import fin.starhud.Main;
import fin.starhud.config.hud.DirectionSettings;
import fin.starhud.helper.HUDDisplayMode;
import fin.starhud.helper.RenderUtils;
import fin.starhud.hud.AbstractHUD;
import fin.starhud.hud.HUDId;
import net.minecraft.class_1297;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;

public class DirectionHUD
extends AbstractHUD {
    private static final DirectionSettings DIRECTION_SETTINGS = Main.settings.directionSettings;
    private static final class_2960 DIRECTION_CARDINAL_TEXTURE = class_2960.method_60655((String)"starhud", (String)"hud/direction.png");
    private static final class_2960 DIRECTION_ORDINAL_TEXTURE = class_2960.method_60655((String)"starhud", (String)"hud/direction_ordinal.png");
    private static final int ORDINAL_TEXTURE_WIDTH = 19;
    private static final int ORDINAL_TEXTURE_HEIGHT = 104;
    private static final int ORDINAL_ICON_WIDTH = 19;
    private static final int ORDINAL_ICON_HEIGHT = 13;
    private static final int CARDINAL_TEXTURE_WIDTH = 13;
    private static final int CARDINAL_TEXTURE_HEIGHT = 52;
    private static final int CARDINAL_ICON_WIDTH = 13;
    private static final int CARDINAL_ICON_HEIGHT = 13;
    private static final class_310 CLIENT = class_310.method_1551();
    private String yawStr;
    private int iconIndex;
    private int color;
    private boolean includeOrdinal;
    private HUDDisplayMode displayMode;

    public DirectionHUD() {
        super(DirectionHUD.DIRECTION_SETTINGS.base);
    }

    @Override
    public String getName() {
        return "Direction HUD";
    }

    @Override
    public String getId() {
        return HUDId.DIRECTION.toString();
    }

    @Override
    public boolean collectHUDInformation() {
        int height;
        int width;
        class_1297 camera = CLIENT.method_1560();
        if (camera == null) {
            return false;
        }
        float yaw = (float)Math.round(class_3532.method_15393((float)camera.method_36454()) * 10.0f) / 10.0f;
        this.yawStr = Float.toString(yaw);
        int yawWidth = DirectionHUD.CLIENT.field_1772.method_1727(this.yawStr) - 1;
        this.includeOrdinal = DirectionHUD.DIRECTION_SETTINGS.includeOrdinal;
        this.displayMode = this.getSettings().getDisplayMode();
        if (this.includeOrdinal) {
            this.iconIndex = DirectionHUD.getOrdinalDirectionIcon(yaw);
            width = this.displayMode.calculateWidth(19, yawWidth);
            height = 13;
            this.color = DirectionHUD.getDirectionColor(this.iconIndex) | 0xFF000000;
        } else {
            this.iconIndex = DirectionHUD.getCardinalDirectionIcon(yaw);
            width = this.displayMode.calculateWidth(13, yawWidth);
            height = 13;
            this.color = DirectionHUD.getDirectionColor(this.iconIndex * 2) | 0xFF000000;
        }
        this.setWidthHeightColor(width, height, this.color);
        return this.yawStr != null;
    }

    @Override
    public boolean renderHUD(class_332 context, int x, int y, boolean drawBackground) {
        int w = this.getWidth();
        int h = this.getHeight();
        if (this.includeOrdinal) {
            return RenderUtils.drawSmallHUD(context, this.yawStr, x, y, w, h, DIRECTION_ORDINAL_TEXTURE, 0.0f, (float)(13 * this.iconIndex), 19, 104, 19, 13, this.color, this.displayMode, drawBackground);
        }
        return RenderUtils.drawSmallHUD(context, this.yawStr, x, y, w, h, DIRECTION_CARDINAL_TEXTURE, 0.0f, (float)(13 * this.iconIndex), 13, 52, 13, 13, this.color, this.displayMode, drawBackground);
    }

    private static int getOrdinalDirectionIcon(float yaw) {
        if (-22.5 <= (double)yaw && (double)yaw < 22.5) {
            return 0;
        }
        if (22.5 <= (double)yaw && (double)yaw < 67.5) {
            return 1;
        }
        if (67.5 <= (double)yaw && (double)yaw < 112.5) {
            return 2;
        }
        if (112.5 <= (double)yaw && (double)yaw < 157.5) {
            return 3;
        }
        if (157.5 <= (double)yaw || (double)yaw < -157.5) {
            return 4;
        }
        if (-157.5 <= (double)yaw && (double)yaw < -112.5) {
            return 5;
        }
        if (-112.5 <= (double)yaw && (double)yaw < -67.5) {
            return 6;
        }
        if (-67.5 <= (double)yaw && (double)yaw < -22.5) {
            return 7;
        }
        return 0;
    }

    private static int getCardinalDirectionIcon(float yaw) {
        if (-45.0 <= (double)yaw && (double)yaw < 45.0) {
            return 0;
        }
        if (45.0 <= (double)yaw && (double)yaw < 135.0) {
            return 1;
        }
        if (135.0 <= (double)yaw || (double)yaw < -135.0) {
            return 2;
        }
        if (-135.0 <= (double)yaw && (double)yaw < -45.0) {
            return 3;
        }
        return 0;
    }

    private static int getDirectionColor(int icon) {
        return switch (icon) {
            case 0 -> DirectionHUD.DIRECTION_SETTINGS.directionColor.s;
            case 1 -> DirectionHUD.DIRECTION_SETTINGS.directionColor.sw;
            case 2 -> DirectionHUD.DIRECTION_SETTINGS.directionColor.w;
            case 3 -> DirectionHUD.DIRECTION_SETTINGS.directionColor.nw;
            case 4 -> DirectionHUD.DIRECTION_SETTINGS.directionColor.n;
            case 5 -> DirectionHUD.DIRECTION_SETTINGS.directionColor.ne;
            case 6 -> DirectionHUD.DIRECTION_SETTINGS.directionColor.e;
            case 7 -> DirectionHUD.DIRECTION_SETTINGS.directionColor.se;
            default -> 0xFFFFFF;
        };
    }
}

