/*
 * Decompiled with CFR 0.152.
 */
package fin.starhud.hud.implementation.other;

import fin.starhud.Helper;
import fin.starhud.Main;
import fin.starhud.config.hud.PingSettings;
import fin.starhud.helper.HUDDisplayMode;
import fin.starhud.helper.RenderUtils;
import fin.starhud.hud.AbstractHUD;
import fin.starhud.hud.HUDId;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_638;
import net.minecraft.class_8761;
import net.minecraft.class_9191;

public class PingHUD
extends AbstractHUD {
    private static final PingSettings SETTINGS = Main.settings.pingSettings;
    private static final class_2960 PING_TEXTURE = class_2960.method_60655((String)"starhud", (String)"hud/ping.png");
    private static final int TEXTURE_WIDTH = 13;
    private static final int TEXTURE_HEIGHT = 52;
    private static final int ICON_WIDTH = 13;
    private static final int ICON_HEIGHT = 13;
    private static long LAST_PING_UPDATE = -1L;
    private static class_1937 LAST_WORLD = null;
    private static class_8761 cachedPingMeasurer;
    private static final class_310 CLIENT;
    private String pingStr;
    private int strWidth;
    private int color;
    private int step;
    private HUDDisplayMode displayMode;

    public PingHUD() {
        super(PingHUD.SETTINGS.base);
    }

    @Override
    public String getName() {
        return "Ping HUD";
    }

    @Override
    public String getId() {
        return HUDId.PING.toString();
    }

    @Override
    public boolean collectHUDInformation() {
        long currentTimeMillis;
        this.displayMode = this.getSettings().getDisplayMode();
        class_9191 pingLog = CLIENT.method_53526().method_53543();
        class_638 currentWorld = PingHUD.CLIENT.field_1687;
        if (currentWorld != LAST_WORLD) {
            cachedPingMeasurer = new class_8761(CLIENT.method_1562(), pingLog);
            LAST_WORLD = currentWorld;
        }
        if ((double)((currentTimeMillis = System.currentTimeMillis()) - LAST_PING_UPDATE) >= 1000.0 * PingHUD.SETTINGS.updateInterval) {
            LAST_PING_UPDATE = currentTimeMillis;
            cachedPingMeasurer.method_53486();
            int pingLogLen = pingLog.method_56663();
            if (pingLogLen > 0) {
                long currentPing = pingLog.method_56659(pingLogLen - 1);
                this.pingStr = currentPing + PingHUD.SETTINGS.additionalString;
                this.strWidth = PingHUD.CLIENT.field_1772.method_1727(this.pingStr) - 1;
                this.step = Math.min((int)currentPing / 150, 3);
            }
        }
        this.color = (PingHUD.SETTINGS.useDynamicColor ? Helper.getItemBarColor(3 - this.step, 3) : PingHUD.SETTINGS.color) | 0xFF000000;
        int width = this.displayMode.calculateWidth(13, this.strWidth);
        this.setWidthHeightColor(width, 13, this.color);
        return this.pingStr != null;
    }

    @Override
    public boolean renderHUD(class_332 context, int x, int y, boolean drawBackground) {
        int w = this.getWidth();
        int h = this.getHeight();
        return RenderUtils.drawSmallHUD(context, this.pingStr, x, y, w, h, PING_TEXTURE, 0.0f, (float)(13 * this.step), 13, 52, 13, 13, this.color, this.displayMode, drawBackground);
    }

    static {
        CLIENT = class_310.method_1551();
    }
}

