/*
 * Decompiled with CFR 0.152.
 */
package fin.starhud.config;

import fin.starhud.config.ConditionalSettings;
import fin.starhud.helper.GrowthDirectionX;
import fin.starhud.helper.GrowthDirectionY;
import fin.starhud.helper.HUDDisplayMode;
import fin.starhud.helper.ScreenAlignmentX;
import fin.starhud.helper.ScreenAlignmentY;
import java.util.ArrayList;
import java.util.List;
import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.annotation.ConfigEntry;
import me.shedaniel.cloth.clothconfig.shadowed.blue.endless.jankson.Comment;
import net.minecraft.class_1041;
import net.minecraft.class_310;

public class BaseHUDSettings
implements ConfigData {
    @Comment(value="Toggle HUD")
    public boolean shouldRender;
    @ConfigEntry.Gui.Excluded
    public int x;
    @ConfigEntry.Gui.Excluded
    public int y;
    @Comment(value="HUD default Horizontal location")
    @ConfigEntry.Gui.EnumHandler(option=ConfigEntry.Gui.EnumHandler.EnumDisplayOption.BUTTON)
    @ConfigEntry.Gui.Excluded
    public ScreenAlignmentX originX;
    @Comment(value="HUD default Vertical location")
    @ConfigEntry.Gui.EnumHandler(option=ConfigEntry.Gui.EnumHandler.EnumDisplayOption.BUTTON)
    @ConfigEntry.Gui.Excluded
    public ScreenAlignmentY originY;
    @Comment(value="Which way should the HUD goes when the length increases horizontally? (Recommended to go the opposite way from Alignment)")
    @ConfigEntry.Gui.EnumHandler(option=ConfigEntry.Gui.EnumHandler.EnumDisplayOption.BUTTON)
    @ConfigEntry.Gui.Excluded
    public GrowthDirectionX growthDirectionX;
    @Comment(value="Which way should the HUD goes when the length increases vertically? (Recommended to go the opposite way from Alignment)")
    @ConfigEntry.Gui.EnumHandler(option=ConfigEntry.Gui.EnumHandler.EnumDisplayOption.BUTTON)
    @ConfigEntry.Gui.Excluded
    public GrowthDirectionY growthDirectionY;
    @ConfigEntry.Gui.EnumHandler(option=ConfigEntry.Gui.EnumHandler.EnumDisplayOption.BUTTON)
    @ConfigEntry.Gui.Excluded
    public HUDDisplayMode displayMode = HUDDisplayMode.BOTH;
    @ConfigEntry.Gui.Excluded
    public boolean drawBackground = true;
    @Comment(value="Set to 0 or below for default GUI Scale")
    @ConfigEntry.Gui.Excluded
    public float scale = 0.0f;
    @Comment(value="Modify HUD Based on Conditions.")
    public List<ConditionalSettings> conditions = new ArrayList<ConditionalSettings>();

    public BaseHUDSettings() {
    }

    public BaseHUDSettings(boolean shouldRender, int x, int y, ScreenAlignmentX originX, ScreenAlignmentY originY, GrowthDirectionX growthDirectionX, GrowthDirectionY growthDirectionY) {
        this.shouldRender = shouldRender;
        this.x = x;
        this.y = y;
        this.originX = originX;
        this.originY = originY;
        this.growthDirectionX = growthDirectionX;
        this.growthDirectionY = growthDirectionY;
    }

    public BaseHUDSettings(boolean shouldRender, int x, int y, ScreenAlignmentX originX, ScreenAlignmentY originY, GrowthDirectionX growthDirectionX, GrowthDirectionY growthDirectionY, float scale, HUDDisplayMode displayMode, boolean drawBackground) {
        this(shouldRender, x, y, originX, originY, growthDirectionX, growthDirectionY);
        this.scale = scale;
        this.displayMode = displayMode;
        this.drawBackground = drawBackground;
    }

    public BaseHUDSettings(boolean shouldRender, int x, int y, ScreenAlignmentX originX, ScreenAlignmentY originY, GrowthDirectionX growthDirectionX, GrowthDirectionY growthDirectionY, boolean drawBackground) {
        this.shouldRender = shouldRender;
        this.x = x;
        this.y = y;
        this.originX = originX;
        this.originY = originY;
        this.growthDirectionX = growthDirectionX;
        this.growthDirectionY = growthDirectionY;
        this.drawBackground = drawBackground;
    }

    public boolean shouldRender() {
        if (!this.shouldRender) {
            return false;
        }
        boolean hasAnyRenderIfActive = false;
        for (ConditionalSettings condition : this.conditions) {
            switch (condition.renderMode) {
                case HIDE: {
                    if (!condition.isConditionMet()) break;
                    return false;
                }
                case RENDER_IF_ACTIVE: {
                    hasAnyRenderIfActive = true;
                    if (!condition.isConditionMet()) break;
                    return true;
                }
            }
        }
        return !hasAnyRenderIfActive;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public GrowthDirectionX getGrowthDirectionX() {
        if (this.growthDirectionX == null) {
            this.growthDirectionX = this.getX() > 0 ? GrowthDirectionX.RIGHT : (this.getX() < 0 ? GrowthDirectionX.LEFT : GrowthDirectionX.CENTER);
        }
        return this.growthDirectionX;
    }

    public GrowthDirectionY getGrowthDirectionY() {
        if (this.growthDirectionY == null) {
            this.growthDirectionY = this.getY() > 0 ? GrowthDirectionY.DOWN : (this.getY() < 0 ? GrowthDirectionY.UP : GrowthDirectionY.MIDDLE);
        }
        return this.growthDirectionY;
    }

    public ScreenAlignmentX getOriginX() {
        if (this.originX == null) {
            this.originX = this.getX() > 0 ? ScreenAlignmentX.LEFT : (this.getX() < 0 ? ScreenAlignmentX.RIGHT : ScreenAlignmentX.CENTER);
        }
        return this.originX;
    }

    public ScreenAlignmentY getOriginY() {
        if (this.originY == null) {
            this.originY = this.getY() > 0 ? ScreenAlignmentY.TOP : (this.getY() < 0 ? ScreenAlignmentY.BOTTOM : ScreenAlignmentY.MIDDLE);
        }
        return this.originY;
    }

    public HUDDisplayMode getDisplayMode() {
        if (this.displayMode == null) {
            this.displayMode = HUDDisplayMode.BOTH;
        }
        return this.displayMode;
    }

    public float getScale() {
        if (this.scale < 0.0f) {
            this.scale = 0.0f;
        }
        return this.scale;
    }

    public List<ConditionalSettings> getConditions() {
        return this.conditions;
    }

    public String toString() {
        return "BaseHUDSettings{shouldRender=" + this.shouldRender + ", x=" + this.x + ", y=" + this.y + ", originX=" + String.valueOf((Object)this.originX) + ", originY=" + String.valueOf((Object)this.originY) + ", growthDirectionX=" + String.valueOf((Object)this.growthDirectionX) + ", growthDirectionY=" + String.valueOf((Object)this.growthDirectionY) + ", scale=" + this.scale + ", conditions=" + String.valueOf(this.conditions) + ", displayMode=" + String.valueOf((Object)this.displayMode) + ", drawBackground=" + this.drawBackground + "}";
    }

    public boolean isEqual(BaseHUDSettings other) {
        return this.shouldRender == other.shouldRender && this.x == other.x && this.y == other.y && this.originX == other.originX && this.originY == other.originY && this.growthDirectionX == other.growthDirectionX && this.growthDirectionY == other.growthDirectionY && this.scale == other.scale && this.conditions.equals(other.conditions) && this.displayMode == other.displayMode && this.drawBackground == other.drawBackground;
    }

    public void copyFrom(BaseHUDSettings src) {
        this.shouldRender = src.shouldRender;
        this.x = src.x;
        this.y = src.y;
        this.originX = src.originX;
        this.originY = src.originY;
        this.growthDirectionX = src.growthDirectionX;
        this.growthDirectionY = src.growthDirectionY;
        this.scale = src.scale;
        this.displayMode = src.displayMode;
        this.drawBackground = src.drawBackground;
        this.conditions.clear();
        this.conditions.addAll(src.conditions);
    }

    public BaseHUDSettings copy() {
        BaseHUDSettings newSettings = new BaseHUDSettings();
        newSettings.copyFrom(this);
        return newSettings;
    }

    public int getGrowthDirectionHorizontal(int dynamicWidth) {
        return this.getGrowthDirectionX().getGrowthDirection(dynamicWidth);
    }

    public int getGrowthDirectionVertical(int dynamicHeight) {
        return this.getGrowthDirectionY().getGrowthDirection(dynamicHeight);
    }

    public float getScaledFactor() {
        return this.getScale() <= 0.0f ? 1.0f : (float)class_310.method_1551().method_22683().method_4495() / this.getScale();
    }

    public int getCalculatedPosX() {
        class_1041 window = class_310.method_1551().method_22683();
        int scaledWidth = window == null ? 0 : window.method_4486();
        return this.getX() + (int)((float)this.getOriginX().getAlignmentPos(scaledWidth) * this.getScaledFactor());
    }

    public int getCalculatedPosY() {
        class_1041 window = class_310.method_1551().method_22683();
        int scaledHeight = window == null ? 0 : window.method_4502();
        return this.getY() + (int)((float)this.getOriginY().getAlignmentPos(scaledHeight) * this.getScaledFactor());
    }
}

