/*
 * Decompiled with CFR 0.152.
 */
package fin.starhud.hud.implementation.other;

import fin.starhud.Main;
import fin.starhud.config.hud.DaySettings;
import fin.starhud.helper.HUDDisplayMode;
import fin.starhud.helper.RenderUtils;
import fin.starhud.hud.AbstractHUD;
import fin.starhud.hud.HUDId;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;

public class DayHUD
extends AbstractHUD {
    private static final DaySettings DAY_SETTINGS = Main.settings.daySettings;
    private static final class_2960 DAY_TEXTURE = class_2960.method_60655((String)"starhud", (String)"hud/day.png");
    private static final int TEXTURE_WIDTH = 13;
    private static final int TEXTURE_HEIGHT = 13;
    private static final int ICON_WIDTH = 13;
    private static final int ICON_HEIGHT = 13;
    private long lastDay = -1L;
    private int cachedTextWidth;
    private String cachedDayString;
    private static final class_310 CLIENT = class_310.method_1551();
    private int color;
    private HUDDisplayMode displayMode;

    public DayHUD() {
        super(DayHUD.DAY_SETTINGS.base);
    }

    @Override
    public String getName() {
        return "Day HUD";
    }

    @Override
    public String getId() {
        return HUDId.DAY.toString();
    }

    @Override
    public void update() {
        super.update();
        this.lastDay = -1L;
    }

    @Override
    public boolean collectHUDInformation() {
        if (DayHUD.CLIENT.field_1687 == null) {
            return false;
        }
        long day = DayHUD.CLIENT.field_1687.method_8532() / 24000L;
        if (day != this.lastDay) {
            this.lastDay = day;
            this.cachedDayString = DayHUD.DAY_SETTINGS.additionalString + day;
            this.cachedTextWidth = DayHUD.CLIENT.field_1772.method_1727(this.cachedDayString) - 1;
        }
        this.displayMode = this.getSettings().getDisplayMode();
        this.color = DayHUD.DAY_SETTINGS.color | 0xFF000000;
        int width = this.displayMode.calculateWidth(13, this.cachedTextWidth);
        this.setWidthHeightColor(width, 13, this.color);
        return this.cachedDayString != null;
    }

    @Override
    public boolean renderHUD(class_332 context, int x, int y, boolean drawBackground) {
        int w = this.getWidth();
        int h = this.getHeight();
        return RenderUtils.drawSmallHUD(context, this.cachedDayString, x, y, w, h, DAY_TEXTURE, 0.0f, 0.0f, 13, 13, 13, 13, this.color, this.displayMode, drawBackground);
    }
}

