/*
 * Decompiled with CFR 0.152.
 */
package fin.starhud.screen;

import fin.starhud.Main;
import fin.starhud.config.BaseHUDSettings;
import fin.starhud.config.GeneralSettings;
import fin.starhud.config.GroupedHUDSettings;
import fin.starhud.config.Settings;
import fin.starhud.helper.Box;
import fin.starhud.helper.GrowthDirectionX;
import fin.starhud.helper.GrowthDirectionY;
import fin.starhud.helper.HUDDisplayMode;
import fin.starhud.helper.RenderUtils;
import fin.starhud.helper.ScreenAlignmentX;
import fin.starhud.helper.ScreenAlignmentY;
import fin.starhud.hud.AbstractHUD;
import fin.starhud.hud.GroupedHUD;
import fin.starhud.hud.HUDComponent;
import fin.starhud.hud.HUDId;
import fin.starhud.screen.HelpWidget;
import fin.starhud.screen.history.CompositeAction;
import fin.starhud.screen.history.HUDAction;
import fin.starhud.screen.history.HUDHistory;
import fin.starhud.screen.history.ReversibleAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import me.shedaniel.autoconfig.AutoConfig;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_3545;
import net.minecraft.class_364;
import net.minecraft.class_410;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_7919;
import org.joml.Vector2d;
import org.slf4j.Logger;

public class EditHUDScreen
extends class_437 {
    private static final Logger LOGGER = Main.LOGGER;
    private static final class_310 CLIENT = class_310.method_1551();
    private static final GeneralSettings.EditHUDScreenSettings SETTINGS = Main.settings.generalSettings.screenSettings;
    public static final int PADDING = 25;
    public static final int WIDGET_WIDTH = 100;
    public static final int WIDGET_HEIGHT = 20;
    public static final int TEXT_FIELD_WIDTH = 40;
    public static final int SQUARE_WIDGET_LENGTH = 20;
    public static final int GAP = 5;
    public static final boolean isMac = System.getProperty("os.name").toLowerCase().contains("mac");
    public class_437 parent;
    private final Map<String, GroupedHUD> groupedHUDs;
    private final Map<String, BaseHUDSettings> oldHUDSettings;
    private final Map<String, GroupedHUDSettings> oldGroupedHUDSettings;
    private final List<String> oldIndividualHudIds;
    private final List<GroupedHUDSettings> oldGroupedHUDs;
    private boolean dragging = false;
    private final List<AbstractHUD> selectedHUDs = new ArrayList<AbstractHUD>();
    private boolean isMoreOptionActivated = false;
    private boolean canSelectedHUDsGroup = false;
    private boolean canSelectedHUDUngroup = false;
    private boolean supressFieldEvents = false;
    private class_342 xField;
    private class_342 yField;
    private class_342 scaleField;
    private class_4185 shouldRenderButton;
    private class_4185 alignmentXButton;
    private class_4185 alignmentYButton;
    private class_4185 directionXButton;
    private class_4185 directionYButton;
    private class_4185 hudDisplayButton;
    private class_4185 drawBackgroundButton;
    private final List<class_4185> moreOptionButtons = new ArrayList<class_4185>();
    private final List<class_342> moreOptionTexts = new ArrayList<class_342>();
    private class_342 gapField;
    private class_4185 groupAlignmentButton;
    private class_4185 childAlignmentButton;
    private class_4185 childOrderingButton;
    private class_4185 groupUngroupButton;
    private final HUDHistory history = new HUDHistory();
    private final HelpWidget helpWidget = new HelpWidget();
    boolean dragSelection = false;
    int dragStartX;
    int dragStartY;
    int dragCurrentX;
    int dragCurrentY;
    private final Set<AbstractHUD> initialDragBoxSelection = new HashSet<AbstractHUD>();
    private boolean hasMovedSincePress = false;
    private static final int DRAG_THRESHOLD = 3;
    private AbstractHUD clickedHUD = null;
    private boolean sameHUDClicked = false;
    private boolean pendingChildClick;
    public AbstractHUD pendingToggleHUD = null;
    private final Map<AbstractHUD, Vector2d> hudAccumulatedDelta = new HashMap<AbstractHUD, Vector2d>();
    private final Map<AbstractHUD, class_3545<Integer, Integer>> startDragPos = new HashMap<AbstractHUD, class_3545<Integer, Integer>>();

    public EditHUDScreen(class_2561 title, class_437 parent) {
        super(title);
        this.parent = parent;
        this.groupedHUDs = HUDComponent.getInstance().getGroupedHUDs();
        Map<String, AbstractHUD> HUDMap = HUDComponent.getInstance().getHudMap();
        this.oldHUDSettings = new HashMap<String, BaseHUDSettings>();
        for (AbstractHUD abstractHUD : HUDMap.values()) {
            this.oldHUDSettings.put(abstractHUD.getId(), abstractHUD.getSettings().copy());
        }
        this.oldGroupedHUDSettings = new HashMap<String, GroupedHUDSettings>();
        for (GroupedHUD groupedHUD : this.groupedHUDs.values()) {
            this.oldGroupedHUDSettings.put(groupedHUD.getId(), groupedHUD.groupSettings.copy());
        }
        this.oldIndividualHudIds = List.copyOf(Main.settings.hudList.individualHudIds);
        this.oldGroupedHUDs = List.copyOf(Main.settings.hudList.groupedHuds);
    }

    protected void method_25426() {
        int wConfigScreen;
        int CENTER_X = this.field_22789 / 2;
        int CENTER_Y = (this.field_22790 - 20) / 2;
        HUDComponent.getInstance().updateAll();
        int xFieldX = CENTER_X - 40 - 10 - 5;
        this.xField = new class_342(EditHUDScreen.CLIENT.field_1772, xFieldX, CENTER_Y, 40, 20, (class_2561)class_2561.method_43471((String)"starhud.screen.field.x"));
        int yFieldX = CENTER_X + 10 + 5;
        this.yField = new class_342(EditHUDScreen.CLIENT.field_1772, yFieldX, CENTER_Y, 40, 20, (class_2561)class_2561.method_43471((String)"starhud.screen.field.y"));
        int alignmentXButtonX = CENTER_X - 100 - 10 - 5;
        int alignmentXButtonY = CENTER_Y - 25;
        this.alignmentXButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"starhud.screen.button.x_alignment_na"), button -> {
            if (this.selectedHUDs.isEmpty()) {
                return;
            }
            AbstractHUD selectedHUD = this.selectedHUDs.getFirst();
            HUDAction act = this.onAlignmentXChanged(selectedHUD, selectedHUD.getSettings().getOriginX().next());
            this.history.execute(act);
            this.alignmentXButton.method_25355((class_2561)class_2561.method_43469((String)"starhud.screen.button.x_alignment", (Object[])new Object[]{selectedHUD.getSettings().getOriginX().toString()}));
        }).method_46434(alignmentXButtonX, alignmentXButtonY, 100, 20).method_46431();
        int alignmentYButtonX = CENTER_X + 10 + 5;
        this.alignmentYButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"starhud.screen.button.y_alignment_na"), button -> {
            if (this.selectedHUDs.isEmpty()) {
                return;
            }
            AbstractHUD selectedHUD = this.selectedHUDs.getFirst();
            HUDAction act = this.onAlignmentYChanged(selectedHUD, selectedHUD.getSettings().getOriginY().next());
            this.history.execute(act);
            this.alignmentYButton.method_25355((class_2561)class_2561.method_43469((String)"starhud.screen.button.y_alignment", (Object[])new Object[]{selectedHUD.getSettings().getOriginY().toString()}));
        }).method_46434(alignmentYButtonX, alignmentXButtonY, 100, 20).method_46431();
        int directionXButtonY = alignmentXButtonY - 25;
        this.directionXButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"starhud.screen.button.x_direction_na"), button -> {
            if (this.selectedHUDs.isEmpty()) {
                return;
            }
            AbstractHUD selectedHUD = this.selectedHUDs.getFirst();
            HUDAction act = this.onDirectionXChanged(selectedHUD, selectedHUD.getSettings().getGrowthDirectionX().next());
            this.history.execute(act);
            this.directionXButton.method_25355((class_2561)class_2561.method_43469((String)"starhud.screen.button.x_direction", (Object[])new Object[]{selectedHUD.getSettings().getGrowthDirectionX().toString()}));
        }).method_46434(alignmentXButtonX, directionXButtonY, 100, 20).method_46431();
        int scaleFieldWidth = 26;
        int scaleFieldX = CENTER_X - scaleFieldWidth / 2;
        this.scaleField = new class_342(EditHUDScreen.CLIENT.field_1772, scaleFieldX, directionXButtonY, scaleFieldWidth, 20, (class_2561)class_2561.method_43471((String)"starhud.screen.field.scale"));
        this.directionYButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"starhud.screen.button.y_direction_na"), button -> {
            if (this.selectedHUDs.isEmpty()) {
                return;
            }
            AbstractHUD selectedHUD = this.selectedHUDs.getFirst();
            HUDAction act = this.onDirectionYChanged(selectedHUD, selectedHUD.getSettings().getGrowthDirectionY().next());
            this.history.execute(act);
            this.directionYButton.method_25355((class_2561)class_2561.method_43469((String)"starhud.screen.button.y_direction", (Object[])new Object[]{selectedHUD.getSettings().getGrowthDirectionY().toString()}));
        }).method_46434(alignmentYButtonX, directionXButtonY, 100, 20).method_46431();
        int hudDisplayButtonY = directionXButtonY - 25;
        this.hudDisplayButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"starhud.screen.button.display_na"), button -> {
            if (this.selectedHUDs.isEmpty()) {
                return;
            }
            AbstractHUD selectedHUD = this.selectedHUDs.getFirst();
            HUDAction act = this.onHUDDisplayModeChanged(selectedHUD, selectedHUD.getSettings().getDisplayMode().next());
            this.history.execute(act);
            this.hudDisplayButton.method_25355((class_2561)class_2561.method_43469((String)"starhud.screen.button.display", (Object[])new Object[]{selectedHUD.getSettings().getDisplayMode().toString()}));
        }).method_46434(alignmentXButtonX, hudDisplayButtonY, 100, 20).method_46431();
        this.drawBackgroundButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"starhud.screen.button.background_na"), button -> {
            if (this.selectedHUDs.isEmpty()) {
                return;
            }
            AbstractHUD selectedHUD = this.selectedHUDs.getFirst();
            HUDAction act = this.onDrawBackgroundChanged(selectedHUD, !selectedHUD.getSettings().drawBackground);
            this.history.execute(act);
            this.drawBackgroundButton.method_25355((class_2561)class_2561.method_43469((String)"starhud.screen.button.background", (Object[])new Object[]{selectedHUD.getSettings().drawBackground ? class_2561.method_43471((String)"starhud.screen.status.on").getString() : class_2561.method_43471((String)"starhud.screen.status.off").getString()}));
        }).method_46434(alignmentYButtonX, hudDisplayButtonY, 100, 20).method_46431();
        int shouldRenderButtonX = CENTER_X - 10;
        this.shouldRenderButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"starhud.screen.status.na"), button -> {
            AbstractHUD selectedHUD;
            if (this.selectedHUDs.isEmpty()) {
                return;
            }
            HUDAction act = this.onShouldRenderChanged(selectedHUD, !(selectedHUD = this.selectedHUDs.getFirst()).getSettings().shouldRender());
            this.history.execute(act);
            button.method_25355((class_2561)(selectedHUD.getSettings().shouldRender ? class_2561.method_43471((String)"starhud.screen.status.on") : class_2561.method_43471((String)"starhud.screen.status.off")));
        }).method_46434(shouldRenderButtonX, alignmentXButtonY, 20, 20).method_46431();
        int yBottom = this.field_22790 - 20 - 5;
        int hConfigScreen = wConfigScreen = 20;
        int xConfigScreenButton = CENTER_X - wConfigScreen / 2;
        class_4185 configScreenButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"starhud.screen.button.config"), button -> {
            this.helpWidget.setActive(false);
            this.isMoreOptionActivated = false;
            this.selectedHUDs.clear();
            this.field_22787.method_1507((class_437)AutoConfig.getConfigScreen(Settings.class, (class_437)this).get());
        }).method_46436(class_7919.method_47407((class_2561)class_2561.method_43471((String)"starhud.screen.tooltip.config"))).method_46434(xConfigScreenButton, CENTER_Y, wConfigScreen, hConfigScreen).method_46431();
        int xHelpButton = CENTER_X - 2 - 20;
        class_4185 helpButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"starhud.screen.button.help"), button -> this.helpWidget.setActive(!this.helpWidget.isActive())).method_46436(class_7919.method_47407((class_2561)class_2561.method_43471((String)"starhud.screen.tooltip.help"))).method_46434(xHelpButton, yBottom, 20, 20).method_46431();
        int xMoreOptionButton = CENTER_X + 2;
        class_4185 moreOptionButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"starhud.screen.button.more_options"), button -> {
            this.isMoreOptionActivated = !this.isMoreOptionActivated;
            this.onMoreOptionSwitched();
        }).method_46436(class_7919.method_47407((class_2561)class_2561.method_43471((String)"starhud.screen.tooltip.more_options"))).method_46434(xMoreOptionButton, yBottom, 20, 20).method_46431();
        int terminatorWidth = 70;
        int xSaveAndQuitButton = xMoreOptionButton + 5 + 20;
        class_4185 saveAndQuitButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"starhud.screen.button.save_quit"), button -> {
            AutoConfig.getConfigHolder(Settings.class).save();
            this.onClose();
        }).method_46434(xSaveAndQuitButton, yBottom, terminatorWidth, 20).method_46431();
        int xCancelButton = xHelpButton - 5 - terminatorWidth;
        class_4185 cancelButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"starhud.screen.button.cancel"), button -> this.method_25419()).method_46434(xCancelButton, yBottom, terminatorWidth, 20).method_46431();
        int yBottomGroup = CENTER_Y + 25;
        int xGroupUngroupButton = CENTER_X - terminatorWidth / 2;
        this.groupUngroupButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"starhud.screen.status.na"), button -> {
            if (this.canSelectedHUDsGroup) {
                HUDAction act = this.onGroupChanged(this.selectedHUDs);
                this.history.commit(act);
            } else if (this.canSelectedHUDUngroup) {
                HUDAction act = this.onUngroupChanged((GroupedHUD)this.selectedHUDs.getFirst());
                this.history.commit(act);
            }
            this.selectedHUDs.clear();
            this.updateFieldsFromSelectedHUD();
            this.updateGroupFieldFromSelectedHUD();
        }).method_46434(xGroupUngroupButton, yBottomGroup, terminatorWidth, 20).method_46431();
        int gapFieldWidth = terminatorWidth / 2;
        int xGapField = CENTER_X - gapFieldWidth / 2 + terminatorWidth + 5;
        int yGapField = yBottomGroup + 25;
        this.gapField = new class_342(EditHUDScreen.CLIENT.field_1772, xGapField, yGapField, gapFieldWidth, 20, (class_2561)class_2561.method_43471((String)"starhud.screen.field.gap"));
        this.gapField.method_1863(text -> {
            if (this.supressFieldEvents) {
                return;
            }
            if (this.selectedHUDs.isEmpty()) {
                return;
            }
            AbstractHUD patt0$temp = this.selectedHUDs.getFirst();
            if (!(patt0$temp instanceof GroupedHUD)) {
                return;
            }
            GroupedHUD hud = (GroupedHUD)patt0$temp;
            try {
                int newGap = Integer.parseInt(text);
                HUDAction act = this.onGapFieldChanged(hud, hud.groupSettings.gap, newGap);
                this.history.execute(act);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        });
        this.xField.method_1863(text -> {
            if (this.supressFieldEvents) {
                return;
            }
            if (this.selectedHUDs.isEmpty()) {
                return;
            }
            AbstractHUD hud = this.selectedHUDs.getFirst();
            try {
                int newX = Integer.parseInt(text);
                HUDAction act = this.onXFieldChanged(hud, hud.getSettings().getX(), newX);
                this.history.execute(act);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        });
        this.yField.method_1863(text -> {
            if (this.supressFieldEvents) {
                return;
            }
            if (this.selectedHUDs.isEmpty()) {
                return;
            }
            AbstractHUD hud = this.selectedHUDs.getFirst();
            try {
                int newY = Integer.parseInt(text);
                HUDAction act = this.onYFieldChanged(hud, hud.getSettings().getY(), newY);
                this.history.execute(act);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        });
        this.scaleField.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"starhud.screen.tooltip.scale")));
        this.scaleField.method_1863(text -> {
            if (this.supressFieldEvents) {
                return;
            }
            if (this.selectedHUDs.isEmpty()) {
                return;
            }
            AbstractHUD hud = this.selectedHUDs.getFirst();
            try {
                float newScale = Float.parseFloat(text);
                HUDAction act = this.onScaleFieldChanged(hud, hud.getSettings().getScale(), newScale);
                this.history.execute(act);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        });
        int xChildAlignmentButton = xGroupUngroupButton - 5 - terminatorWidth;
        this.childAlignmentButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"starhud.screen.status.na"), button -> {
            if (this.selectedHUDs.isEmpty()) {
                return;
            }
            AbstractHUD patt0$temp = this.selectedHUDs.getFirst();
            if (!(patt0$temp instanceof GroupedHUD)) {
                return;
            }
            GroupedHUD hud = (GroupedHUD)patt0$temp;
            HUDAction act = this.onChildAlignmentChanged(hud, hud.groupSettings.getChildAlignment().next());
            this.history.execute(act);
            button.method_25355(class_2561.method_30163((String)hud.groupSettings.getChildAlignment().toString()));
        }).method_46434(xChildAlignmentButton, yBottomGroup, terminatorWidth, 20).method_46436(class_7919.method_47407((class_2561)class_2561.method_43471((String)"starhud.screen.tooltip.child_alignment"))).method_46431();
        int xChildOrderingButton = xChildAlignmentButton;
        int yChildOrderingButton = yBottomGroup + 5 + 20;
        this.childOrderingButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"starhud.screen.status.na"), button -> {
            if (this.selectedHUDs.isEmpty()) {
                return;
            }
            AbstractHUD patt0$temp = this.selectedHUDs.getFirst();
            if (!(patt0$temp instanceof GroupedHUD)) {
                return;
            }
            GroupedHUD hud = (GroupedHUD)patt0$temp;
            HUDAction act = this.onChildOrderingChanged(hud, hud.groupSettings.getChildOrdering().next());
            this.history.execute(act);
            button.method_25355(class_2561.method_30163((String)hud.groupSettings.getChildOrdering().toString()));
        }).method_46434(xChildOrderingButton, yChildOrderingButton, terminatorWidth, 20).method_46436(class_7919.method_47407((class_2561)class_2561.method_43471((String)"starhud.screen.tooltip.child_ordering"))).method_46431();
        int xGroupAlignmentButton = xGroupUngroupButton + terminatorWidth + 5;
        this.groupAlignmentButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"starhud.screen.status.na"), button -> {
            if (this.selectedHUDs.isEmpty()) {
                return;
            }
            AbstractHUD patt0$temp = this.selectedHUDs.getFirst();
            if (!(patt0$temp instanceof GroupedHUD)) {
                return;
            }
            GroupedHUD hud = (GroupedHUD)patt0$temp;
            HUDAction act = this.onGroupAlignmentChanged(hud, !hud.groupSettings.alignVertical);
            this.history.execute(act);
            this.groupAlignmentButton.method_25355((class_2561)class_2561.method_43471((String)(hud.groupSettings.alignVertical ? "starhud.screen.button.group_alignment.vertical" : "starhud.screen.button.group_alignment.horizontal")));
        }).method_46436(class_7919.method_47407((class_2561)class_2561.method_43471((String)"starhud.screen.tooltip.group_alignment"))).method_46434(xGroupAlignmentButton, yBottomGroup, terminatorWidth, 20).method_46431();
        this.moreOptionButtons.clear();
        this.moreOptionButtons.add(this.alignmentXButton);
        this.moreOptionButtons.add(this.alignmentYButton);
        this.moreOptionButtons.add(this.directionXButton);
        this.moreOptionButtons.add(this.directionYButton);
        this.moreOptionButtons.add(this.hudDisplayButton);
        this.moreOptionButtons.add(this.drawBackgroundButton);
        this.moreOptionButtons.add(this.shouldRenderButton);
        this.moreOptionTexts.clear();
        this.moreOptionTexts.add(this.xField);
        this.moreOptionTexts.add(this.yField);
        this.moreOptionTexts.add(this.scaleField);
        for (class_4185 bw : this.moreOptionButtons) {
            this.method_37063((class_364)bw);
        }
        for (class_342 tfw : this.moreOptionTexts) {
            this.method_37063((class_364)tfw);
        }
        this.method_37063((class_364)cancelButton);
        this.method_37063((class_364)helpButton);
        this.method_37063((class_364)moreOptionButton);
        this.method_37063((class_364)saveAndQuitButton);
        this.method_37063((class_364)configScreenButton);
        this.method_37063((class_364)this.groupUngroupButton);
        this.method_37063((class_364)this.gapField);
        this.method_37063((class_364)this.childAlignmentButton);
        this.method_37063((class_364)this.childOrderingButton);
        this.method_37063((class_364)this.groupAlignmentButton);
        this.hideMoreOptionsButtons();
        this.updateFieldsFromSelectedHUD();
        this.updateGroupFieldFromSelectedHUD();
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        int CENTER_Y;
        int CENTER_X;
        if (EditHUDScreen.SETTINGS.drawGrid) {
            CENTER_X = this.field_22789 / 2;
            CENTER_Y = this.field_22790 / 2;
            int gridEdgePadding = Math.max(EditHUDScreen.SETTINGS.gridEdgePadding, 0);
            if (gridEdgePadding > 0) {
                RenderUtils.drawBorder(context, gridEdgePadding, gridEdgePadding, this.field_22789 - gridEdgePadding * 2, this.field_22790 - gridEdgePadding * 2, EditHUDScreen.SETTINGS.gridColor);
            }
            context.method_25292(gridEdgePadding + 1, this.field_22789 - (gridEdgePadding + 2), CENTER_Y, EditHUDScreen.SETTINGS.gridColor);
            context.method_25301(CENTER_X, gridEdgePadding, this.field_22790 - (gridEdgePadding + 1), EditHUDScreen.SETTINGS.gridColor);
        }
        super.method_25394(context, mouseX, mouseY, delta);
        if (this.helpWidget.isActive()) {
            CENTER_X = this.field_22789 / 2;
            CENTER_Y = this.field_22790 / 2 + 12;
            AbstractHUD hud = this.selectedHUDs.isEmpty() ? null : this.selectedHUDs.getFirst();
            this.helpWidget.render(context, hud, CENTER_X, CENTER_Y + 5);
        }
        if (this.xField.method_1885() && this.yField.method_1885()) {
            context.method_51439(EditHUDScreen.CLIENT.field_1772, (class_2561)class_2561.method_43471((String)"starhud.screen.label.x"), this.xField.method_46426() - 5 - 2 - 3, this.xField.method_46427() + 6, -1, true);
            context.method_51439(EditHUDScreen.CLIENT.field_1772, (class_2561)class_2561.method_43471((String)"starhud.screen.label.y"), this.yField.method_46426() + this.yField.method_25368() + 3, this.yField.method_46427() + 6, -1, true);
        }
        if (this.gapField.method_1885()) {
            context.method_51439(EditHUDScreen.CLIENT.field_1772, (class_2561)class_2561.method_43471((String)"starhud.screen.label.gap"), this.gapField.method_46426() - 20 - 3, this.gapField.method_46427() + 6, -1, true);
        }
        if (this.dragSelection && this.hasMovedSincePress) {
            this.renderDragBox(context);
        }
        HUDComponent.getInstance().collectAll();
        HUDComponent.getInstance().renderAll(context);
        this.renderBoundingBoxes(context, mouseX, mouseY);
    }

    private void renderDragBox(class_332 context) {
        int x1 = Math.min(this.dragStartX, this.dragCurrentX);
        int y1 = Math.min(this.dragStartY, this.dragCurrentY);
        int x2 = Math.max(this.dragStartX, this.dragCurrentX);
        int y2 = Math.max(this.dragStartY, this.dragCurrentY);
        int width = x2 - x1;
        int height = y2 - y1;
        int color = EditHUDScreen.SETTINGS.dragBoxColor;
        if (width > 0 && height > 0) {
            context.method_25294(x1, y1, x2, y2, color | 0x40000000);
            if (EditHUDScreen.SETTINGS.drawBorder) {
                RenderUtils.drawBorder(context, x1, y1, width, height, color | 0xFF000000);
            }
        }
    }

    private void renderBoundingBoxes(class_332 context, int mouseX, int mouseY) {
        for (AbstractHUD hud : HUDComponent.getInstance().getRenderedHUDs()) {
            if (hud.isScaled()) {
                context.method_51448().method_22903();
                hud.scaleHUD(context);
                this.renderBoundingBox(context, hud, mouseX, mouseY);
                context.method_51448().method_22909();
                continue;
            }
            this.renderBoundingBox(context, hud, mouseX, mouseY);
        }
        for (AbstractHUD hud : this.selectedHUDs) {
            if (!hud.getSettings().shouldRender) continue;
            if (hud.isScaled()) {
                context.method_51448().method_22903();
                hud.scaleHUD(context);
                this.renderSelectedBox(context, hud);
                context.method_51448().method_22909();
                continue;
            }
            this.renderSelectedBox(context, hud);
        }
    }

    private void renderSelectedBox(class_332 context, AbstractHUD hud) {
        int color;
        Box box = hud.getBoundingBox();
        int x = box.getX();
        int y = box.getY();
        int width = box.getWidth();
        int height = box.getHeight();
        int n = color = hud instanceof GroupedHUD ? EditHUDScreen.SETTINGS.selectedGroupBoxColor : EditHUDScreen.SETTINGS.selectedBoxColor;
        if (hud.isInGroup()) {
            RenderUtils.drawBorder(context, x, y, width, height, color | 0xFF000000);
        } else {
            context.method_25294(x, y, x + width, y + height, color);
        }
    }

    private void renderBoundingBox(class_332 context, AbstractHUD hud, int mouseX, int mouseY) {
        Box boundingBox = hud.getBoundingBox();
        int x = boundingBox.getX();
        int y = boundingBox.getY();
        int width = boundingBox.getWidth();
        int height = boundingBox.getHeight();
        int color = boundingBox.getColor();
        if (EditHUDScreen.SETTINGS.drawBorder) {
            RenderUtils.drawBorder(context, x, y, width, height, color);
        }
        if (hud.isHovered(mouseX, mouseY)) {
            context.method_25294(x, y, x + width, y + height, color & 0xFFFFFF | Integer.MIN_VALUE);
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (super.method_25402(mouseX, mouseY, button)) {
            return true;
        }
        if (button == 0) {
            this.hasMovedSincePress = false;
            this.dragStartX = (int)mouseX;
            this.dragStartY = (int)mouseY;
            this.dragCurrentX = (int)mouseX;
            this.dragCurrentY = (int)mouseY;
            this.clickedHUD = this.getHUDAtPosition(mouseX, mouseY);
            if (this.clickedHUD != null) {
                this.handleHUDClick(this.clickedHUD);
            } else {
                this.handleEmptySpaceClick();
            }
            this.initialDragBoxSelection.clear();
            this.initialDragBoxSelection.addAll(this.selectedHUDs);
        }
        return true;
    }

    private AbstractHUD getHUDAtPosition(double mouseX, double mouseY) {
        AbstractHUD hud;
        if (!this.selectedHUDs.isEmpty() && (hud = this.selectedHUDs.getFirst()).isHovered((int)mouseX, (int)mouseY)) {
            this.sameHUDClicked = true;
            return hud;
        }
        this.sameHUDClicked = false;
        for (AbstractHUD hud2 : this.selectedHUDs) {
            if (!hud2.isHovered((int)mouseX, (int)mouseY)) continue;
            return hud2;
        }
        for (AbstractHUD hud2 : HUDComponent.getInstance().getRenderedHUDs()) {
            if (!hud2.isHovered((int)mouseX, (int)mouseY)) continue;
            return hud2;
        }
        return null;
    }

    private void handleHUDClick(AbstractHUD clickedHUD) {
        if (class_437.method_25442()) {
            if (!this.selectedHUDs.contains(clickedHUD)) {
                this.selectedHUDs.add(clickedHUD);
            }
            this.pendingToggleHUD = this.selectedHUDs.contains(clickedHUD) ? clickedHUD : null;
        } else if (class_437.method_25441()) {
            if (this.selectedHUDs.contains(clickedHUD)) {
                this.pendingToggleHUD = clickedHUD;
            } else {
                this.selectedHUDs.add(clickedHUD);
                this.pendingToggleHUD = null;
            }
        } else if (this.selectedHUDs.contains(clickedHUD)) {
            this.pendingToggleHUD = null;
            if (clickedHUD instanceof GroupedHUD) {
                this.pendingChildClick = true;
            }
        } else {
            this.selectedHUDs.clear();
            this.selectedHUDs.add(clickedHUD);
            this.pendingToggleHUD = null;
        }
        this.dragging = true;
        if (!this.pendingChildClick && !this.sameHUDClicked) {
            this.updateFieldsFromSelectedHUD();
            this.updateGroupFieldFromSelectedHUD();
        }
    }

    private void handleEmptySpaceClick() {
        if (!class_437.method_25442() && !class_437.method_25441()) {
            this.selectedHUDs.clear();
            this.updateFieldsFromSelectedHUD();
            this.updateGroupFieldFromSelectedHUD();
        }
        this.dragSelection = true;
        this.pendingToggleHUD = null;
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (button == 0) {
            if (!this.hasMovedSincePress) {
                this.dragging = false;
                this.handleClickRelease(mouseX, mouseY);
            }
            if (this.hasMovedSincePress && this.dragging) {
                this.finalizeDragOperation();
            }
            this.dragging = false;
            this.dragSelection = false;
            this.resetMouseState();
            return true;
        }
        return super.method_25406(mouseX, mouseY, button);
    }

    private void handleClickRelease(double mouseX, double mouseY) {
        if (this.pendingToggleHUD != null) {
            if (class_437.method_25442()) {
                this.selectedHUDs.remove(this.pendingToggleHUD);
            } else if (class_437.method_25441()) {
                this.selectedHUDs.remove(this.pendingToggleHUD);
            }
            this.updateFieldsFromSelectedHUD();
            this.updateGroupFieldFromSelectedHUD();
        }
        if (this.clickedHUD != null && !class_437.method_25442() && !class_437.method_25441()) {
            AbstractHUD abstractHUD;
            if (this.pendingChildClick && (abstractHUD = this.clickedHUD) instanceof GroupedHUD) {
                GroupedHUD group = (GroupedHUD)abstractHUD;
                AbstractHUD hoveredChild = null;
                for (AbstractHUD hud : group.huds) {
                    if (!hud.isHovered((int)mouseX, (int)mouseY)) continue;
                    hoveredChild = hud;
                    break;
                }
                if (hoveredChild != null) {
                    this.selectedHUDs.clear();
                    this.selectedHUDs.add(hoveredChild);
                    this.updateFieldsFromSelectedHUD();
                    this.updateGroupFieldFromSelectedHUD();
                }
            } else if (this.selectedHUDs.contains(this.clickedHUD) && this.selectedHUDs.size() > 1) {
                this.selectedHUDs.clear();
                this.selectedHUDs.add(this.clickedHUD);
                this.updateFieldsFromSelectedHUD();
                this.updateGroupFieldFromSelectedHUD();
            }
        }
    }

    private void finalizeDragOperation() {
        this.dragging = false;
        if (!this.selectedHUDs.isEmpty()) {
            AbstractHUD selectedHUD = this.selectedHUDs.getFirst();
            this.supressFieldEvents = true;
            this.xField.method_1852(String.valueOf(selectedHUD.getSettings().x));
            this.yField.method_1852(String.valueOf(selectedHUD.getSettings().y));
            this.supressFieldEvents = false;
            ArrayList<HUDAction> acts = new ArrayList<HUDAction>();
            for (AbstractHUD hud : this.selectedHUDs) {
                class_3545<Integer, Integer> p = this.startDragPos.get(hud);
                HUDAction actX = this.onXFieldChanged(hud, (Integer)p.method_15442(), selectedHUD.getSettings().x);
                HUDAction actY = this.onYFieldChanged(hud, (Integer)p.method_15441(), selectedHUD.getSettings().y);
                acts.add(actX);
                acts.add(actY);
            }
            this.history.commit(new CompositeAction(acts));
        }
        this.hudAccumulatedDelta.clear();
    }

    private void resetMouseState() {
        this.hasMovedSincePress = false;
        this.clickedHUD = null;
        this.pendingToggleHUD = null;
        this.initialDragBoxSelection.clear();
        this.pendingChildClick = false;
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        int totalMovement;
        if (button != 0) {
            return super.method_25403(mouseX, mouseY, button, deltaX, deltaY);
        }
        if (!this.hasMovedSincePress && (totalMovement = Math.abs((int)mouseX - this.dragStartX) + Math.abs((int)mouseY - this.dragStartY)) >= 3) {
            this.hasMovedSincePress = true;
            this.startDragOperation();
        }
        if (this.hasMovedSincePress) {
            if (this.dragging && !this.selectedHUDs.isEmpty()) {
                this.dragSelectedHUDs(deltaX, deltaY);
                return true;
            }
            if (this.dragSelection) {
                this.updateDragBoxSelection(mouseX, mouseY);
                return true;
            }
        }
        return super.method_25403(mouseX, mouseY, button, deltaX, deltaY);
    }

    private void startDragOperation() {
        this.pendingToggleHUD = null;
        if (this.clickedHUD != null && this.selectedHUDs.contains(this.clickedHUD)) {
            for (AbstractHUD hud : this.selectedHUDs) {
                this.startDragPos.put(hud, (class_3545<Integer, Integer>)new class_3545((Object)hud.getSettings().getX(), (Object)hud.getSettings().getY()));
            }
            this.dragSelection = false;
        } else {
            this.dragging = false;
            if (this.clickedHUD != null && !class_437.method_25442() && !class_437.method_25441()) {
                this.selectedHUDs.clear();
                this.initialDragBoxSelection.clear();
            }
        }
    }

    private void dragSelectedHUDs(double deltaX, double deltaY) {
        for (AbstractHUD hud : this.selectedHUDs) {
            if (hud.isInGroup()) continue;
            double scaleFactor = hud.getSettings().getScaledFactor();
            Vector2d acc = this.hudAccumulatedDelta.computeIfAbsent(hud, h -> new Vector2d(0.0, 0.0));
            acc.x += deltaX;
            acc.y += deltaY;
            double scaledX = acc.x * scaleFactor;
            double scaledY = acc.y * scaleFactor;
            int dx = (int)scaledX;
            int dy = (int)scaledY;
            if (dx == 0 && dy == 0) continue;
            hud.getSettings().x += dx;
            hud.getSettings().y += dy;
            hud.update();
            acc.x -= (double)dx / scaleFactor;
            acc.y -= (double)dy / scaleFactor;
        }
        if (!this.selectedHUDs.isEmpty()) {
            AbstractHUD firstSelected = this.selectedHUDs.getFirst();
            this.supressFieldEvents = true;
            this.xField.method_1852(String.valueOf(firstSelected.getSettings().x));
            this.yField.method_1852(String.valueOf(firstSelected.getSettings().y));
            this.supressFieldEvents = false;
        }
    }

    private void updateDragBoxSelection(double mouseX, double mouseY) {
        this.dragCurrentX = (int)mouseX;
        this.dragCurrentY = (int)mouseY;
        int x1 = Math.min(this.dragStartX, this.dragCurrentX);
        int y1 = Math.min(this.dragStartY, this.dragCurrentY);
        int x2 = Math.max(this.dragStartX, this.dragCurrentX);
        int y2 = Math.max(this.dragStartY, this.dragCurrentY);
        HashSet<AbstractHUD> boxSelectedHUDs = new HashSet<AbstractHUD>();
        for (AbstractHUD hud2 : HUDComponent.getInstance().getRenderedHUDs()) {
            if (!hud2.intersects(x1, y1, x2, y2)) continue;
            boxSelectedHUDs.add(hud2);
        }
        boolean changed = false;
        AbstractHUD oldFirst = null;
        int oldSize = 0;
        if (!this.selectedHUDs.isEmpty()) {
            oldFirst = this.selectedHUDs.getFirst();
            oldSize = this.selectedHUDs.size();
        }
        if (class_437.method_25442()) {
            for (AbstractHUD hud3 : boxSelectedHUDs) {
                if (this.selectedHUDs.contains(hud3)) continue;
                this.selectedHUDs.add(hud3);
                changed = true;
            }
        } else if (class_437.method_25441()) {
            for (AbstractHUD hud4 : boxSelectedHUDs) {
                if (this.initialDragBoxSelection.contains(hud4)) {
                    this.selectedHUDs.remove(hud4);
                    changed = true;
                    continue;
                }
                if (this.selectedHUDs.contains(hud4)) continue;
                this.selectedHUDs.add(hud4);
                changed = true;
            }
        } else {
            changed = this.selectedHUDs.removeIf(hud -> !boxSelectedHUDs.contains(hud));
            for (AbstractHUD hud5 : boxSelectedHUDs) {
                if (this.selectedHUDs.contains(hud5)) continue;
                this.selectedHUDs.add(hud5);
                changed = true;
            }
        }
        if (changed) {
            int newSize = this.selectedHUDs.size();
            if (oldSize != newSize) {
                this.updateGroupFieldFromSelectedHUD();
            }
            if (this.selectedHUDs.isEmpty() || oldFirst != this.selectedHUDs.getFirst()) {
                this.updateFieldsFromSelectedHUD();
            }
        }
    }

    public boolean isTextFieldsFocused() {
        return this.xField.method_25370() || this.yField.method_25370() || this.gapField.method_25370() || this.scaleField.method_25370();
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (this.isTextFieldsFocused()) {
            return super.method_25404(keyCode, scanCode, modifiers);
        }
        if (!this.dragSelection && !this.dragging) {
            boolean isCtrl = isMac ? (modifiers & 8) != 0 : (modifiers & 2) != 0;
            boolean isShift = (modifiers & 1) != 0;
            boolean handled = false;
            ArrayList<HUDAction> acts = new ArrayList<HUDAction>();
            if (!this.selectedHUDs.isEmpty()) {
                AbstractHUD hud;
                HUDAction act;
                Iterator<AbstractHUD> iterator = this.selectedHUDs.iterator();
                while (iterator.hasNext() && (act = this.onKeyPressed(hud = iterator.next(), keyCode, modifiers)) != null) {
                    acts.add(act);
                }
            }
            if (!acts.isEmpty()) {
                this.history.execute(acts.size() == 1 ? (HUDAction)acts.getFirst() : new CompositeAction(acts));
                this.updateFieldsFromSelectedHUD();
                return true;
            }
            switch (keyCode) {
                case 71: {
                    HUDAction act;
                    if (this.selectedHUDs.isEmpty()) break;
                    if (this.selectedHUDs.size() > 1) {
                        if (!this.canSelectedHUDsGroup) break;
                        act = this.onGroupChanged(this.selectedHUDs);
                        this.history.commit(act);
                        this.selectedHUDs.clear();
                        handled = true;
                        break;
                    }
                    if (!this.canSelectedHUDUngroup) break;
                    act = this.onUngroupChanged((GroupedHUD)this.selectedHUDs.getFirst());
                    this.history.commit(act);
                    this.selectedHUDs.clear();
                    handled = true;
                    break;
                }
                case 67: {
                    if (!isShift) break;
                    HUDComponent.getInstance().clampAll();
                    break;
                }
                case 90: {
                    if (!isCtrl || !this.history.canUndo()) break;
                    this.history.undo();
                    handled = true;
                    break;
                }
                case 89: {
                    if (!isCtrl || !this.history.canRedo()) break;
                    this.history.redo();
                    handled = true;
                }
            }
            if (handled) {
                this.updateFieldsFromSelectedHUD();
                this.updateGroupFieldFromSelectedHUD();
                return true;
            }
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public HUDAction onKeyPressed(AbstractHUD hud, int keyCode, int modifiers) {
        BaseHUDSettings settings = hud.getSettings();
        HUDAction act = null;
        boolean isCtrl = isMac ? (modifiers & 8) != 0 : (modifiers & 2) != 0;
        boolean isShift = (modifiers & 1) != 0;
        boolean isAlt = (modifiers & 4) != 0;
        int step = isShift ? 5 : 1;
        switch (keyCode) {
            case 263: {
                if (isCtrl) {
                    act = this.onAlignmentXChanged(hud, settings.getOriginX().prev());
                    break;
                }
                if (isAlt) {
                    act = this.onDirectionXChanged(hud, settings.getGrowthDirectionX().prev());
                    break;
                }
                act = this.onXFieldChanged(hud, settings.x, settings.x - step);
                break;
            }
            case 262: {
                if (isCtrl) {
                    act = this.onAlignmentXChanged(hud, settings.getOriginX().next());
                    break;
                }
                if (isAlt) {
                    act = this.onDirectionXChanged(hud, settings.getGrowthDirectionX().next());
                    break;
                }
                act = this.onXFieldChanged(hud, settings.x, settings.x + step);
                break;
            }
            case 265: {
                if (isCtrl) {
                    act = this.onAlignmentYChanged(hud, settings.getOriginY().prev());
                    break;
                }
                if (isAlt) {
                    act = this.onDirectionYChanged(hud, settings.getGrowthDirectionY().prev());
                    break;
                }
                act = this.onYFieldChanged(hud, settings.y, settings.y - step);
                break;
            }
            case 264: {
                if (isCtrl) {
                    act = this.onAlignmentYChanged(hud, settings.getOriginY().next());
                    break;
                }
                if (isAlt) {
                    act = this.onDirectionYChanged(hud, settings.getGrowthDirectionY().next());
                    break;
                }
                act = this.onYFieldChanged(hud, settings.y, settings.y + step);
                break;
            }
            case 45: {
                if (isShift || settings.scale <= 0.0f) break;
                act = this.onScaleFieldChanged(hud, settings.scale, settings.scale - 1.0f);
                break;
            }
            case 61: {
                if (!isShift) break;
                act = this.onScaleFieldChanged(hud, settings.scale, settings.scale + 1.0f);
            }
        }
        return act;
    }

    private boolean isDirty() {
        List<String> individualIds = Main.settings.hudList.individualHudIds;
        List<GroupedHUDSettings> groupedHUDs = Main.settings.hudList.groupedHuds;
        if (!individualIds.equals(this.oldIndividualHudIds)) {
            return true;
        }
        if (!groupedHUDs.equals(this.oldGroupedHUDs)) {
            return true;
        }
        for (HUDId id : HUDId.values()) {
            AbstractHUD hud = HUDComponent.getInstance().getHUD(id);
            BaseHUDSettings current = hud.getSettings();
            BaseHUDSettings original = this.oldHUDSettings.get(id.toString());
            if (original != null && current.isEqual(original)) continue;
            return true;
        }
        for (GroupedHUDSettings current : groupedHUDs) {
            GroupedHUDSettings original;
            if (current.isEqual(original = this.oldGroupedHUDSettings.get(current.id))) continue;
            return true;
        }
        return false;
    }

    private void revertChanges() {
        Main.settings.hudList.individualHudIds.clear();
        Main.settings.hudList.individualHudIds.addAll(this.oldIndividualHudIds);
        Main.settings.hudList.groupedHuds.clear();
        Main.settings.hudList.groupedHuds.addAll(this.oldGroupedHUDs);
        HUDComponent.getInstance().updateActiveHUDs();
        for (HUDId id : HUDId.values()) {
            AbstractHUD hud = HUDComponent.getInstance().getHUD(id);
            BaseHUDSettings original = this.oldHUDSettings.get(id.toString());
            if (original != null) {
                hud.getSettings().copyFrom(original);
                continue;
            }
            LOGGER.warn("Original Settings is not found! for {}", (Object)hud.getName());
        }
        for (GroupedHUD hud : this.groupedHUDs.values()) {
            GroupedHUDSettings original = this.oldGroupedHUDSettings.get(hud.groupSettings.id);
            if (original != null) {
                hud.groupSettings.copyFrom(original);
                continue;
            }
            LOGGER.warn("Original Settings is not found for Group ({})!", (Object)hud.getName());
        }
        AutoConfig.getConfigHolder(Settings.class).save();
    }

    public void method_25419() {
        if (this.isDirty()) {
            if (this.field_22787 == null) {
                return;
            }
            this.field_22787.method_1507((class_437)new class_410(result -> {
                if (result) {
                    this.revertChanges();
                    this.onClose();
                } else {
                    this.field_22787.method_1507((class_437)this);
                }
            }, (class_2561)class_2561.method_43471((String)"starhud.screen.dialog.discard_title"), (class_2561)class_2561.method_43471((String)"starhud.screen.dialog.discard_message")));
        } else {
            this.onClose();
        }
    }

    public void onClose() {
        if (this.field_22787 == null) {
            return;
        }
        this.field_22787.method_1507(this.parent);
    }

    private void updateGroupFieldFromSelectedHUD() {
        super.method_25395(null);
        if (this.selectedHUDs.isEmpty()) {
            this.canSelectedHUDUngroup = false;
            this.canSelectedHUDsGroup = false;
            this.groupUngroupButton.field_22763 = false;
            this.groupUngroupButton.field_22764 = false;
        } else {
            AbstractHUD firstHUD = this.selectedHUDs.getFirst();
            this.canSelectedHUDUngroup = this.selectedHUDs.size() == 1 && firstHUD instanceof GroupedHUD && !firstHUD.isInGroup();
            boolean bl = this.canSelectedHUDsGroup = this.selectedHUDs.size() > 1 && this.selectedHUDs.stream().noneMatch(AbstractHUD::isInGroup);
            if (this.canSelectedHUDsGroup) {
                this.groupUngroupButton.method_25355((class_2561)class_2561.method_43471((String)"starhud.screen.button.group"));
                this.groupUngroupButton.field_22764 = true;
                this.groupUngroupButton.field_22763 = true;
            } else if (this.canSelectedHUDUngroup) {
                this.groupUngroupButton.method_25355((class_2561)class_2561.method_43471((String)"starhud.screen.button.ungroup"));
                this.groupUngroupButton.field_22764 = true;
                this.groupUngroupButton.field_22763 = true;
            } else {
                this.groupUngroupButton.field_22764 = false;
                this.groupUngroupButton.field_22763 = false;
            }
        }
    }

    private void updateFieldsFromSelectedHUD() {
        super.method_25395(null);
        this.supressFieldEvents = true;
        if (this.selectedHUDs.isEmpty()) {
            this.xField.method_1852(class_2561.method_43471((String)"starhud.screen.status.na").getString());
            this.yField.method_1852(class_2561.method_43471((String)"starhud.screen.status.na").getString());
            this.scaleField.method_1852(class_2561.method_43471((String)"starhud.screen.status.na").getString());
            this.alignmentXButton.method_25355((class_2561)class_2561.method_43471((String)"starhud.screen.button.x_alignment_na"));
            this.directionXButton.method_25355((class_2561)class_2561.method_43471((String)"starhud.screen.button.x_direction_na"));
            this.alignmentYButton.method_25355((class_2561)class_2561.method_43471((String)"starhud.screen.button.y_alignment_na"));
            this.directionYButton.method_25355((class_2561)class_2561.method_43471((String)"starhud.screen.button.y_direction_na"));
            this.hudDisplayButton.method_25355((class_2561)class_2561.method_43471((String)"starhud.screen.button.display_na"));
            this.drawBackgroundButton.method_25355((class_2561)class_2561.method_43471((String)"starhud.screen.button.background_na"));
            this.shouldRenderButton.method_25355((class_2561)class_2561.method_43471((String)"starhud.screen.status.na"));
            this.gapField.method_1852(class_2561.method_43471((String)"starhud.screen.status.na").getString());
            this.groupAlignmentButton.method_25355((class_2561)class_2561.method_43471((String)"starhud.screen.status.na"));
            this.childAlignmentButton.method_25355((class_2561)class_2561.method_43471((String)"starhud.screen.status.na"));
            this.childOrderingButton.method_25355((class_2561)class_2561.method_43471((String)"starhud.screen.status.na"));
            this.gapField.method_1888(false);
            this.gapField.field_22764 = false;
            this.groupAlignmentButton.field_22764 = false;
            this.groupAlignmentButton.field_22763 = false;
            this.childAlignmentButton.field_22764 = false;
            this.childAlignmentButton.field_22763 = false;
            this.childOrderingButton.field_22764 = false;
            this.childOrderingButton.field_22763 = false;
            for (class_4185 bw : this.moreOptionButtons) {
                bw.field_22763 = false;
            }
            for (class_342 tfw : this.moreOptionTexts) {
                tfw.method_1888(false);
            }
        } else {
            AbstractHUD firstHUD = this.selectedHUDs.getFirst();
            BaseHUDSettings settings = firstHUD.getSettings();
            this.xField.method_1852(String.valueOf(settings.x));
            this.yField.method_1852(String.valueOf(settings.y));
            this.scaleField.method_1852(String.valueOf(settings.getScale()));
            this.alignmentXButton.method_25355((class_2561)class_2561.method_43469((String)"starhud.screen.button.x_alignment", (Object[])new Object[]{settings.getOriginX().toString()}));
            this.directionXButton.method_25355((class_2561)class_2561.method_43469((String)"starhud.screen.button.x_direction", (Object[])new Object[]{settings.getGrowthDirectionX().toString()}));
            this.alignmentYButton.method_25355((class_2561)class_2561.method_43469((String)"starhud.screen.button.y_alignment", (Object[])new Object[]{settings.getOriginY().toString()}));
            this.directionYButton.method_25355((class_2561)class_2561.method_43469((String)"starhud.screen.button.y_direction", (Object[])new Object[]{settings.getGrowthDirectionY().toString()}));
            this.hudDisplayButton.method_25355((class_2561)class_2561.method_43469((String)"starhud.screen.button.display", (Object[])new Object[]{settings.getDisplayMode().toString()}));
            this.drawBackgroundButton.method_25355((class_2561)class_2561.method_43469((String)"starhud.screen.button.background", (Object[])new Object[]{settings.drawBackground ? class_2561.method_43471((String)"starhud.screen.status.on").getString() : class_2561.method_43471((String)"starhud.screen.status.off").getString()}));
            this.shouldRenderButton.method_25355((class_2561)(settings.shouldRender ? class_2561.method_43471((String)"starhud.screen.status.on") : class_2561.method_43471((String)"starhud.screen.status.off")));
            for (class_4185 bw : this.moreOptionButtons) {
                bw.field_22763 = true;
            }
            for (class_342 tfw : this.moreOptionTexts) {
                tfw.method_1888(true);
            }
            this.gapField.field_22764 = false;
            this.groupAlignmentButton.field_22764 = false;
            this.childAlignmentButton.field_22764 = false;
            this.childOrderingButton.field_22764 = false;
            if (this.isMoreOptionActivated) {
                this.showMoreOptionsButtons();
            }
        }
        this.supressFieldEvents = false;
    }

    private void onMoreOptionSwitched() {
        if (this.isMoreOptionActivated) {
            this.showMoreOptionsButtons();
        } else {
            this.hideMoreOptionsButtons();
        }
    }

    private void hideMoreOptionsButtons() {
        for (class_4185 bw : this.moreOptionButtons) {
            bw.field_22764 = false;
        }
        for (class_342 tfw : this.moreOptionTexts) {
            tfw.field_22764 = false;
        }
        this.gapField.field_22764 = false;
        this.groupAlignmentButton.field_22764 = false;
        this.childAlignmentButton.field_22764 = false;
        this.childOrderingButton.field_22764 = false;
    }

    private void showMoreOptionsButtons() {
        AbstractHUD abstractHUD;
        for (class_4185 bw : this.moreOptionButtons) {
            bw.field_22764 = true;
        }
        for (class_342 tfw : this.moreOptionTexts) {
            tfw.field_22764 = true;
        }
        if (!this.selectedHUDs.isEmpty() && (abstractHUD = this.selectedHUDs.getFirst()) instanceof GroupedHUD) {
            GroupedHUD hud = (GroupedHUD)abstractHUD;
            this.gapField.field_22764 = true;
            this.groupAlignmentButton.field_22764 = true;
            this.childAlignmentButton.field_22764 = true;
            this.childOrderingButton.field_22764 = true;
            this.gapField.method_1888(true);
            this.groupAlignmentButton.field_22763 = true;
            this.childAlignmentButton.field_22763 = true;
            this.childOrderingButton.field_22763 = true;
            this.supressFieldEvents = true;
            this.gapField.method_1852(Integer.toString(hud.groupSettings.gap));
            this.supressFieldEvents = false;
            this.groupAlignmentButton.method_25355((class_2561)class_2561.method_43471((String)(hud.groupSettings.alignVertical ? "starhud.screen.button.group_alignment.vertical" : "starhud.screen.button.group_alignment.horizontal")));
            this.childAlignmentButton.method_25355(class_2561.method_30163((String)hud.groupSettings.getChildAlignment().toString()));
            this.childOrderingButton.method_25355(class_2561.method_30163((String)hud.groupSettings.getChildOrdering().toString()));
        }
    }

    private HUDAction onAlignmentXChanged(AbstractHUD hud, ScreenAlignmentX nextAlignment) {
        ScreenAlignmentX prevAlignment = hud.getSettings().getOriginX();
        if (prevAlignment == nextAlignment) {
            return null;
        }
        GrowthDirectionX prevGrowth = hud.getSettings().getGrowthDirectionX();
        GrowthDirectionX nextGrowth = hud.getSettings().getGrowthDirectionX().recommendedScreenAlignment(nextAlignment);
        return new ReversibleAction(() -> {
            hud.getSettings().originX = nextAlignment;
            hud.getSettings().growthDirectionX = nextGrowth;
            hud.update();
        }, () -> {
            hud.getSettings().originX = prevAlignment;
            hud.getSettings().growthDirectionX = prevGrowth;
            hud.update();
        });
    }

    private HUDAction onAlignmentYChanged(AbstractHUD hud, ScreenAlignmentY nextAlignment) {
        ScreenAlignmentY prevAlignment = hud.getSettings().getOriginY();
        if (prevAlignment == nextAlignment) {
            return null;
        }
        GrowthDirectionY prevGrowth = hud.getSettings().getGrowthDirectionY();
        GrowthDirectionY nextGrowth = hud.getSettings().getGrowthDirectionY().recommendedScreenAlignment(nextAlignment);
        return new ReversibleAction(() -> {
            hud.getSettings().originY = nextAlignment;
            hud.getSettings().growthDirectionY = nextGrowth;
            hud.update();
        }, () -> {
            hud.getSettings().originY = prevAlignment;
            hud.getSettings().growthDirectionY = prevGrowth;
            hud.update();
        });
    }

    private HUDAction onDirectionXChanged(AbstractHUD hud, GrowthDirectionX nextGrowth) {
        GrowthDirectionX prevGrowth = hud.getSettings().getGrowthDirectionX();
        if (prevGrowth == nextGrowth) {
            return null;
        }
        return new ReversibleAction(() -> {
            hud.getSettings().growthDirectionX = nextGrowth;
            hud.update();
        }, () -> {
            hud.getSettings().growthDirectionX = prevGrowth;
            hud.update();
        });
    }

    private HUDAction onDirectionYChanged(AbstractHUD hud, GrowthDirectionY nextGrowth) {
        GrowthDirectionY prevGrowth = hud.getSettings().getGrowthDirectionY();
        if (prevGrowth == nextGrowth) {
            return null;
        }
        return new ReversibleAction(() -> {
            hud.getSettings().growthDirectionY = nextGrowth;
            hud.update();
        }, () -> {
            hud.getSettings().growthDirectionY = prevGrowth;
            hud.update();
        });
    }

    private HUDAction onScaleFieldChanged(AbstractHUD hud, float oldScale, float newScale) {
        if (oldScale == newScale) {
            return null;
        }
        return new ReversibleAction(() -> {
            hud.getSettings().scale = newScale;
            hud.update();
        }, () -> {
            hud.getSettings().scale = oldScale;
            hud.update();
        });
    }

    private HUDAction onHUDDisplayModeChanged(AbstractHUD hud, HUDDisplayMode newDisplayMode) {
        HUDDisplayMode oldDisplayMode = hud.getSettings().getDisplayMode();
        if (oldDisplayMode == newDisplayMode) {
            return null;
        }
        return new ReversibleAction(() -> {
            hud.getSettings().displayMode = newDisplayMode;
            hud.update();
        }, () -> {
            hud.getSettings().displayMode = oldDisplayMode;
            hud.update();
        });
    }

    private HUDAction onDrawBackgroundChanged(AbstractHUD hud, boolean newDrawBackground) {
        boolean oldDrawBackground = hud.getSettings().drawBackground;
        if (oldDrawBackground == newDrawBackground) {
            return null;
        }
        return new ReversibleAction(() -> {
            hud.getSettings().drawBackground = newDrawBackground;
            hud.update();
        }, () -> {
            hud.getSettings().drawBackground = oldDrawBackground;
            hud.update();
        });
    }

    private HUDAction onShouldRenderChanged(AbstractHUD hud, boolean newShouldRender) {
        boolean oldShouldRender = hud.getSettings().shouldRender();
        if (oldShouldRender == newShouldRender) {
            return null;
        }
        return new ReversibleAction(() -> {
            hud.getSettings().shouldRender = newShouldRender;
            hud.update();
        }, () -> {
            hud.getSettings().shouldRender = oldShouldRender;
            hud.update();
        });
    }

    private HUDAction onXFieldChanged(AbstractHUD hud, int oldX, int newX) {
        if (oldX == newX) {
            return null;
        }
        return new ReversibleAction(() -> {
            hud.getSettings().x = newX;
            hud.update();
        }, () -> {
            hud.getSettings().x = oldX;
            hud.update();
        });
    }

    private HUDAction onYFieldChanged(AbstractHUD hud, int oldY, int newY) {
        if (oldY == newY) {
            return null;
        }
        return new ReversibleAction(() -> {
            hud.getSettings().y = newY;
            hud.update();
        }, () -> {
            hud.getSettings().y = oldY;
            hud.update();
        });
    }

    private HUDAction onGapFieldChanged(GroupedHUD hud, int oldGap, int newGap) {
        if (oldGap == newGap) {
            return null;
        }
        return new ReversibleAction(() -> {
            hud.groupSettings.gap = newGap;
        }, () -> {
            hud.groupSettings.gap = oldGap;
        });
    }

    private HUDAction onChildAlignmentChanged(GroupedHUD hud, GroupedHUDSettings.ChildAlignment newAlignment) {
        GroupedHUDSettings.ChildAlignment oldAlignment = hud.groupSettings.getChildAlignment();
        if (oldAlignment == newAlignment) {
            return null;
        }
        return new ReversibleAction(() -> {
            hud.groupSettings.childAlignment = newAlignment;
        }, () -> {
            hud.groupSettings.childAlignment = oldAlignment;
        });
    }

    private HUDAction onChildOrderingChanged(GroupedHUD hud, GroupedHUDSettings.ChildOrdering newOrdering) {
        GroupedHUDSettings.ChildOrdering oldOrdering = hud.groupSettings.getChildOrdering();
        if (oldOrdering == newOrdering) {
            return null;
        }
        return new ReversibleAction(() -> {
            hud.groupSettings.childOrdering = newOrdering;
        }, () -> {
            hud.groupSettings.childOrdering = oldOrdering;
        });
    }

    private HUDAction onGroupAlignmentChanged(GroupedHUD hud, boolean newAlignment) {
        boolean oldAlignment = hud.groupSettings.alignVertical;
        if (oldAlignment == newAlignment) {
            return null;
        }
        return new ReversibleAction(() -> {
            hud.groupSettings.alignVertical = newAlignment;
        }, () -> {
            hud.groupSettings.alignVertical = oldAlignment;
        });
    }

    private HUDAction onGroupChanged(List<AbstractHUD> huds) {
        ArrayList<GroupedHUDSettings> oldGroupedHUDs = new ArrayList<GroupedHUDSettings>(Main.settings.hudList.groupedHuds);
        ArrayList<String> oldIndividualHUDs = new ArrayList<String>(Main.settings.hudList.individualHudIds);
        GroupedHUDSettings newSettings = HUDComponent.getInstance().group(huds);
        ArrayList<GroupedHUDSettings> newGroupedHUDs = new ArrayList<GroupedHUDSettings>(Main.settings.hudList.groupedHuds);
        ArrayList<String> newIndividualHUDs = new ArrayList<String>(Main.settings.hudList.individualHudIds);
        return new ReversibleAction(() -> {
            Main.settings.hudList.groupedHuds.clear();
            Main.settings.hudList.individualHudIds.clear();
            Main.settings.hudList.groupedHuds.addAll(newGroupedHUDs);
            Main.settings.hudList.individualHudIds.addAll(newIndividualHUDs);
            HUDComponent.getInstance().updateActiveHUDs();
            GroupedHUD newGroup = HUDComponent.getInstance().getGroupedHUDs().get(newSettings.id);
            newGroup.groupSettings = newSettings;
        }, () -> {
            Main.settings.hudList.groupedHuds.clear();
            Main.settings.hudList.individualHudIds.clear();
            Main.settings.hudList.groupedHuds.addAll(oldGroupedHUDs);
            Main.settings.hudList.individualHudIds.addAll(oldIndividualHUDs);
            HUDComponent.getInstance().updateActiveHUDs();
        });
    }

    private HUDAction onUngroupChanged(GroupedHUD hud) {
        GroupedHUDSettings oldSettings = hud.groupSettings.copy();
        ArrayList<GroupedHUDSettings> oldGroupedHUDs = new ArrayList<GroupedHUDSettings>(Main.settings.hudList.groupedHuds);
        ArrayList<String> oldIndividualHUDs = new ArrayList<String>(Main.settings.hudList.individualHudIds);
        HUDComponent.getInstance().unGroup(hud);
        ArrayList<GroupedHUDSettings> newGroupedHUDs = new ArrayList<GroupedHUDSettings>(Main.settings.hudList.groupedHuds);
        ArrayList<String> newIndividualHUDs = new ArrayList<String>(Main.settings.hudList.individualHudIds);
        return new ReversibleAction(() -> {
            Main.settings.hudList.groupedHuds.clear();
            Main.settings.hudList.individualHudIds.clear();
            Main.settings.hudList.groupedHuds.addAll(newGroupedHUDs);
            Main.settings.hudList.individualHudIds.addAll(newIndividualHUDs);
            HUDComponent.getInstance().updateActiveHUDs();
        }, () -> {
            Main.settings.hudList.groupedHuds.clear();
            Main.settings.hudList.individualHudIds.clear();
            Main.settings.hudList.groupedHuds.addAll(oldGroupedHUDs);
            Main.settings.hudList.individualHudIds.addAll(oldIndividualHUDs);
            HUDComponent.getInstance().updateActiveHUDs();
            GroupedHUD newGroup = HUDComponent.getInstance().getGroupedHUDs().get(oldSettings.id);
            newGroup.groupSettings = oldSettings;
        });
    }

    private HUDAction onConfigScreenClicked() {
        return null;
    }
}

