/*
 * Decompiled with CFR 0.152.
 */
package fin.starhud.helper;

import com.mojang.blaze3d.systems.RenderSystem;
import fin.starhud.Main;
import fin.starhud.config.GeneralSettings;
import fin.starhud.helper.HUDDisplayMode;
import net.minecraft.class_1799;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_5481;

public class RenderUtils {
    private static final class_310 CLIENT = class_310.method_1551();
    private static final GeneralSettings.HUDSettings HUD_SETTINGS = Main.settings.generalSettings.hudSettings;
    private static final int ITEM_HUD_ICON_WIDTH = 22;
    private static final int ITEM_HUD_ICON_HEIGHT = 22;

    public static boolean drawSmallHUD(class_332 context, String infoStr, int x, int y, int width, int height, class_2960 iconTexture, float u, float v, int textureWidth, int textureHeight, int iconWidth, int iconHeight, int color, int iconColor, HUDDisplayMode displayMode, boolean drawBackground) {
        if (iconTexture == null || infoStr == null || displayMode == null) {
            return false;
        }
        class_5481 orderedText = class_5481.method_30747((String)infoStr, (class_2583)class_2583.field_24360);
        return RenderUtils.drawSmallHUD(context, orderedText, x, y, width, height, iconTexture, u, v, textureWidth, textureHeight, iconWidth, iconHeight, color, iconColor, displayMode, drawBackground);
    }

    public static boolean drawSmallHUD(class_332 context, class_5481 infoText, int x, int y, int width, int height, class_2960 iconTexture, float u, float v, int textureWidth, int textureHeight, int iconWidth, int iconHeight, int color, int iconColor, HUDDisplayMode displayMode, boolean drawBackground) {
        if (infoText == null || iconTexture == null || displayMode == null) {
            return false;
        }
        int padding = RenderUtils.HUD_SETTINGS.textPadding;
        int gap = RenderUtils.HUD_SETTINGS.iconInfoGap;
        switch (displayMode) {
            case ICON: {
                if (drawBackground) {
                    RenderUtils.fillRounded(context, x, y, x + iconWidth, y + iconHeight, Integer.MIN_VALUE);
                }
                RenderUtils.drawTextureHUD(context, iconTexture, x, y, u, v, iconWidth, iconHeight, textureWidth, textureHeight, iconColor);
                break;
            }
            case INFO: {
                if (drawBackground) {
                    RenderUtils.fillRounded(context, x, y, x + width, y + height, Integer.MIN_VALUE);
                }
                RenderUtils.drawTextHUD(context, infoText, x + padding, y + 3, color, false);
                break;
            }
            case BOTH: {
                if (drawBackground) {
                    if (gap <= 0) {
                        RenderUtils.fillRounded(context, x, y, x + width, y + height, Integer.MIN_VALUE);
                    } else {
                        RenderUtils.fillRoundedLeftSide(context, x, y, x + iconWidth, y + height, Integer.MIN_VALUE);
                        RenderUtils.fillRoundedRightSide(context, x + iconWidth + gap, y, x + width, y + height, Integer.MIN_VALUE);
                    }
                }
                RenderUtils.drawTextureHUD(context, iconTexture, x, y, u, v, iconWidth, iconHeight, textureWidth, textureHeight, iconColor);
                RenderUtils.drawTextHUD(context, infoText, x + iconWidth + gap + padding, y + 3, color, false);
            }
        }
        return true;
    }

    public static boolean drawSmallHUD(class_332 context, String infoStr, int x, int y, int width, int height, class_2960 iconTexture, float u, float v, int textureWidth, int textureHeight, int iconWidth, int iconHeight, int color, HUDDisplayMode displayMode, boolean drawBackground) {
        if (infoStr == null || iconTexture == null || displayMode == null) {
            return false;
        }
        class_5481 orderedText = class_5481.method_30747((String)infoStr, (class_2583)class_2583.field_24360);
        return RenderUtils.drawSmallHUD(context, orderedText, x, y, width, height, iconTexture, u, v, textureWidth, textureHeight, iconWidth, iconHeight, color, color, displayMode, drawBackground);
    }

    public static boolean drawSmallHUD(class_332 context, class_5481 infoText, int x, int y, int width, int height, class_2960 iconTexture, float u, float v, int textureWidth, int textureHeight, int iconWidth, int iconHeight, int color, HUDDisplayMode displayMode, boolean drawBackground) {
        if (infoText == null || iconTexture == null || displayMode == null) {
            return false;
        }
        return RenderUtils.drawSmallHUD(context, infoText, x, y, width, height, iconTexture, u, v, textureWidth, textureHeight, iconWidth, iconHeight, color, color, displayMode, drawBackground);
    }

    public static boolean drawItemHUD(class_332 context, String str, int x, int y, int width, int height, class_1799 itemAsIcon, int textColor, HUDDisplayMode displayMode, boolean drawBackground) {
        if (str == null || itemAsIcon == null || displayMode == null) {
            return false;
        }
        int padding = RenderUtils.HUD_SETTINGS.textPadding;
        int gap = RenderUtils.HUD_SETTINGS.iconInfoGap;
        switch (displayMode) {
            case ICON: {
                if (drawBackground) {
                    RenderUtils.fillRounded(context, x, y, x + 22, y + 22, Integer.MIN_VALUE);
                }
                context.method_51427(itemAsIcon, x + 3, y + 3);
                break;
            }
            case INFO: {
                if (drawBackground) {
                    RenderUtils.fillRounded(context, x, y, x + width, y + height, Integer.MIN_VALUE);
                }
                RenderUtils.drawTextHUD(context, str, x + padding, y + 7, textColor, false);
                break;
            }
            case BOTH: {
                if (drawBackground) {
                    if (gap <= 0) {
                        RenderUtils.fillRounded(context, x, y, x + width, y + height, Integer.MIN_VALUE);
                    } else {
                        RenderUtils.fillRoundedLeftSide(context, x, y, x + 22, y + height, Integer.MIN_VALUE);
                        RenderUtils.fillRoundedRightSide(context, x + 22 + gap, y, x + width, y + height, Integer.MIN_VALUE);
                    }
                }
                context.method_51427(itemAsIcon, x + 3, y + 3);
                RenderUtils.drawTextHUD(context, str, x + 22 + gap + padding, y + 7, textColor, false);
            }
        }
        return true;
    }

    public static void fillRoundedRightSide(class_332 context, int x1, int y1, int x2, int y2, int color) {
        if (RenderUtils.HUD_SETTINGS.drawBackgroundRounded) {
            context.method_25294(x1, y1, x2 - 1, y2, color);
            context.method_25294(x2 - 1, y1 + 1, x2, y2 - 1, color);
        } else {
            context.method_25294(x1, y1, x2, y2, color);
        }
    }

    public static void fillRoundedLeftSide(class_332 context, int x1, int y1, int x2, int y2, int color) {
        if (RenderUtils.HUD_SETTINGS.drawBackgroundRounded) {
            context.method_25294(x1, y1 + 1, x1 + 1, y2 - 1, color);
            context.method_25294(x1 + 1, y1, x2, y2, color);
        } else {
            context.method_25294(x1, y1, x2, y2, color);
        }
    }

    public static void fillRounded(class_332 context, int x1, int y1, int x2, int y2, int color) {
        if (RenderUtils.HUD_SETTINGS.drawBackgroundRounded) {
            context.method_25294(x1, y1 + 1, x1 + 1, y2 - 1, color);
            context.method_25294(x1 + 1, y1, x2 - 1, y2, color);
            context.method_25294(x2 - 1, y1 + 1, x2, y2 - 1, color);
        } else {
            context.method_25294(x1, y1, x2, y2, color);
        }
    }

    public static void drawBorder(class_332 context, int x, int y, int w, int h, int color) {
        context.method_25294(x, y, x + w, y + 1, color);
        context.method_25294(x, y, x + 1, y + h, color);
        context.method_25294(x, y + h - 1, x + w, y + h, color);
        context.method_25294(x + w - 1, y, x + w, y + h, color);
    }

    public static void drawTextureAlphaColor(class_332 context, class_2960 identifier, int x, int y, float u, float v, int width, int height, int textureWidth, int textureHeight, int color) {
        float alpha = (float)(color >> 24 & 0xFF) / 255.0f;
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        RenderSystem.enableBlend();
        RenderSystem.setShaderColor((float)red, (float)green, (float)blue, (float)alpha);
        context.method_25290(identifier, x, y, u, v, width, height, textureWidth, textureHeight);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
    }

    public static void drawTextureAlpha(class_332 context, class_2960 identifier, int x, int y, float u, float v, int width, int height, int textureWidth, int textureHeight) {
        RenderSystem.enableBlend();
        context.method_25290(identifier, x, y, u, v, width, height, textureWidth, textureHeight);
        RenderSystem.disableBlend();
    }

    public static void drawTextureColor(class_332 context, class_2960 identifier, int x, int y, float u, float v, int width, int height, int textureWidth, int textureHeight, int color) {
        float alpha = (float)(color >> 24 & 0xFF) / 255.0f;
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        RenderSystem.setShaderColor((float)red, (float)green, (float)blue, (float)alpha);
        context.method_25290(identifier, x, y, u, v, width, height, textureWidth, textureHeight);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void drawTextureHUD(class_332 context, class_2960 identifier, int x, int y, float u, float v, int width, int height, int textureWidth, int textureHeight, int color) {
        if (identifier == null) {
            return;
        }
        RenderUtils.drawTextureAlphaColor(context, identifier, x, y, u, v, width, height, textureWidth, textureHeight, color);
    }

    public static void drawTextureHUD(class_332 context, class_2960 identifier, int x, int y, float u, float v, int width, int height, int textureWidth, int textureHeight) {
        if (identifier == null) {
            return;
        }
        RenderUtils.drawTextureAlpha(context, identifier, x, y, u, v, width, height, textureWidth, textureHeight);
    }

    public static void drawTextHUD(class_332 context, String str, int x, int y, int color, boolean shadow) {
        if (str != null) {
            class_5481 orderedText = class_5481.method_30747((String)str, (class_2583)class_2583.field_24360);
            RenderUtils.drawTextHUD(context, orderedText, x, y, color, shadow);
        }
    }

    public static void drawTextHUD(class_332 context, class_5481 text, int x, int y, int color, boolean shadow) {
        context.method_51430(RenderUtils.CLIENT.field_1772, text, x, y + RenderUtils.HUD_SETTINGS.textYOffset, color, shadow);
    }
}

