/*
 * Decompiled with CFR 0.152.
 */
package fin.starhud.hud;

import fin.starhud.Main;
import fin.starhud.config.GeneralSettings;
import fin.starhud.config.GroupedHUDSettings;
import fin.starhud.config.HUDList;
import fin.starhud.helper.HUDDisplayMode;
import fin.starhud.hud.AbstractHUD;
import fin.starhud.hud.GroupedHUD;
import fin.starhud.hud.HUDId;
import fin.starhud.hud.HUDInterface;
import fin.starhud.hud.implementation.armor.BootsHUD;
import fin.starhud.hud.implementation.armor.ChestplateHUD;
import fin.starhud.hud.implementation.armor.HelmetHUD;
import fin.starhud.hud.implementation.armor.LeggingsHUD;
import fin.starhud.hud.implementation.clock.ClockInGameHUD;
import fin.starhud.hud.implementation.clock.ClockSystemHUD;
import fin.starhud.hud.implementation.coordinate.nether.NetherXCoordinate;
import fin.starhud.hud.implementation.coordinate.nether.NetherYCoordinate;
import fin.starhud.hud.implementation.coordinate.nether.NetherZCoordinate;
import fin.starhud.hud.implementation.coordinate.normal.XCoordinateHUD;
import fin.starhud.hud.implementation.coordinate.normal.YCoordinateHUD;
import fin.starhud.hud.implementation.coordinate.normal.ZCoordinateHUD;
import fin.starhud.hud.implementation.hand.LeftHandHUD;
import fin.starhud.hud.implementation.hand.RightHandHUD;
import fin.starhud.hud.implementation.other.BiomeHUD;
import fin.starhud.hud.implementation.other.ComboHUD;
import fin.starhud.hud.implementation.other.DayHUD;
import fin.starhud.hud.implementation.other.DirectionHUD;
import fin.starhud.hud.implementation.other.FPSHUD;
import fin.starhud.hud.implementation.other.InventoryHUD;
import fin.starhud.hud.implementation.other.PingHUD;
import fin.starhud.hud.implementation.other.PlayerCountHUD;
import fin.starhud.hud.implementation.other.ReachHUD;
import fin.starhud.hud.implementation.other.SpeedHUD;
import fin.starhud.hud.implementation.other.TPSHUD;
import fin.starhud.hud.implementation.other.TargetedCrosshairHUD;
import fin.starhud.hud.implementation.statuseffect.NegativeEffectHUD;
import fin.starhud.hud.implementation.statuseffect.PositiveEffectHUD;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_332;
import org.slf4j.Logger;

public class HUDComponent {
    private static HUDComponent instance;
    private static final Logger LOGGER;
    private GeneralSettings.HUDSettings HUD_SETTINGS;
    private final Map<String, AbstractHUD> hudMap = new HashMap<String, AbstractHUD>();
    private final Map<String, AbstractHUD> individualHUDs = new HashMap<String, AbstractHUD>();
    private final Map<String, GroupedHUD> groupedHUDs = new HashMap<String, GroupedHUD>();
    public final List<AbstractHUD> renderedHUDs = new ArrayList<AbstractHUD>();
    private long lastCollect = -1L;
    private final List<AbstractHUD> invalidHUDs = new ArrayList<AbstractHUD>();

    private HUDComponent() {
    }

    public static HUDComponent getInstance() {
        if (instance == null) {
            instance = new HUDComponent();
        }
        return instance;
    }

    public void init() {
        this.registerBuiltInHUDs();
        this.loadActiveHUDsFromConfig();
        this.HUD_SETTINGS = Main.settings.generalSettings.hudSettings;
    }

    private void registerBuiltInHUDs() {
        this.registerHUD(new HelmetHUD());
        this.registerHUD(new ChestplateHUD());
        this.registerHUD(new LeggingsHUD());
        this.registerHUD(new BootsHUD());
        this.registerHUD(new XCoordinateHUD());
        this.registerHUD(new YCoordinateHUD());
        this.registerHUD(new ZCoordinateHUD());
        this.registerHUD(new NetherXCoordinate());
        this.registerHUD(new NetherYCoordinate());
        this.registerHUD(new NetherZCoordinate());
        this.registerHUD(new LeftHandHUD());
        this.registerHUD(new RightHandHUD());
        this.registerHUD(new ClockInGameHUD());
        this.registerHUD(new ClockSystemHUD());
        this.registerHUD(new BiomeHUD());
        this.registerHUD(new DayHUD());
        this.registerHUD(new DirectionHUD());
        this.registerHUD(new FPSHUD());
        this.registerHUD(new TPSHUD());
        this.registerHUD(new InventoryHUD());
        this.registerHUD(new PingHUD());
        this.registerHUD(new SpeedHUD());
        this.registerHUD(new TargetedCrosshairHUD());
        this.registerHUD(new PlayerCountHUD());
        this.registerHUD(new ComboHUD());
        this.registerHUD(new ReachHUD());
        this.registerHUD(new PositiveEffectHUD());
        this.registerHUD(new NegativeEffectHUD());
    }

    public Map<String, AbstractHUD> getHudMap() {
        return this.hudMap;
    }

    public Map<String, AbstractHUD> getIndividualHUDs() {
        return this.individualHUDs;
    }

    public Map<String, GroupedHUD> getGroupedHUDs() {
        return this.groupedHUDs;
    }

    public List<AbstractHUD> getRenderedHUDs() {
        return this.renderedHUDs;
    }

    public void loadActiveHUDsFromConfig() {
        HUDList hudConfig = Main.settings.hudList;
        this.individualHUDs.clear();
        for (String id : hudConfig.individualHudIds) {
            AbstractHUD hud = this.hudMap.get(id);
            hud.setGroupId(null);
            this.individualHUDs.put(id, hud);
        }
        this.groupedHUDs.clear();
        for (GroupedHUDSettings settings : hudConfig.groupedHuds) {
            this.groupedHUDs.put(settings.id, new GroupedHUD(settings));
        }
    }

    private void registerHUD(AbstractHUD hud) {
        this.hudMap.put(hud.getId(), hud);
        LOGGER.info("{} Added to Hud Map.", (Object)hud.getId());
    }

    public AbstractHUD getHUD(String id) {
        AbstractHUD hud = this.hudMap.get(id);
        if (hud != null) {
            return hud;
        }
        hud = this.groupedHUDs.get(id);
        if (hud != null) {
            return hud;
        }
        LOGGER.warn("No such group with id: {} existed in the map, creating new one if available in config", (Object)id);
        List<GroupedHUDSettings> groupSettings = Main.settings.hudList.groupedHuds;
        for (GroupedHUDSettings setting : groupSettings) {
            if (!id.equals(setting.id)) continue;
            hud = new GroupedHUD(setting);
            this.groupedHUDs.put(id, (GroupedHUD)hud);
            return hud;
        }
        LOGGER.error("Group with ID: {} does not exist. returning null.", (Object)id);
        return null;
    }

    public AbstractHUD getHUD(HUDId id) {
        return this.hudMap.get(id.toString());
    }

    public void renderAll(class_332 context) {
        for (AbstractHUD hud : this.renderedHUDs) {
            if (hud.render(context)) continue;
            LOGGER.warn("{} is collected but still failed! Removing from rendered hud.", (Object)hud.getName());
            this.invalidHUDs.add(hud);
        }
        if (!this.invalidHUDs.isEmpty()) {
            this.renderedHUDs.removeAll(this.invalidHUDs);
            this.invalidHUDs.clear();
        }
    }

    public void collectAll() {
        long intervalNanos;
        long now = System.nanoTime();
        if (now - this.lastCollect < (intervalNanos = (long)(this.HUD_SETTINGS.dataCollectionInterval * 1.0E9f))) {
            return;
        }
        this.lastCollect = now;
        this.renderedHUDs.clear();
        for (AbstractHUD hud : this.individualHUDs.values()) {
            if (!hud.shouldRender() || !hud.collect()) continue;
            this.renderedHUDs.add(hud);
        }
        for (GroupedHUD group : this.groupedHUDs.values()) {
            if (group.isInGroup() || !group.shouldRender() || !group.collect()) continue;
            this.renderedHUDs.add(group);
        }
    }

    public void updateAll() {
        for (HUDInterface hUDInterface : this.hudMap.values()) {
            hUDInterface.update();
        }
        for (HUDInterface hUDInterface : this.groupedHUDs.values()) {
            hUDInterface.update();
        }
    }

    public void updateActiveHUDs() {
        this.loadActiveHUDsFromConfig();
        this.updateAll();
    }

    public void removeActiveHUDs() {
        this.individualHUDs.clear();
        this.groupedHUDs.clear();
    }

    public void clampAll() {
        for (AbstractHUD hud : this.renderedHUDs) {
            hud.clampPos();
        }
    }

    public GroupedHUDSettings group(List<AbstractHUD> huds) {
        GroupedHUDSettings newSettings = new GroupedHUDSettings();
        List<GroupedHUDSettings> groupedHUDs = Main.settings.hudList.groupedHuds;
        List<String> individualHUDs = Main.settings.hudList.individualHudIds;
        for (AbstractHUD hud : huds) {
            if (hud.isInGroup()) {
                throw new IllegalStateException("HUD " + hud.getId() + " is already in a group.");
            }
            if (!(hud instanceof GroupedHUD)) {
                individualHUDs.remove(hud.getId());
            }
            newSettings.hudIds.add(hud.getId());
            hud.setGroupId(newSettings.id);
        }
        AbstractHUD firstHUD = huds.getFirst();
        newSettings.base.copyFrom(firstHUD.getSettings());
        newSettings.base.drawBackground = false;
        newSettings.base.displayMode = HUDDisplayMode.BOTH;
        newSettings.boxColor = firstHUD.getBoundingBox().getColor() & 0xFFFFFF;
        groupedHUDs.add(newSettings);
        HUDComponent.getInstance().updateActiveHUDs();
        return newSettings;
    }

    public void unGroup(GroupedHUD groupedHUD) {
        List<AbstractHUD> huds = groupedHUD.huds;
        List<GroupedHUDSettings> groupedHUDs = Main.settings.hudList.groupedHuds;
        List<String> individualHUDs = Main.settings.hudList.individualHudIds;
        for (AbstractHUD hud : huds) {
            if (!(hud instanceof GroupedHUD)) {
                individualHUDs.add(hud.getId());
            }
            hud.setGroupId(null);
        }
        groupedHUDs.removeIf(a -> a.id.equals(groupedHUD.groupSettings.id));
        HUDComponent.getInstance().updateActiveHUDs();
    }

    public String generateNextGroupId() {
        String id;
        int index = 1;
        while (this.groupedHUDs.containsKey(id = "group_" + index++)) {
        }
        return id;
    }

    static {
        LOGGER = Main.LOGGER;
    }
}

