/*
 * Decompiled with CFR 0.152.
 */
package fin.starhud.hud.implementation.hand;

import fin.starhud.config.hud.HandSettings;
import fin.starhud.helper.HUDDisplayMode;
import fin.starhud.helper.RenderUtils;
import fin.starhud.hud.implementation.AbstractDurabilityHUD;
import net.minecraft.class_1268;
import net.minecraft.class_1306;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;

public abstract class AbstractHandHUD
extends AbstractDurabilityHUD {
    private static final int TEXTURE_WIDTH = 13;
    private static final int TEXTURE_HEIGHT = 13;
    private static final int ICON_WIDTH = 13;
    private static final int ICON_HEIGHT = 13;
    private static final int ITEM_TEXTURE_WIDTH = 22;
    private static final int ITEM_TEXTURE_HEIGHT = 22;
    private static final class_310 CLIENT = class_310.method_1551();
    private final HandSettings handSettings;
    private final class_1306 arm;
    private final class_2960 ICON_TEXTURE;
    private class_1799 item;
    private int iconColor;
    private String amountStr;
    private boolean showDurability;
    private boolean showCount;
    private boolean drawItem;
    private boolean isItemDamagable;
    private HUDDisplayMode displayMode;

    public AbstractHandHUD(HandSettings handSettings, class_1306 arm, class_2960 ICON_TEXTURE) {
        super(handSettings.base, handSettings.durabilitySettings);
        this.handSettings = handSettings;
        this.arm = arm;
        this.ICON_TEXTURE = ICON_TEXTURE;
    }

    @Override
    public class_1799 getStack() {
        if (AbstractHandHUD.CLIENT.field_1724 == null) {
            return null;
        }
        return AbstractHandHUD.CLIENT.field_1724.method_5998(AbstractHandHUD.CLIENT.field_1724.method_6068() == this.arm ? class_1268.field_5808 : class_1268.field_5810);
    }

    @Override
    public boolean collectHUDInformation() {
        this.item = this.getStack();
        if (this.item.method_7960()) {
            return false;
        }
        this.showDurability = this.handSettings.showDurability;
        this.showCount = this.handSettings.showCount;
        this.drawItem = this.handSettings.durabilitySettings.drawItem;
        this.displayMode = this.getSettings().getDisplayMode();
        this.isItemDamagable = this.item.method_7963();
        if (this.showDurability && this.isItemDamagable) {
            return super.collectHUDInformation();
        }
        if (!this.showCount) {
            return false;
        }
        this.iconColor = this.getIconColor();
        if (AbstractHandHUD.CLIENT.field_1724 == null) {
            return false;
        }
        this.amountStr = Integer.toString(AbstractHandHUD.getItemCount(AbstractHandHUD.CLIENT.field_1724.method_31548(), this.item));
        int strWidth = AbstractHandHUD.CLIENT.field_1772.method_1727(this.amountStr) - 1;
        int width = this.displayMode.calculateWidth(this.drawItem ? 22 : 13, strWidth);
        int height = this.drawItem ? 22 : 13;
        this.setWidthHeightColor(width, height, this.iconColor);
        return this.amountStr != null;
    }

    @Override
    public boolean renderHUD(class_332 context, int x, int y, boolean drawBackground) {
        return this.renderHandHUD(context, x, y, drawBackground);
    }

    public boolean renderHandHUD(class_332 context, int x, int y, boolean drawBackground) {
        if (this.showDurability && this.isItemDamagable) {
            return this.renderDurabilityHUD(context, this.ICON_TEXTURE, x, y, 0.0f, 0.0f, 13, 13, 13, 13, drawBackground);
        }
        if (this.showCount) {
            return this.renderStackCountHUD(context, x, y, drawBackground);
        }
        return false;
    }

    private boolean renderStackCountHUD(class_332 context, int x, int y, boolean drawBackground) {
        if (this.drawItem) {
            return this.renderStackCountItemHUD(context, x, y, drawBackground);
        }
        return this.renderStackCountIconHUD(context, x, y, drawBackground);
    }

    private boolean renderStackCountItemHUD(class_332 context, int x, int y, boolean drawBackground) {
        return RenderUtils.drawItemHUD(context, this.amountStr, x, y, this.getWidth(), this.getHeight(), this.item, this.iconColor, this.displayMode, drawBackground);
    }

    private boolean renderStackCountIconHUD(class_332 context, int x, int y, boolean drawBackground) {
        return RenderUtils.drawSmallHUD(context, this.amountStr, x, y, this.getWidth(), this.getHeight(), this.ICON_TEXTURE, 0.0f, 0.0f, 13, 13, 13, 13, this.iconColor, this.displayMode, drawBackground);
    }

    private static int getItemCount(class_1661 inventory, class_1799 stack) {
        int stackAmount = 0;
        for (int i = 0; i < inventory.method_5439(); ++i) {
            class_1799 item = inventory.method_5438(i);
            if (item.method_7960() || !class_1799.method_31577((class_1799)item, (class_1799)stack)) continue;
            stackAmount += item.method_7947();
        }
        return stackAmount;
    }
}

