/*
 * Decompiled with CFR 0.152.
 */
package fin.starhud.hud.implementation.other;

import fin.starhud.Helper;
import fin.starhud.Main;
import fin.starhud.config.hud.BiomeSettings;
import fin.starhud.helper.HUDDisplayMode;
import fin.starhud.helper.RenderUtils;
import fin.starhud.hud.AbstractHUD;
import fin.starhud.hud.HUDId;
import java.util.Optional;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2477;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5321;
import net.minecraft.class_5481;
import net.minecraft.class_6880;

public class BiomeHUD
extends AbstractHUD {
    private static final BiomeSettings BIOME_SETTINGS = Main.settings.biomeSettings;
    private static final class_2960 DIMENSION_TEXTURE = class_2960.method_60655((String)"starhud", (String)"hud/dimension.png");
    private static final int TEXTURE_WIDTH = 13;
    private static final int TEXTURE_HEIGHT = 52;
    private static final int ICON_WIDTH = 13;
    private static final int ICON_HEIGHT = 13;
    private static class_5481 cachedBiomeNameText;
    private static class_6880<class_1959> cachedBiome;
    private static int cachedTextWidth;
    private static final class_310 CLIENT;
    private int color;
    private int dimensionIndex;
    private HUDDisplayMode displayMode;

    public BiomeHUD() {
        super(BiomeHUD.BIOME_SETTINGS.base);
    }

    @Override
    public boolean collectHUDInformation() {
        class_327 textRenderer = BiomeHUD.CLIENT.field_1772;
        this.displayMode = this.getSettings().getDisplayMode();
        if (BiomeHUD.CLIENT.field_1724 == null || BiomeHUD.CLIENT.field_1687 == null) {
            return false;
        }
        class_2338 blockPos = BiomeHUD.CLIENT.field_1724.method_24515();
        class_6880 currentBiome = BiomeHUD.CLIENT.field_1687.method_23753(blockPos);
        if (cachedBiome != currentBiome) {
            Optional biomeKey = currentBiome.method_40230();
            if (biomeKey.isPresent()) {
                class_2960 biomeId = ((class_5321)biomeKey.get()).method_29177();
                String translatableKey = "biome." + biomeId.method_12836() + "." + biomeId.method_12832();
                cachedBiomeNameText = class_2477.method_10517().method_4678(translatableKey) ? class_2561.method_43471((String)translatableKey).method_30937() : class_2561.method_30163((String)Helper.idNameFormatter(currentBiome.method_55840())).method_30937();
            } else {
                cachedBiomeNameText = class_2561.method_30163((String)"Unregistered").method_30937();
            }
            cachedBiome = currentBiome;
            cachedTextWidth = textRenderer.method_30880(cachedBiomeNameText) - 1;
        }
        this.dimensionIndex = BiomeHUD.getDimensionIndex((class_5321<class_1937>)BiomeHUD.CLIENT.field_1687.method_27983());
        this.color = BiomeHUD.getTextColorFromDimension(this.dimensionIndex) | 0xFF000000;
        int width = this.displayMode.calculateWidth(13, cachedTextWidth);
        this.setWidthHeightColor(width, 13, this.color);
        return cachedBiomeNameText != null;
    }

    @Override
    public String getName() {
        return "Biome HUD";
    }

    @Override
    public String getId() {
        return HUDId.BIOME.toString();
    }

    @Override
    public boolean renderHUD(class_332 context, int x, int y, boolean drawBackground) {
        return RenderUtils.drawSmallHUD(context, cachedBiomeNameText, x, y, this.getWidth(), this.getHeight(), DIMENSION_TEXTURE, 0.0f, (float)(13 * this.dimensionIndex), 13, 52, 13, 13, this.color, -1, this.displayMode, drawBackground);
    }

    private static int getDimensionIndex(class_5321<class_1937> registryKey) {
        if (registryKey == class_1937.field_25179) {
            return 0;
        }
        if (registryKey == class_1937.field_25180) {
            return 1;
        }
        if (registryKey == class_1937.field_25181) {
            return 2;
        }
        return 3;
    }

    private static int getTextColorFromDimension(int dimensionIndex) {
        return switch (dimensionIndex) {
            case 0 -> BiomeHUD.BIOME_SETTINGS.color.overworld;
            case 1 -> BiomeHUD.BIOME_SETTINGS.color.nether;
            case 2 -> BiomeHUD.BIOME_SETTINGS.color.end;
            default -> BiomeHUD.BIOME_SETTINGS.color.custom;
        };
    }

    static {
        CLIENT = class_310.method_1551();
    }
}

