/*
 * Decompiled with CFR 0.152.
 */
package fin.starhud.hud.implementation.other;

import fin.starhud.Main;
import fin.starhud.config.GeneralSettings;
import fin.starhud.config.hud.InventorySettings;
import fin.starhud.helper.RenderUtils;
import fin.starhud.hud.AbstractHUD;
import fin.starhud.hud.HUDId;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;

public class InventoryHUD
extends AbstractHUD {
    private static final InventorySettings INVENTORY_SETTINGS = Main.settings.inventorySettings;
    private static final GeneralSettings.HUDSettings HUD_SETTINGS = Main.settings.generalSettings.hudSettings;
    private static final class_2960 INVENTORY_TEXTURE = class_2960.method_60655((String)"starhud", (String)"hud/inventory.png");
    private static final class_2960 INVENTORY_TEXTURE_VERTICAL = class_2960.method_60655((String)"starhud", (String)"hud/inventory_vertical.png");
    private static final int[] SLOT_X_HORIZONTAL = new int[27];
    private static final int[] SLOT_Y_HORIZONTAL = new int[27];
    private static final int[] SLOT_X_VERTICAL = new int[27];
    private static final int[] SLOT_Y_VERTICAL = new int[27];
    private static final int TEXTURE_WIDTH_HORIZONTAL = 206;
    private static final int TEXTURE_HEIGHT_HORIZONTAL = 68;
    private static final int TEXTURE_WIDTH_VERTICAL = 68;
    private static final int TEXTURE_HEIGHT_VERTICAL = 206;
    private static final class_310 CLIENT = class_310.method_1551();
    private int width;
    private int height;
    private boolean drawVertical;

    public int getTotalLargerLength() {
        return 198 + Math.min(InventoryHUD.HUD_SETTINGS.iconInfoGap, 1) * 8;
    }

    public int getTotalSmallerLength() {
        return 66 + Math.min(InventoryHUD.HUD_SETTINGS.iconInfoGap, 1) * 2;
    }

    @Override
    public boolean collectHUDInformation() {
        if (this.hasItemInInventory()) {
            this.drawVertical = InventoryHUD.INVENTORY_SETTINGS.drawVertical;
            this.width = this.drawVertical ? this.getTotalSmallerLength() : this.getTotalLargerLength();
            this.height = this.drawVertical ? this.getTotalLargerLength() : this.getTotalSmallerLength();
            this.setWidthHeight(this.width, this.height);
            return true;
        }
        return false;
    }

    @Override
    public String getName() {
        return "Inventory HUD";
    }

    @Override
    public String getId() {
        return HUDId.INVENTORY.toString();
    }

    public InventoryHUD() {
        super(InventoryHUD.INVENTORY_SETTINGS.base);
    }

    @Override
    public boolean renderHUD(class_332 context, int x, int y, boolean drawBackground) {
        if (this.drawVertical) {
            return this.drawInventoryVertical(context, x, y, drawBackground);
        }
        return this.drawInventoryHorizontal(context, x, y, drawBackground);
    }

    @Override
    public void update() {
        super.update();
        InventoryHUD.preComputeHorizontal();
        InventoryHUD.preComputeVertical();
    }

    private boolean drawInventoryVertical(class_332 context, int x, int y, boolean drawBackground) {
        class_1661 inventory = InventoryHUD.CLIENT.field_1724.method_31548();
        int w = this.getWidth();
        int h = this.getHeight();
        int gap = InventoryHUD.HUD_SETTINGS.iconInfoGap;
        if (drawBackground) {
            if (gap <= 0) {
                RenderUtils.fillRounded(context, x, y, x + w, y + h, Integer.MIN_VALUE);
            } else {
                RenderUtils.drawTextureHUD(context, INVENTORY_TEXTURE_VERTICAL, x, y, 0.0f, 0.0f, 68, 206, 68, 206);
            }
        }
        for (int itemIndex = 0; itemIndex < 27; ++itemIndex) {
            class_1799 stack = (class_1799)inventory.field_7547.get(itemIndex + 9);
            if (stack.method_7960()) continue;
            int x1 = x + SLOT_X_VERTICAL[itemIndex];
            int y1 = y + SLOT_Y_VERTICAL[itemIndex];
            context.method_51427(stack, x1, y1);
            context.method_51431(InventoryHUD.CLIENT.field_1772, stack, x1, y1);
        }
        return true;
    }

    private boolean drawInventoryHorizontal(class_332 context, int x, int y, boolean drawBackground) {
        class_1661 inventory = InventoryHUD.CLIENT.field_1724.method_31548();
        int w = this.getWidth();
        int h = this.getHeight();
        int gap = InventoryHUD.HUD_SETTINGS.iconInfoGap;
        if (drawBackground) {
            if (gap <= 0) {
                RenderUtils.fillRounded(context, x, y, x + w, y + h, Integer.MIN_VALUE);
            } else {
                RenderUtils.drawTextureHUD(context, INVENTORY_TEXTURE, x, y, 0.0f, 0.0f, 206, 68, 206, 68);
            }
        }
        for (int itemIndex = 0; itemIndex < 27; ++itemIndex) {
            class_1799 stack = (class_1799)inventory.field_7547.get(itemIndex + 9);
            if (stack.method_7960()) continue;
            int x1 = x + SLOT_X_HORIZONTAL[itemIndex];
            int y1 = y + SLOT_Y_HORIZONTAL[itemIndex];
            context.method_51427(stack, x1, y1);
            context.method_51431(InventoryHUD.CLIENT.field_1772, stack, x1, y1);
        }
        return true;
    }

    public boolean hasItemInInventory() {
        class_1661 inventory = InventoryHUD.CLIENT.field_1724.method_31548();
        for (int itemIndex = 0; itemIndex < 27; ++itemIndex) {
            class_1799 stack = (class_1799)inventory.field_7547.get(itemIndex + 9);
            if (stack.method_7960()) continue;
            return true;
        }
        return false;
    }

    private static void preComputeHorizontal() {
        int gap = 22 + Math.min(InventoryHUD.HUD_SETTINGS.iconInfoGap, 1);
        int x1 = 3;
        int y1 = 3 - gap;
        for (int i = 0; i < 27; ++i) {
            if (i % 9 == 0) {
                y1 += gap;
                x1 = 3;
            }
            InventoryHUD.SLOT_X_HORIZONTAL[i] = x1;
            InventoryHUD.SLOT_Y_HORIZONTAL[i] = y1;
            x1 += gap;
        }
    }

    private static void preComputeVertical() {
        int gap = 22 + Math.min(InventoryHUD.HUD_SETTINGS.iconInfoGap, 1);
        int x1 = 3 + gap + gap + gap;
        int y1 = 3;
        for (int i = 0; i < 27; ++i) {
            if (i % 9 == 0) {
                y1 = 3;
                x1 -= gap;
            }
            InventoryHUD.SLOT_X_VERTICAL[i] = x1;
            InventoryHUD.SLOT_Y_VERTICAL[i] = y1;
            y1 += gap;
        }
    }

    static {
        InventoryHUD.preComputeHorizontal();
        InventoryHUD.preComputeVertical();
    }
}

