/*
 * Decompiled with CFR 0.152.
 */
package fin.starhud.hud.implementation.other;

import fin.starhud.Helper;
import fin.starhud.Main;
import fin.starhud.config.GeneralSettings;
import fin.starhud.config.hud.TargetedCrosshairSettings;
import fin.starhud.helper.HUDDisplayMode;
import fin.starhud.helper.RenderUtils;
import fin.starhud.hud.AbstractHUD;
import fin.starhud.hud.HUDId;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1473;
import net.minecraft.class_1480;
import net.minecraft.class_1508;
import net.minecraft.class_1510;
import net.minecraft.class_1569;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_5354;
import net.minecraft.class_5481;
import net.minecraft.class_7298;
import net.minecraft.class_7923;

public class TargetedCrosshairHUD
extends AbstractHUD {
    private static final TargetedCrosshairSettings SETTINGS = Main.settings.targetedCrosshairSettings;
    private static final GeneralSettings.HUDSettings HUD_SETTINGS = Main.settings.generalSettings.hudSettings;
    private static final class_2960 ENTITY_ICON_TEXTURE = class_2960.method_60655((String)"starhud", (String)"hud/targeted_icon_entity.png");
    private static final int ICON_WIDTH = 22;
    private static final int ICON_HEIGHT = 22;
    private static final class_310 CLIENT = class_310.method_1551();
    private int width;
    private int height;
    private class_239.class_240 hitResultType;
    private HUDDisplayMode displayMode;
    private class_1799 blockStack;
    private class_2248 cachedBlock = null;
    private class_5481 cachedBlockName = null;
    private String cachedBlockModName = null;
    private int cachedBlockMaxWidth = -1;
    private int targetedNameColor;
    private int modNameColor;
    private class_1297 cachedTargetedEntity = null;
    private class_5481 cachedEntityName = null;
    private String cachedEntityModName = null;
    private int cachedEntityMaxWidth = -1;
    private int cachedIndex = -1;

    public TargetedCrosshairHUD() {
        super(TargetedCrosshairHUD.SETTINGS.base);
    }

    @Override
    public String getName() {
        return "Targeted Crosshair HUD";
    }

    @Override
    public String getId() {
        return HUDId.TARGETED_CROSSHAIR.toString();
    }

    public static boolean isShown() {
        if (!TargetedCrosshairHUD.SETTINGS.base.shouldRender()) {
            return false;
        }
        return TargetedCrosshairHUD.CLIENT.field_1765 != null && TargetedCrosshairHUD.CLIENT.field_1765.method_17783() != class_239.class_240.field_1333;
    }

    @Override
    public boolean collectHUDInformation() {
        if (TargetedCrosshairHUD.CLIENT.field_1765 == null) {
            return false;
        }
        this.hitResultType = TargetedCrosshairHUD.CLIENT.field_1765.method_17783();
        if (this.hitResultType == null) {
            return false;
        }
        return switch (this.hitResultType) {
            case class_239.class_240.field_1332 -> this.collectDataBlock();
            case class_239.class_240.field_1331 -> this.collectDataEntity();
            default -> false;
        };
    }

    public boolean collectDataBlock() {
        this.displayMode = this.getSettings().getDisplayMode();
        if (TargetedCrosshairHUD.CLIENT.field_1687 == null) {
            return false;
        }
        class_239 class_2392 = TargetedCrosshairHUD.CLIENT.field_1765;
        if (!(class_2392 instanceof class_3965)) {
            return false;
        }
        class_3965 blockHitResult = (class_3965)class_2392;
        class_2338 pos = blockHitResult.method_17777();
        class_2680 blockState = TargetedCrosshairHUD.CLIENT.field_1687.method_8320(pos);
        class_2248 block = blockState.method_26204();
        class_1792 blockItem = block.method_8389();
        this.blockStack = blockItem.method_7854();
        if (!block.equals(this.cachedBlock)) {
            this.cachedBlock = block;
            this.cachedBlockName = blockItem == class_1802.field_8162 ? class_2561.method_43471((String)block.method_9539()).method_30937() : this.blockStack.method_7964().method_30937();
            this.cachedBlockModName = Helper.getModName(class_7923.field_41175.method_10221((Object)block));
            int blockNameWidth = TargetedCrosshairHUD.CLIENT.field_1772.method_30880(this.cachedBlockName);
            int modNameWidth = TargetedCrosshairHUD.CLIENT.field_1772.method_1727(this.cachedBlockModName);
            this.cachedBlockMaxWidth = Math.max(modNameWidth, blockNameWidth) - 1;
        }
        this.targetedNameColor = TargetedCrosshairHUD.SETTINGS.targetedNameColor | 0xFF000000;
        this.modNameColor = TargetedCrosshairHUD.SETTINGS.modNameColor | 0xFF000000;
        this.width = this.displayMode.calculateWidth(22, this.cachedBlockMaxWidth);
        this.height = 22;
        this.setWidthHeightColor(this.width, this.height, this.targetedNameColor);
        return this.cachedBlockName != null && this.cachedBlockModName != null;
    }

    public boolean collectDataEntity() {
        this.displayMode = this.getSettings().getDisplayMode();
        class_239 class_2392 = TargetedCrosshairHUD.CLIENT.field_1765;
        if (!(class_2392 instanceof class_3966)) {
            return false;
        }
        class_3966 entityHitResult = (class_3966)class_2392;
        class_1297 targetedEntity = entityHitResult.method_17782();
        if (!targetedEntity.equals((Object)this.cachedTargetedEntity)) {
            this.cachedTargetedEntity = targetedEntity;
            this.cachedEntityName = targetedEntity.method_5477().method_30937();
            this.cachedEntityModName = Helper.getModName(class_7923.field_41177.method_10221((Object)targetedEntity.method_5864()));
            int entityNameWidth = TargetedCrosshairHUD.CLIENT.field_1772.method_30880(this.cachedEntityName);
            int modNameWidth = TargetedCrosshairHUD.CLIENT.field_1772.method_1727(this.cachedEntityModName);
            this.cachedEntityMaxWidth = Math.max(entityNameWidth, modNameWidth) - 1;
            this.cachedIndex = this.getEntityIconIndex(targetedEntity);
        }
        this.width = this.displayMode.calculateWidth(22, this.cachedEntityMaxWidth);
        this.height = 22;
        this.targetedNameColor = this.getEntityIconColor(this.cachedIndex) | 0xFF000000;
        this.modNameColor = TargetedCrosshairHUD.SETTINGS.modNameColor | 0xFF000000;
        this.setWidthHeightColor(this.width, this.height, this.targetedNameColor);
        return this.cachedEntityName != null && this.cachedEntityModName != null;
    }

    @Override
    public boolean renderHUD(class_332 context, int x, int y, boolean drawBackground) {
        if (this.hitResultType == null) {
            return false;
        }
        return switch (this.hitResultType) {
            case class_239.class_240.field_1332 -> this.renderBlockInfoHUD(context, x, y, drawBackground);
            case class_239.class_240.field_1331 -> this.renderEntityInfoHUD(context, x, y, drawBackground);
            default -> false;
        };
    }

    public boolean renderBlockInfoHUD(class_332 context, int x, int y, boolean drawBackground) {
        if (this.displayMode == null || this.cachedBlockName == null || this.cachedBlockModName == null || this.blockStack == null) {
            return false;
        }
        int w = this.getWidth();
        int h = this.getHeight();
        int padding = TargetedCrosshairHUD.HUD_SETTINGS.textPadding;
        int gap = TargetedCrosshairHUD.HUD_SETTINGS.iconInfoGap;
        switch (this.displayMode) {
            case ICON: {
                if (drawBackground) {
                    RenderUtils.fillRounded(context, x, y, x + 22, y + 22, Integer.MIN_VALUE);
                }
                context.method_51427(this.blockStack, x + 3, y + 3);
                break;
            }
            case INFO: {
                if (drawBackground) {
                    RenderUtils.fillRounded(context, x, y, x + w, y + h, Integer.MIN_VALUE);
                }
                RenderUtils.drawTextHUD(context, this.cachedBlockName, x + padding, y + 3, this.targetedNameColor, false);
                RenderUtils.drawTextHUD(context, this.cachedBlockModName, x + padding, y + h - 3 - 7, this.modNameColor, false);
                break;
            }
            case BOTH: {
                if (drawBackground) {
                    if (gap <= 0) {
                        RenderUtils.fillRounded(context, x, y, x + w, y + h, Integer.MIN_VALUE);
                    } else {
                        RenderUtils.fillRoundedLeftSide(context, x, y, x + 22, y + h, Integer.MIN_VALUE);
                        RenderUtils.fillRoundedRightSide(context, x + 22 + gap, y, x + w, y + h, Integer.MIN_VALUE);
                    }
                }
                context.method_51427(this.blockStack, x + 3, y + 3);
                RenderUtils.drawTextHUD(context, this.cachedBlockName, x + 22 + gap + padding, y + 3, TargetedCrosshairHUD.SETTINGS.targetedNameColor | 0xFF000000, false);
                RenderUtils.drawTextHUD(context, this.cachedBlockModName, x + 22 + gap + padding, y + 22 - 3 - 7, TargetedCrosshairHUD.SETTINGS.modNameColor | 0xFF000000, false);
            }
        }
        return true;
    }

    public boolean renderEntityInfoHUD(class_332 context, int x, int y, boolean drawBackground) {
        if (this.displayMode == null || this.cachedEntityName == null || this.cachedEntityModName == null) {
            return false;
        }
        int w = this.getWidth();
        int h = this.getHeight();
        int padding = TargetedCrosshairHUD.HUD_SETTINGS.textPadding;
        int gap = TargetedCrosshairHUD.HUD_SETTINGS.iconInfoGap;
        switch (this.displayMode) {
            case ICON: {
                if (drawBackground) {
                    RenderUtils.fillRounded(context, x, y, x + 22, y + 22, Integer.MIN_VALUE);
                }
                RenderUtils.drawTextureHUD(context, ENTITY_ICON_TEXTURE, x, y, 0.0f, 22 * this.cachedIndex, 22, 22, 22, 110, this.targetedNameColor);
                break;
            }
            case INFO: {
                if (drawBackground) {
                    RenderUtils.fillRounded(context, x, y, x + w, y + h, Integer.MIN_VALUE);
                }
                RenderUtils.drawTextHUD(context, this.cachedEntityName, x + padding, y + 3, this.targetedNameColor, false);
                RenderUtils.drawTextHUD(context, this.cachedEntityModName, x + padding, y + h - 3 - 7, this.modNameColor, false);
                break;
            }
            case BOTH: {
                if (drawBackground) {
                    if (gap <= 0) {
                        RenderUtils.fillRounded(context, x, y, x + w, y + h, Integer.MIN_VALUE);
                    } else {
                        RenderUtils.fillRoundedLeftSide(context, x, y, x + 22, y + h, Integer.MIN_VALUE);
                        RenderUtils.fillRoundedRightSide(context, x + 22 + gap, y, x + w, y + h, Integer.MIN_VALUE);
                    }
                }
                RenderUtils.drawTextureHUD(context, ENTITY_ICON_TEXTURE, x, y, 0.0f, 22 * this.cachedIndex, 22, 22, 22, 110, this.targetedNameColor);
                RenderUtils.drawTextHUD(context, this.cachedEntityName, x + 22 + gap + padding, y + 3, this.targetedNameColor, false);
                RenderUtils.drawTextHUD(context, this.cachedEntityModName, x + 22 + gap + padding, y + 22 - 3 - 7, TargetedCrosshairHUD.SETTINGS.modNameColor | 0xFF000000, false);
            }
        }
        return true;
    }

    private int getEntityIconIndex(class_1297 e) {
        if (TargetedCrosshairHUD.isHostileMob(e)) {
            return 0;
        }
        if (TargetedCrosshairHUD.isAngerableMob(e)) {
            return 1;
        }
        if (TargetedCrosshairHUD.isPassiveMob(e)) {
            return 2;
        }
        if (TargetedCrosshairHUD.isPlayerEntity(e)) {
            return 3;
        }
        return 4;
    }

    private int getEntityIconColor(int index) {
        return switch (index) {
            case 0 -> TargetedCrosshairHUD.SETTINGS.entityColors.hostile;
            case 1 -> TargetedCrosshairHUD.SETTINGS.entityColors.angerable;
            case 2 -> TargetedCrosshairHUD.SETTINGS.entityColors.passive;
            case 3 -> TargetedCrosshairHUD.SETTINGS.entityColors.player;
            default -> TargetedCrosshairHUD.SETTINGS.entityColors.unknown;
        };
    }

    private static boolean isHostileMob(class_1297 e) {
        class_1297 class_12972 = e;
        Objects.requireNonNull(class_12972);
        class_1297 class_12973 = class_12972;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{class_1510.class, class_1508.class, class_1569.class}, (Object)class_12973, n)) {
            case 0 -> {
                class_1510 ignored = (class_1510)class_12973;
                yield true;
            }
            case 1 -> {
                class_1508 ignored = (class_1508)class_12973;
                yield true;
            }
            case 2 -> {
                class_1569 ignored = (class_1569)class_12973;
                yield true;
            }
            default -> false;
        };
    }

    private static boolean isAngerableMob(class_1297 e) {
        return e instanceof class_5354;
    }

    private static boolean isPassiveMob(class_1297 e) {
        class_1297 class_12972 = e;
        Objects.requireNonNull(class_12972);
        class_1297 class_12973 = class_12972;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{class_1296.class, class_1480.class, class_7298.class, class_1473.class}, (Object)class_12973, n)) {
            case 0 -> {
                class_1296 ignored = (class_1296)class_12973;
                yield true;
            }
            case 1 -> {
                class_1480 ignored = (class_1480)class_12973;
                yield true;
            }
            case 2 -> {
                class_7298 ignored = (class_7298)class_12973;
                yield true;
            }
            case 3 -> {
                class_1473 ignored = (class_1473)class_12973;
                yield true;
            }
            default -> false;
        };
    }

    private static boolean isPlayerEntity(class_1297 e) {
        return e instanceof class_1657;
    }
}

