/*
 * Decompiled with CFR 0.152.
 */
package fin.starhud.screen.history;

import fin.starhud.screen.history.HUDAction;
import java.util.ArrayDeque;
import java.util.Deque;

public class HUDHistory {
    private final Deque<HUDAction> undoStack = new ArrayDeque<HUDAction>();
    private final Deque<HUDAction> redoStack = new ArrayDeque<HUDAction>();
    private static final int MAX_HISTORY = 512;

    public void execute(HUDAction action) {
        if (action == null) {
            return;
        }
        action.apply();
        this.commit(action);
    }

    public void commit(HUDAction action) {
        if (action == null) {
            return;
        }
        this.undoStack.push(action);
        this.redoStack.clear();
        while (this.undoStack.size() > 512) {
            this.undoStack.removeLast();
        }
    }

    public void undo() {
        if (!this.canUndo()) {
            return;
        }
        HUDAction action = this.undoStack.pop();
        action.undo();
        this.redoStack.push(action);
    }

    public void redo() {
        if (!this.canRedo()) {
            return;
        }
        HUDAction action = this.redoStack.pop();
        action.apply();
        this.undoStack.push(action);
    }

    public boolean canUndo() {
        return !this.undoStack.isEmpty();
    }

    public boolean canRedo() {
        return !this.redoStack.isEmpty();
    }
}

