/*
 * Decompiled with CFR 0.152.
 */
package fin.starhud.hud;

import fin.starhud.Main;
import fin.starhud.config.GroupedHUDSettings;
import fin.starhud.helper.RenderUtils;
import fin.starhud.hud.AbstractHUD;
import fin.starhud.hud.HUDComponent;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.class_332;
import org.slf4j.Logger;

public class GroupedHUD
extends AbstractHUD {
    private static final Logger LOGGER = Main.LOGGER;
    public GroupedHUDSettings groupSettings;
    public final List<AbstractHUD> huds = new ArrayList<AbstractHUD>();
    private final List<AbstractHUD> renderedHUDs = new ArrayList<AbstractHUD>();
    private final List<Integer> xOffsets = new ArrayList<Integer>();
    private final List<Integer> yOffsets = new ArrayList<Integer>();

    public GroupedHUD(GroupedHUDSettings groupSettings) {
        super(groupSettings.base);
        this.groupSettings = groupSettings;
        ArrayList<String> invalidIds = new ArrayList<String>();
        for (String id : groupSettings.hudIds) {
            AbstractHUD hud = HUDComponent.getInstance().getHUD(id);
            if (hud == null) {
                invalidIds.add(id);
                continue;
            }
            this.huds.add(hud);
            hud.setGroupId(this.groupSettings.id);
        }
        groupSettings.hudIds.removeAll(invalidIds);
    }

    @Override
    public String getName() {
        if (this.huds.isEmpty()) {
            return "Groupped HUD";
        }
        StringBuilder name = new StringBuilder();
        name.append("(");
        for (AbstractHUD hud : this.huds) {
            name.append(hud.getName()).append(',');
        }
        name.deleteCharAt(name.length() - 1).append(')');
        return name.toString();
    }

    @Override
    public boolean collectHUDInformation() {
        this.renderedHUDs.clear();
        this.xOffsets.clear();
        this.yOffsets.clear();
        int width = 0;
        int height = 0;
        int renderedCount = 0;
        for (AbstractHUD hud : this.huds) {
            if (!hud.shouldRender() || !hud.collectHUDInformation()) continue;
            ++renderedCount;
            if (this.groupSettings.alignVertical) {
                height += hud.getHeight();
                width = Math.max(width, hud.getWidth());
            } else {
                width += hud.getWidth();
                height = Math.max(height, hud.getHeight());
            }
            this.renderedHUDs.add(hud);
        }
        if (renderedCount > 0) {
            if (this.groupSettings.alignVertical) {
                height += this.groupSettings.gap * (renderedCount - 1);
            } else {
                width += this.groupSettings.gap * (renderedCount - 1);
            }
        } else {
            return false;
        }
        switch (this.groupSettings.childOrdering) {
            case WIDTH_ASCENDING: {
                this.renderedHUDs.sort(Comparator.comparingInt(AbstractHUD::getWidth));
                break;
            }
            case WIDTH_DESCENDING: {
                this.renderedHUDs.sort(Comparator.comparingInt(AbstractHUD::getWidth).reversed());
                break;
            }
            case HEIGHT_ASCENDING: {
                this.renderedHUDs.sort(Comparator.comparingInt(AbstractHUD::getHeight));
                break;
            }
            case HEIGHT_DESCENDING: {
                this.renderedHUDs.sort(Comparator.comparingInt(AbstractHUD::getHeight).reversed());
            }
        }
        int xOffset = 0;
        int yOffset = 0;
        for (AbstractHUD hud : this.renderedHUDs) {
            if (this.groupSettings.alignVertical) {
                xOffset = this.getAlignmentOffset(hud, width - hud.getWidth());
                this.xOffsets.add(xOffset);
                this.yOffsets.add(yOffset);
                yOffset += hud.getHeight() + this.groupSettings.gap;
                continue;
            }
            yOffset = this.getAlignmentOffset(hud, height - hud.getHeight());
            this.xOffsets.add(xOffset);
            this.yOffsets.add(yOffset);
            xOffset += hud.getWidth() + this.groupSettings.gap;
        }
        this.setWidthHeight(width, height);
        return true;
    }

    @Override
    public boolean renderHUD(class_332 context, int x, int y, boolean drawBackground) {
        return this.renderHUD(context, x, y, drawBackground, false);
    }

    public boolean renderHUD(class_332 context, int x, int y, boolean drawBackground, boolean parentDrewBackground) {
        int w = this.getWidth();
        int h = this.getHeight();
        int size = this.renderedHUDs.size();
        boolean drewBackground = false;
        if (!parentDrewBackground && drawBackground) {
            RenderUtils.fillRounded(context, x, y, x + w, y + h, Integer.MIN_VALUE);
            drewBackground = true;
        }
        boolean thisDrewBackground = parentDrewBackground || drewBackground;
        for (int i = 0; i < size; ++i) {
            AbstractHUD hud = this.renderedHUDs.get(i);
            int xOffset = this.xOffsets.get(i);
            int yOffset = this.yOffsets.get(i);
            boolean childShouldDrawBackground = !thisDrewBackground && hud.shouldDrawBackground();
            hud.setXY(x + xOffset, y + yOffset);
            hud.setScale(this.getScale());
            if (hud instanceof GroupedHUD) {
                GroupedHUD group = (GroupedHUD)hud;
                group.renderHUD(context, hud.getX(), hud.getY(), childShouldDrawBackground, thisDrewBackground);
                continue;
            }
            hud.renderHUD(context, hud.getX(), hud.getY(), childShouldDrawBackground);
        }
        return true;
    }

    @Override
    public String getId() {
        return this.groupSettings.id;
    }

    @Override
    public void update() {
        super.update();
        for (AbstractHUD hud : this.huds) {
            if (hud.isInGroup()) continue;
            LOGGER.warn("{} IS NOT IN A GROUP! FORCING TO CHANGE THEM.", (Object)hud.getName());
            hud.setGroupId(this.groupSettings.id);
        }
        this.getBoundingBox().setColor(this.groupSettings.boxColor | 0xFF000000);
    }

    public int getAlignmentOffset(AbstractHUD childHUD, int length) {
        return switch (this.groupSettings.getChildAlignment()) {
            default -> throw new IncompatibleClassChangeError();
            case GroupedHUDSettings.ChildAlignment.GROUP -> {
                if (this.groupSettings.alignVertical) {
                    yield this.getSettings().getOriginX().getAlignmentPos(length);
                }
                yield this.getSettings().getOriginY().getAlignmentPos(length);
            }
            case GroupedHUDSettings.ChildAlignment.CHILD -> {
                if (this.groupSettings.alignVertical) {
                    yield childHUD.getSettings().getOriginX().getAlignmentPos(length);
                }
                yield childHUD.getSettings().getOriginY().getAlignmentPos(length);
            }
            case GroupedHUDSettings.ChildAlignment.START -> 0;
            case GroupedHUDSettings.ChildAlignment.CENTER -> length / 2;
            case GroupedHUDSettings.ChildAlignment.END -> length;
        };
    }

    public void updateActiveHUDsFromConfig() {
        for (AbstractHUD hud : this.huds) {
            hud.setGroupId(null);
        }
        this.huds.clear();
        for (String id : this.groupSettings.hudIds) {
            AbstractHUD hud = HUDComponent.getInstance().getHUD(id);
            this.huds.add(hud);
            hud.setGroupId(this.groupSettings.id);
        }
    }
}

