/*
 * Decompiled with CFR 0.152.
 */
package fin.starhud.hud.implementation;

import fin.starhud.Helper;
import fin.starhud.Main;
import fin.starhud.config.BaseHUDSettings;
import fin.starhud.config.GeneralSettings;
import fin.starhud.config.hud.DurabilitySettings;
import fin.starhud.helper.HUDDisplayMode;
import fin.starhud.helper.RenderUtils;
import fin.starhud.hud.AbstractHUD;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;

public abstract class AbstractDurabilityHUD
extends AbstractHUD {
    protected final DurabilitySettings durabilitySettings;
    private static final GeneralSettings.HUDSettings HUD_SETTINGS = Main.settings.generalSettings.hudSettings;
    private static final class_2960 BIG_DURABILITY_BACKGROUND_TEXTURE = class_2960.method_43902((String)"starhud", (String)"hud/big_durability_background.png");
    private static final class_2960 BIG_DURABILITY_TEXTURE = class_2960.method_43902((String)"starhud", (String)"hud/big_durability_bar.png");
    private static final int BIG_DURABILITY_TEXTURE_WIDTH = 70;
    private static final int BIG_DURABILITY_TEXTURE_HEIGHT = 14;
    private static final class_2960 DURABILITY_BACKGROUND_TEXTURE = class_2960.method_43902((String)"starhud", (String)"hud/durability_background.png");
    private static final class_2960 DURABILITY_TEXTURE = class_2960.method_43902((String)"starhud", (String)"hud/durability_bar.png");
    private static final int DURABILITY_TEXTURE_WIDTH = 40;
    private static final int DURABILITY_TEXTURE_HEIGHT = 7;
    private static final int ITEM_BACKGROUND_WIDTH = 22;
    private static final int ITEM_BACKGROUND_HEIGHT = 22;
    private static final int ICON_BACKGROUND_WIDTH = 13;
    private static final int ICON_BACKGROUND_HEIGHT = 13;
    private static final class_310 CLIENT = class_310.method_1551();
    private class_1799 stack;
    private int stackDamage = 0;
    private int stackMaxDamage = 0;
    private String str = null;
    private String str2 = null;
    private int durabilityColor;
    private int iconColor;
    private int step;
    private int remainingTextWidth;
    private DurabilitySettings.DisplayMode displayMode = null;
    private boolean drawItem;
    private HUDDisplayMode hudDisplayMode = null;

    public AbstractDurabilityHUD(BaseHUDSettings baseHUDSettings, DurabilitySettings durabilitySettings) {
        super(baseHUDSettings);
        this.durabilitySettings = durabilitySettings;
    }

    public abstract class_1799 getStack();

    public abstract int getIconColor();

    @Override
    public boolean collectHUDInformation() {
        this.stack = this.getStack();
        if (this.stack.method_7960() || !this.stack.method_7963()) {
            return false;
        }
        this.stackDamage = this.stack.method_7919();
        this.stackMaxDamage = this.stack.method_7936();
        this.hudDisplayMode = this.getSettings().getDisplayMode();
        this.displayMode = this.durabilitySettings.getDisplayMode();
        this.drawItem = this.durabilitySettings.drawItem;
        this.iconColor = this.getIconColor();
        int width = this.processWidth();
        int height = this.drawItem ? 22 : 13;
        this.durabilityColor = Helper.getItemBarColor(this.stackMaxDamage - this.stackDamage, this.stackMaxDamage) | 0xFF000000;
        this.setWidthHeightColor(width, height, this.iconColor);
        return true;
    }

    public int processWidth() {
        if (this.drawItem) {
            return this.processWidthItem();
        }
        return this.processWidthIcon();
    }

    public int processWidthItem() {
        return switch (this.displayMode) {
            default -> throw new IncompatibleClassChangeError();
            case DurabilitySettings.DisplayMode.BAR -> this.processWidthItemBar();
            case DurabilitySettings.DisplayMode.FRACTIONAL -> this.processWidthItemFractional();
            case DurabilitySettings.DisplayMode.VALUE_ONLY -> this.processWidthItemValue();
            case DurabilitySettings.DisplayMode.PERCENTAGE -> this.processWidthItemPercentage();
            case DurabilitySettings.DisplayMode.COMPACT -> this.processWidthItemCompact();
        };
    }

    public int processWidthItemBar() {
        this.step = AbstractDurabilityHUD.getItemBarStep(this.stackDamage, this.stackMaxDamage, 10);
        this.durabilityColor = Helper.getItemBarColor(this.step, 10) | 0xFF000000;
        return this.hudDisplayMode.calculateWidth(22, 69);
    }

    public int processWidthItemFractional() {
        int damage = this.stackDamage;
        int maxDamage = this.stackMaxDamage;
        int remaining = maxDamage - damage;
        this.str = remaining + "/" + maxDamage;
        this.step = AbstractDurabilityHUD.getItemBarStep(this.stackDamage, this.stackMaxDamage, 10);
        int strWidth = AbstractDurabilityHUD.CLIENT.field_1772.method_1727(this.str);
        return this.hudDisplayMode.calculateWidth(22, strWidth);
    }

    public int processWidthItemValue() {
        int remaining = this.stackMaxDamage - this.stackDamage;
        this.str = Integer.toString(remaining);
        int strWidth = AbstractDurabilityHUD.CLIENT.field_1772.method_1727(this.str) - 1;
        return this.hudDisplayMode.calculateWidth(22, strWidth);
    }

    public int processWidthItemPercentage() {
        int remaining = this.stackMaxDamage - this.stackDamage;
        int percentage = remaining * 100 / this.stackMaxDamage;
        this.str = percentage + "%";
        int strWidth = AbstractDurabilityHUD.CLIENT.field_1772.method_1727(this.str) - 1;
        return this.hudDisplayMode.calculateWidth(22, strWidth);
    }

    public int processWidthItemCompact() {
        return 22;
    }

    public int processWidthIcon() {
        return switch (this.displayMode) {
            default -> throw new IncompatibleClassChangeError();
            case DurabilitySettings.DisplayMode.BAR -> this.processWidthIconBar();
            case DurabilitySettings.DisplayMode.FRACTIONAL -> this.processWidthIconFractional();
            case DurabilitySettings.DisplayMode.VALUE_ONLY -> this.processWidthIconValue();
            case DurabilitySettings.DisplayMode.PERCENTAGE -> this.processWidthIconPercentage();
            case DurabilitySettings.DisplayMode.COMPACT -> this.processWidthIconCompact();
        };
    }

    public int processWidthIconBar() {
        this.step = AbstractDurabilityHUD.getItemBarStep(this.stackDamage, this.stackMaxDamage, 10);
        return this.hudDisplayMode.calculateWidth(13, 39);
    }

    public int processWidthIconFractional() {
        int damage = this.stackDamage;
        int maxDamage = this.stackMaxDamage;
        int remaining = maxDamage - damage;
        this.str = Helper.toSuperscript(Integer.toString(remaining)) + "/";
        this.str2 = Helper.toSubscript(Integer.toString(maxDamage));
        this.step = AbstractDurabilityHUD.getItemBarStep(this.stackDamage, this.stackMaxDamage, 10);
        this.remainingTextWidth = AbstractDurabilityHUD.CLIENT.field_1772.method_1727(this.str);
        int totalTextWidth = this.remainingTextWidth + AbstractDurabilityHUD.CLIENT.field_1772.method_1727(this.str2) - 1;
        return this.hudDisplayMode.calculateWidth(13, totalTextWidth);
    }

    public int processWidthIconValue() {
        int remaining = this.stackMaxDamage - this.stackDamage;
        this.str = Integer.toString(remaining);
        int strWidth = AbstractDurabilityHUD.CLIENT.field_1772.method_1727(this.str) - 1;
        return this.hudDisplayMode.calculateWidth(13, strWidth);
    }

    public int processWidthIconPercentage() {
        int remainingDamage = this.stackMaxDamage - this.stackDamage;
        int percentage = remainingDamage * 100 / this.stackMaxDamage;
        this.str = percentage + "%";
        int strWidth = AbstractDurabilityHUD.CLIENT.field_1772.method_1727(this.str) - 1;
        return this.hudDisplayMode.calculateWidth(13, strWidth);
    }

    public int processWidthIconCompact() {
        this.step = AbstractDurabilityHUD.getItemBarStep(this.stackDamage, this.stackMaxDamage, 9);
        return 13;
    }

    public static int getItemBarStep(int stackDamage, int stackMaxDamage, int maxStep) {
        return class_3532.method_15340((int)Math.round((float)maxStep - (float)stackDamage * (float)maxStep / (float)stackMaxDamage), (int)0, (int)maxStep);
    }

    public boolean renderDurabilityHUD(class_332 context, class_2960 iconTexture, int x, int y, float u, float v, int textureWidth, int textureHeight, int iconWidth, int iconHeight, boolean drawBackground) {
        if (this.drawItem) {
            return this.renderDurabilityItem(context, x, y, drawBackground);
        }
        return this.renderDurabilityIcon(context, iconTexture, x, y, u, v, textureWidth, textureHeight, iconWidth, iconHeight, drawBackground);
    }

    public boolean renderDurabilityItem(class_332 context, int x, int y, boolean drawBackground) {
        if (this.displayMode == null) {
            return false;
        }
        return switch (this.displayMode) {
            default -> throw new IncompatibleClassChangeError();
            case DurabilitySettings.DisplayMode.FRACTIONAL, DurabilitySettings.DisplayMode.VALUE_ONLY, DurabilitySettings.DisplayMode.PERCENTAGE -> RenderUtils.drawItemHUD(context, this.str, x, y, this.getWidth(), this.getHeight(), this.stack, this.durabilityColor, this.hudDisplayMode, drawBackground);
            case DurabilitySettings.DisplayMode.BAR -> this.renderDurabilityItemBar(context, x, y, drawBackground);
            case DurabilitySettings.DisplayMode.COMPACT -> this.renderDurabilityItemCompact(context, x, y, drawBackground);
        };
    }

    public boolean renderDurabilityItemBar(class_332 context, int x, int y, boolean drawBackground) {
        if (this.stack == null) {
            return false;
        }
        int w = this.getWidth();
        int h = this.getHeight();
        int padding = AbstractDurabilityHUD.HUD_SETTINGS.textPadding;
        int gap = AbstractDurabilityHUD.HUD_SETTINGS.iconInfoGap;
        switch (this.hudDisplayMode) {
            case ICON: {
                if (drawBackground) {
                    RenderUtils.fillRounded(context, x, y, x + w, y + h, Integer.MIN_VALUE);
                }
                context.method_51427(this.stack, x + 3, y + 3);
                break;
            }
            case INFO: {
                if (drawBackground) {
                    RenderUtils.fillRounded(context, x, y, x + w, y + h, Integer.MIN_VALUE);
                }
                RenderUtils.drawTextureHUD(context, BIG_DURABILITY_BACKGROUND_TEXTURE, x + padding, y + 4, 0.0f, 0.0f, 70, 14, 70, 14);
                if (this.step == 0) break;
                RenderUtils.drawTextureHUD(context, BIG_DURABILITY_TEXTURE, x + padding, y + 4, 0.0f, 0.0f, this.step * 7, 14, 70, 14, this.durabilityColor);
                break;
            }
            case BOTH: {
                if (drawBackground) {
                    if (gap <= 0) {
                        RenderUtils.fillRounded(context, x, y, x + w, y + h, Integer.MIN_VALUE);
                    } else {
                        RenderUtils.fillRoundedLeftSide(context, x, y, x + 22, y + h, Integer.MIN_VALUE);
                        RenderUtils.fillRoundedRightSide(context, x + 22 + gap, y, x + w, y + h, Integer.MIN_VALUE);
                    }
                }
                context.method_51427(this.stack, x + 3, y + 3);
                RenderUtils.drawTextureHUD(context, BIG_DURABILITY_BACKGROUND_TEXTURE, x + 22 + gap + padding, y + 4, 0.0f, 0.0f, 70, 14, 70, 14);
                if (this.step == 0) break;
                RenderUtils.drawTextureHUD(context, BIG_DURABILITY_TEXTURE, x + 22 + gap + padding, y + 4, 0.0f, 0.0f, this.step * 7, 14, 70, 14, this.durabilityColor);
            }
        }
        return true;
    }

    public boolean renderDurabilityItemCompact(class_332 context, int x, int y, boolean drawBackground) {
        if (this.stack == null || this.hudDisplayMode == null) {
            return false;
        }
        if (drawBackground) {
            RenderUtils.fillRounded(context, x, y, x + this.getWidth(), y + this.getHeight(), Integer.MIN_VALUE);
        }
        if (this.hudDisplayMode != HUDDisplayMode.INFO) {
            context.method_51427(this.stack, x + 3, y + 3);
        }
        if (this.hudDisplayMode != HUDDisplayMode.ICON) {
            context.method_51431(AbstractDurabilityHUD.CLIENT.field_1772, this.stack, x + 3, y + 3);
        }
        return true;
    }

    public boolean renderDurabilityIcon(class_332 context, class_2960 ICON, int x, int y, float u, float v, int textureWidth, int textureHeight, int iconWidth, int iconHeight, boolean drawBackground) {
        if (this.displayMode == null) {
            return false;
        }
        return switch (this.displayMode) {
            default -> throw new IncompatibleClassChangeError();
            case DurabilitySettings.DisplayMode.FRACTIONAL -> this.renderDurabilityIconFractional(context, ICON, x, y, u, v, textureWidth, textureHeight, iconWidth, iconHeight, drawBackground);
            case DurabilitySettings.DisplayMode.BAR -> this.renderDurabilityIconBar(context, ICON, x, y, u, v, textureWidth, textureHeight, iconWidth, iconHeight, drawBackground);
            case DurabilitySettings.DisplayMode.VALUE_ONLY, DurabilitySettings.DisplayMode.PERCENTAGE -> RenderUtils.drawSmallHUD(context, this.str, x, y, this.getWidth(), this.getHeight(), ICON, u, v, textureWidth, textureHeight, iconWidth, iconHeight, this.durabilityColor, this.iconColor, this.hudDisplayMode, drawBackground);
            case DurabilitySettings.DisplayMode.COMPACT -> this.renderDurabilityIconCompact(context, ICON, x, y, u, v, textureWidth, textureHeight, iconWidth, iconHeight, drawBackground);
        };
    }

    public boolean renderDurabilityIconBar(class_332 context, class_2960 ICON, int x, int y, float u, float v, int textureWidth, int textureHeight, int iconWidth, int iconHeight, boolean drawBackground) {
        if (ICON == null || this.hudDisplayMode == null) {
            return false;
        }
        int w = this.getWidth();
        int h = this.getHeight();
        int padding = AbstractDurabilityHUD.HUD_SETTINGS.textPadding;
        int gap = AbstractDurabilityHUD.HUD_SETTINGS.iconInfoGap;
        switch (this.hudDisplayMode) {
            case ICON: {
                if (drawBackground) {
                    RenderUtils.fillRounded(context, x, y, x + iconWidth, y + iconHeight, Integer.MIN_VALUE);
                }
                RenderUtils.drawTextureHUD(context, ICON, x, y, u, v, iconWidth, iconHeight, textureWidth, textureHeight, this.iconColor);
                break;
            }
            case INFO: {
                if (drawBackground) {
                    RenderUtils.fillRounded(context, x, y, x + w, y + h, Integer.MIN_VALUE);
                }
                RenderUtils.drawTextureHUD(context, DURABILITY_BACKGROUND_TEXTURE, x + padding, y + 3, 0.0f, 0.0f, 40, 7, 40, 7);
                if (this.step == 0) break;
                RenderUtils.drawTextureHUD(context, DURABILITY_TEXTURE, x + padding, y + 3, 0.0f, 0.0f, 4 * this.step, 7, 40, 7, this.durabilityColor);
                break;
            }
            case BOTH: {
                if (drawBackground) {
                    if (gap <= 0) {
                        RenderUtils.fillRounded(context, x, y, x + w, y + h, Integer.MIN_VALUE);
                    } else {
                        RenderUtils.fillRoundedLeftSide(context, x, y, x + iconWidth, y + h, Integer.MIN_VALUE);
                        RenderUtils.fillRoundedRightSide(context, x + iconWidth + gap, y, x + w, y + h, Integer.MIN_VALUE);
                    }
                }
                RenderUtils.drawTextureHUD(context, ICON, x, y, u, v, iconWidth, iconHeight, textureWidth, textureHeight, this.iconColor);
                RenderUtils.drawTextureHUD(context, DURABILITY_BACKGROUND_TEXTURE, x + iconWidth + gap + padding, y + 3, 0.0f, 0.0f, 40, 7, 40, 7);
                if (this.step == 0) break;
                RenderUtils.drawTextureHUD(context, DURABILITY_TEXTURE, x + iconWidth + gap + padding, y + 3, 0.0f, 0.0f, 4 * this.step, 7, 40, 7, this.durabilityColor);
            }
        }
        return true;
    }

    public boolean renderDurabilityIconFractional(class_332 context, class_2960 ICON, int x, int y, float u, float v, int textureWidth, int textureHeight, int iconWidth, int iconHeight, boolean drawBackground) {
        if (ICON == null || this.str == null || this.str2 == null || this.hudDisplayMode == null) {
            return false;
        }
        int w = this.getWidth();
        int h = this.getHeight();
        int padding = AbstractDurabilityHUD.HUD_SETTINGS.textPadding;
        int gap = AbstractDurabilityHUD.HUD_SETTINGS.iconInfoGap;
        switch (this.hudDisplayMode) {
            case ICON: {
                if (drawBackground) {
                    RenderUtils.fillRounded(context, x, y, x + iconWidth, y + iconHeight, Integer.MIN_VALUE);
                }
                RenderUtils.drawTextureHUD(context, ICON, x, y, u, v, iconWidth, iconHeight, textureWidth, textureHeight, this.iconColor);
                break;
            }
            case INFO: {
                if (drawBackground) {
                    RenderUtils.fillRounded(context, x, y, x + w, y + h, Integer.MIN_VALUE);
                }
                RenderUtils.drawTextHUD(context, this.str, x + padding, y + 3, this.durabilityColor, false);
                RenderUtils.drawTextHUD(context, this.str2, x + padding + this.remainingTextWidth, y + 3 - 1, this.durabilityColor, false);
                break;
            }
            case BOTH: {
                if (drawBackground) {
                    if (gap <= 0) {
                        RenderUtils.fillRounded(context, x, y, x + w, y + h, Integer.MIN_VALUE);
                    } else {
                        RenderUtils.fillRoundedLeftSide(context, x, y, x + iconWidth, y + h, Integer.MIN_VALUE);
                        RenderUtils.fillRoundedRightSide(context, x + iconWidth + gap, y, x + w, y + h, Integer.MIN_VALUE);
                    }
                }
                RenderUtils.drawTextureHUD(context, ICON, x, y, u, v, iconWidth, iconHeight, textureWidth, textureHeight, this.iconColor);
                RenderUtils.drawTextHUD(context, this.str, x + iconWidth + gap + padding, y + 3, this.durabilityColor, false);
                RenderUtils.drawTextHUD(context, this.str2, x + iconWidth + gap + padding + this.remainingTextWidth, y + 3 - 1, this.durabilityColor, false);
            }
        }
        return true;
    }

    public boolean renderDurabilityIconCompact(class_332 context, class_2960 ICON, int x, int y, float u, float v, int textureWidth, int textureHeight, int iconWidth, int iconHeight, boolean drawBackground) {
        if (ICON == null || this.hudDisplayMode == null) {
            return false;
        }
        if (drawBackground) {
            RenderUtils.fillRounded(context, x, y, x + iconWidth, y + iconHeight, Integer.MIN_VALUE);
        }
        if (this.hudDisplayMode != HUDDisplayMode.INFO) {
            RenderUtils.drawTextureHUD(context, ICON, x, y, u, v, iconWidth, iconHeight, textureWidth, textureHeight, this.iconColor);
        }
        if (this.hudDisplayMode != HUDDisplayMode.ICON) {
            int durabilityWidth = 9;
            int firstX = x + (iconWidth - durabilityWidth) / 2;
            int firstY = y + iconHeight - 2;
            context.method_25294(firstX, firstY, firstX + durabilityWidth, firstY + 1, Integer.MIN_VALUE);
            context.method_25294(firstX, firstY, firstX + this.step, firstY + 1, this.durabilityColor);
        }
        return true;
    }
}

