/*
 * Decompiled with CFR 0.152.
 */
package fin.starhud.hud.implementation.clock;

import fin.starhud.Helper;
import fin.starhud.Main;
import fin.starhud.config.hud.ClockInGameSettings;
import fin.starhud.helper.HUDDisplayMode;
import fin.starhud.helper.RenderUtils;
import fin.starhud.hud.AbstractHUD;
import fin.starhud.hud.HUDId;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_638;

public class ClockInGameHUD
extends AbstractHUD {
    private static final ClockInGameSettings CLOCK_IN_GAME_SETTINGS = Main.settings.clockSettings.inGameSetting;
    private static final class_2960 CLOCK_IN_GAME_TEXTURE = class_2960.method_43902((String)"starhud", (String)"hud/clock_ingame.png");
    private static final int TEXTURE_WIDTH = 13;
    private static final int TEXTURE_HEIGHT = 52;
    private static final int ICON_WIDTH = 13;
    private static final int ICON_HEIGHT = 13;
    private static String cachedMinecraftTimeString = "";
    private static int cachedMinecraftMinute = -1;
    private static int cachedMinecraftHours = -1;
    private static int cachedStrWidth = -1;
    private static final class_310 CLIENT = class_310.method_1551();
    private int color;
    private int iconIndex;
    private HUDDisplayMode displayMode;

    public ClockInGameHUD() {
        super(ClockInGameHUD.CLOCK_IN_GAME_SETTINGS.base);
    }

    @Override
    public String getName() {
        return "Clock In-Game HUD";
    }

    @Override
    public String getId() {
        return HUDId.CLOCK_INGAME.toString();
    }

    @Override
    public boolean collectHUDInformation() {
        class_638 world = ClockInGameHUD.CLIENT.field_1687;
        if (world == null) {
            return false;
        }
        long time = world.method_8532() % 24000L;
        boolean use12Hour = ClockInGameHUD.CLOCK_IN_GAME_SETTINGS.use12Hour;
        this.displayMode = this.getSettings().getDisplayMode();
        int minutes = (int)(time % 1000L * 3L / 50L);
        int hours = (int)(time / 1000L + 6L) % 24;
        if (minutes != cachedMinecraftMinute || hours != cachedMinecraftHours) {
            cachedMinecraftMinute = minutes;
            cachedMinecraftHours = hours;
            cachedMinecraftTimeString = use12Hour ? Helper.buildMinecraftTime12String(hours, minutes) : Helper.buildMinecraftTime24String(hours, minutes);
            cachedStrWidth = ClockInGameHUD.CLIENT.field_1772.method_1727(cachedMinecraftTimeString) - 1;
        }
        this.iconIndex = ClockInGameHUD.getWeatherOrTime(world);
        this.color = ClockInGameHUD.getIconColor(this.iconIndex) | 0xFF000000;
        int width = this.displayMode.calculateWidth(13, cachedStrWidth);
        this.setWidthHeightColor(width, 13, this.color);
        return cachedMinecraftTimeString != null;
    }

    @Override
    public boolean renderHUD(class_332 context, int x, int y, boolean drawBackground) {
        int w = this.getWidth();
        int h = this.getHeight();
        return RenderUtils.drawSmallHUD(context, cachedMinecraftTimeString, x, y, w, h, CLOCK_IN_GAME_TEXTURE, 0.0f, (float)(13 * this.iconIndex), 13, 52, 13, 13, this.color, this.displayMode, drawBackground);
    }

    private static int getIconColor(int icon) {
        return switch (icon) {
            case 0 -> ClockInGameHUD.CLOCK_IN_GAME_SETTINGS.color.day;
            case 1 -> ClockInGameHUD.CLOCK_IN_GAME_SETTINGS.color.night;
            case 2 -> ClockInGameHUD.CLOCK_IN_GAME_SETTINGS.color.rain;
            case 3 -> ClockInGameHUD.CLOCK_IN_GAME_SETTINGS.color.thunder;
            default -> 0xFFFFFF;
        };
    }

    private static int getWeatherOrTime(class_638 clientWorld) {
        if (clientWorld.method_8546()) {
            return 3;
        }
        if (clientWorld.method_8419()) {
            return 2;
        }
        if (clientWorld.method_23886()) {
            return 1;
        }
        return 0;
    }

    @Override
    public void update() {
        super.update();
        cachedMinecraftMinute = -1;
        cachedMinecraftHours = -1;
    }
}

