/*
 * Decompiled with CFR 0.152.
 */
package fin.starhud.hud.implementation.clock;

import fin.starhud.Main;
import fin.starhud.config.hud.ClockSystemSettings;
import fin.starhud.helper.HUDDisplayMode;
import fin.starhud.helper.RenderUtils;
import fin.starhud.hud.AbstractHUD;
import fin.starhud.hud.HUDId;
import java.text.SimpleDateFormat;
import java.util.Date;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;

public class ClockSystemHUD
extends AbstractHUD {
    private static final ClockSystemSettings CLOCK_SYSTEM_SETTINGS = Main.settings.clockSettings.systemSetting;
    private static final class_310 CLIENT = class_310.method_1551();
    private static final class_2960 CLOCK_SYSTEM_TEXTURE = class_2960.method_43902((String)"starhud", (String)"hud/clock_system.png");
    private static final int TEXTURE_WIDTH = 13;
    private static final int TEXTURE_HEIGHT = 13;
    private static final int ICON_WIDTH = 13;
    private static final int ICON_HEIGHT = 13;
    private static final SimpleDateFormat CLOCK_24_FORMAT = new SimpleDateFormat("HH:mm");
    private static final SimpleDateFormat CLOCK_12_FORMAT = new SimpleDateFormat("hh:mm a");
    private static String cachedSystemTimeString = ClockSystemHUD.buildSystemTime24String(System.currentTimeMillis());
    private static long cachedSystemMinute = -1L;
    private static int cachedStrWidth = -1;
    private int color;
    private HUDDisplayMode displayMode;

    public ClockSystemHUD() {
        super(ClockSystemHUD.CLOCK_SYSTEM_SETTINGS.base);
    }

    @Override
    public String getName() {
        return "Clock System HUD";
    }

    @Override
    public String getId() {
        return HUDId.CLOCK_SYSTEM.toString();
    }

    @Override
    public boolean collectHUDInformation() {
        long currentTime = System.currentTimeMillis();
        long minute = currentTime / 60000L;
        boolean use12Hour = ClockSystemHUD.CLOCK_SYSTEM_SETTINGS.use12Hour;
        if (minute != cachedSystemMinute) {
            cachedSystemMinute = minute;
            cachedSystemTimeString = use12Hour ? ClockSystemHUD.buildSystemTime12String(currentTime).toUpperCase() : ClockSystemHUD.buildSystemTime24String(currentTime);
            cachedStrWidth = ClockSystemHUD.CLIENT.field_1772.method_1727(cachedSystemTimeString) - 1;
        }
        this.displayMode = this.getSettings().getDisplayMode();
        this.color = ClockSystemHUD.CLOCK_SYSTEM_SETTINGS.color | 0xFF000000;
        int width = this.displayMode.calculateWidth(13, cachedStrWidth);
        this.setWidthHeightColor(width, 13, this.color);
        return cachedSystemTimeString != null;
    }

    @Override
    public boolean renderHUD(class_332 context, int x, int y, boolean drawBackground) {
        int w = this.getWidth();
        int h = this.getHeight();
        return RenderUtils.drawSmallHUD(context, cachedSystemTimeString, x, y, w, h, CLOCK_SYSTEM_TEXTURE, 0.0f, 0.0f, 13, 13, 13, 13, this.color, this.displayMode, drawBackground);
    }

    private static String buildSystemTime24String(long time) {
        return CLOCK_24_FORMAT.format(new Date(time));
    }

    private static String buildSystemTime12String(long time) {
        return CLOCK_12_FORMAT.format(new Date(time));
    }

    @Override
    public void update() {
        super.update();
        cachedSystemMinute = -1L;
    }
}

