/*
 * Decompiled with CFR 0.152.
 */
package fin.starhud.hud.implementation.other;

import fin.starhud.Helper;
import fin.starhud.Main;
import fin.starhud.config.hud.PingSettings;
import fin.starhud.helper.HUDDisplayMode;
import fin.starhud.helper.RenderUtils;
import fin.starhud.hud.AbstractHUD;
import fin.starhud.hud.HUDId;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_634;
import net.minecraft.class_640;

public class PingHUD
extends AbstractHUD {
    private static final PingSettings SETTINGS = Main.settings.pingSettings;
    private static final class_2960 PING_TEXTURE = class_2960.method_43902((String)"starhud", (String)"hud/ping.png");
    private static final int TEXTURE_WIDTH = 13;
    private static final int TEXTURE_HEIGHT = 52;
    private static final int ICON_WIDTH = 13;
    private static final int ICON_HEIGHT = 13;
    private static final class_310 CLIENT = class_310.method_1551();
    private String pingStr;
    private int strWidth;
    private int color;
    private int step;
    private HUDDisplayMode displayMode;

    public PingHUD() {
        super(PingHUD.SETTINGS.base);
    }

    @Override
    public String getName() {
        return "Ping HUD";
    }

    @Override
    public String getId() {
        return HUDId.PING.toString();
    }

    @Override
    public boolean collectHUDInformation() {
        this.displayMode = this.getSettings().getDisplayMode();
        class_634 networkHandler = CLIENT.method_1562();
        if (networkHandler == null) {
            return false;
        }
        class_640 playerListEntry = networkHandler.method_2871(PingHUD.CLIENT.field_1724.method_5667());
        if (playerListEntry == null) {
            return false;
        }
        int currentPing = playerListEntry.method_2959();
        this.pingStr = currentPing + " ms";
        this.strWidth = PingHUD.CLIENT.field_1772.method_1727(this.pingStr) - 1;
        this.step = Math.min(currentPing / 150, 3);
        this.color = (PingHUD.SETTINGS.useDynamicColor ? Helper.getItemBarColor(3 - this.step, 3) : PingHUD.SETTINGS.color) | 0xFF000000;
        int width = this.displayMode.calculateWidth(13, this.strWidth);
        int height = 13;
        this.setWidthHeightColor(width, height, this.color);
        return this.pingStr != null;
    }

    @Override
    public boolean renderHUD(class_332 context, int x, int y, boolean drawBackground) {
        int w = this.getWidth();
        int h = this.getHeight();
        return RenderUtils.drawSmallHUD(context, this.pingStr, x, y, w, h, PING_TEXTURE, 0.0f, (float)(13 * this.step), 13, 52, 13, 13, this.color, this.displayMode, drawBackground);
    }
}

