/*
 * Decompiled with CFR 0.152.
 */
package fin.starhud.hud.implementation.other;

import fin.starhud.Main;
import fin.starhud.config.hud.PlayerCountSettings;
import fin.starhud.helper.HUDDisplayMode;
import fin.starhud.helper.RenderUtils;
import fin.starhud.hud.AbstractHUD;
import fin.starhud.hud.HUDId;
import java.util.Collection;
import net.minecraft.class_1132;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_642;

public class PlayerCountHUD
extends AbstractHUD {
    private static final class_310 CLIENT = class_310.method_1551();
    private static final PlayerCountSettings SETTINGS = Main.settings.playerCountSettings;
    private static final class_2960 TEXTURE = class_2960.method_43902((String)"starhud", (String)"hud/player_count.png");
    private static final int TEXTURE_WIDTH = 13;
    private static final int TEXTURE_HEIGHT = 13;
    private static final int ICON_WIDTH = 13;
    private static final int ICON_HEIGHT = 13;
    private String str;
    private HUDDisplayMode displayMode;

    public PlayerCountHUD() {
        super(PlayerCountHUD.SETTINGS.base);
    }

    @Override
    public boolean collectHUDInformation() {
        if (PlayerCountHUD.CLIENT.field_1724 == null) {
            return false;
        }
        int currentPlayer = -1;
        int maxPlayer = -1;
        if (CLIENT.method_1542()) {
            class_1132 server = CLIENT.method_1576();
            if (server == null) {
                return false;
            }
            currentPlayer = server.method_3788();
            maxPlayer = server.method_3802();
        } else {
            class_642 serverInfo;
            Collection playerListEntries = PlayerCountHUD.CLIENT.field_1724.field_3944.method_45732();
            currentPlayer = playerListEntries.size();
            if (PlayerCountHUD.SETTINGS.showMaxPlayer && (serverInfo = CLIENT.method_1558()) != null && serverInfo.field_41861 != null) {
                maxPlayer = serverInfo.field_41861.comp_1279();
            }
        }
        if (currentPlayer < 0) {
            return false;
        }
        this.str = Integer.toString(currentPlayer);
        if (PlayerCountHUD.SETTINGS.showMaxPlayer && maxPlayer > 0) {
            this.str = this.str + "/" + maxPlayer;
        }
        int strWidth = PlayerCountHUD.CLIENT.field_1772.method_1727(this.str) - 1;
        this.displayMode = this.getSettings().getDisplayMode();
        int width = this.displayMode.calculateWidth(13, strWidth);
        int height = 13;
        int color = PlayerCountHUD.SETTINGS.color | 0xFF000000;
        this.setWidthHeightColor(width, height, color);
        return this.str != null;
    }

    @Override
    public boolean renderHUD(class_332 context, int x, int y, boolean drawBackground) {
        int w = this.getWidth();
        int h = this.getHeight();
        int c = this.getColor();
        return RenderUtils.drawSmallHUD(context, this.str, x, y, w, h, TEXTURE, 0.0f, 0.0f, 13, 13, 13, 13, c, this.displayMode, drawBackground);
    }

    @Override
    public String getName() {
        return "Player Count HUD";
    }

    @Override
    public String getId() {
        return HUDId.PLAYER_COUNT.toString();
    }
}

