/*
 * Decompiled with CFR 0.152.
 */
package fin.starhud.screen;

import fin.starhud.hud.AbstractHUD;
import fin.starhud.screen.EditHUDScreen;
import java.util.Objects;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_5348;

public class HelpWidget {
    private static final class_310 CLIENT = class_310.method_1551();
    private static final boolean isMac = EditHUDScreen.isMac;
    private static final Help[] HELPS = new Help[]{new Help((class_2561)class_2561.method_43471((String)"starhud.help.key.move_1"), (class_2561)class_2561.method_43471((String)"starhud.help.info.move_1")), new Help((class_2561)class_2561.method_43471((String)"starhud.help.key.move_5"), (class_2561)class_2561.method_43471((String)"starhud.help.info.move_5")), new Help((class_2561)class_2561.method_43471((String)(isMac ? "starhud.help.key.alignment_mac" : "starhud.help.key.alignment_windows")), (class_2561)class_2561.method_43471((String)"starhud.help.info.alignment")), new Help((class_2561)class_2561.method_43471((String)"starhud.help.key.direction"), (class_2561)class_2561.method_43471((String)"starhud.help.info.direction")), new Help((class_2561)class_2561.method_43471((String)(isMac ? "starhud.help.key.revert_changes_mac" : "starhud.help.key.revert_changes_windows")), (class_2561)class_2561.method_43471((String)"starhud.help.info.revert_changes")), new Help((class_2561)class_2561.method_43471((String)"starhud.help.key.group_ungroup"), (class_2561)class_2561.method_43471((String)"starhud.help.info.group_ungroup")), new Help((class_2561)class_2561.method_43471((String)"starhud.help.key.clamp_all"), (class_2561)class_2561.method_43471((String)"starhud.help.info.clamp_all")), new Help((class_2561)class_2561.method_43471((String)"starhud.help.key.undo"), (class_2561)class_2561.method_43471((String)"starhud.help.info.undo")), new Help((class_2561)class_2561.method_43471((String)"starhud.help.key.redo"), (class_2561)class_2561.method_43471((String)"starhud.help.info.redo"))};
    private static int HELP_KEY_MAX_WIDTH;
    private static int HELP_INFO_MAX_WIDTH;
    private static final int HELP_HEIGHT;
    private static final int GAP = 5;
    private boolean isActive = false;

    public HelpWidget() {
        this.getHelpMaxWidths();
    }

    private void getHelpMaxWidths() {
        int maxKey = 0;
        int maxInfo = 0;
        for (Help h : HELPS) {
            maxKey = Math.max(maxKey, HelpWidget.CLIENT.field_1772.method_27525((class_5348)h.key));
            maxInfo = Math.max(maxInfo, HelpWidget.CLIENT.field_1772.method_27525((class_5348)h.info));
        }
        HELP_KEY_MAX_WIDTH = maxKey;
        HELP_INFO_MAX_WIDTH = maxInfo;
    }

    public void render(class_332 context, AbstractHUD hud, int x, int y) {
        int padding = 5;
        Objects.requireNonNull(HelpWidget.CLIENT.field_1772);
        int lineHeight = 9;
        int maxKeyWidth = HELP_KEY_MAX_WIDTH;
        int maxInfoWidth = HELP_INFO_MAX_WIDTH;
        int width = padding + maxKeyWidth + padding + 1 + padding + maxInfoWidth + padding;
        int height = padding + lineHeight * HELPS.length + padding - 2;
        int helpX = x - width / 2;
        int helpY = y - padding;
        context.method_25294(helpX, helpY, helpX + width, helpY + height, Integer.MIN_VALUE);
        for (Help h : HELPS) {
            class_2561 key = h.key;
            class_2561 info = h.info;
            context.method_51439(HelpWidget.CLIENT.field_1772, key, helpX + padding, helpY + padding, -1, false);
            context.method_51439(HelpWidget.CLIENT.field_1772, info, helpX + padding + maxKeyWidth + padding + 1 + padding, helpY + padding, -1, false);
            helpY += lineHeight;
        }
        if (hud != null) {
            this.renderHUDInformation(context, hud, x, y + HELP_HEIGHT + 5);
        }
    }

    private void renderHUDInformation(class_332 context, AbstractHUD hud, int x, int y) {
        String text = hud.getName();
        int textWidth = HelpWidget.CLIENT.field_1772.method_1727(text);
        int padding = 5;
        int infoX = x - textWidth / 2;
        Objects.requireNonNull(HelpWidget.CLIENT.field_1772);
        context.method_25294(infoX - padding, y - padding, infoX + textWidth + padding, y + 9 - 2 + padding, Integer.MIN_VALUE);
        context.method_51433(HelpWidget.CLIENT.field_1772, text, infoX, y, -1, false);
    }

    public void setActive(boolean active) {
        this.isActive = active;
    }

    public boolean isActive() {
        return this.isActive;
    }

    static {
        HELP_HEIGHT = 5 + HELPS.length * 9 + 5;
    }

    private record Help(class_2561 key, class_2561 info) {
    }
}

