/*
 * Decompiled with CFR 0.152.
 */
package asa.camera;

import asa.camera.config.LethalConfig;
import asa.camera.math.SpringDamper;
import asa.camera.mixin.CameraAccessor;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_746;

@Environment(value=EnvType.CLIENT)
public class CameraHandler {
    private static CameraHandler instance;
    private double smoothedY = 0.0;
    private float renderYaw = 0.0f;
    private float renderPitch = 0.0f;
    private SpringDamper.FloatRef yVelocity = new SpringDamper.FloatRef();
    private SpringDamper.FloatRef yawRef = new SpringDamper.FloatRef();
    private SpringDamper.FloatRef pitchRef = new SpringDamper.FloatRef();
    private float airTime = 0.0f;
    private boolean initialized = false;
    private long lastFrameTime = 0L;
    private float currentYSmoothTime = 0.05f;

    private CameraHandler() {
    }

    public static CameraHandler getInstance() {
        if (instance == null) {
            instance = new CameraHandler();
        }
        return instance;
    }

    public float getRenderYaw() {
        return this.renderYaw;
    }

    public float getRenderPitch() {
        return this.renderPitch;
    }

    public void onCameraUpdate(class_4184 camera, float tickDelta) {
        if (!LethalConfig.enabled) {
            return;
        }
        class_310 client = class_310.method_1551();
        class_746 player = client.field_1724;
        if (player == null) {
            this.initialized = false;
            return;
        }
        long now = System.nanoTime();
        if (!this.initialized) {
            this.lastFrameTime = now;
        }
        float dt = (float)(now - this.lastFrameTime) / 1.0E9f;
        this.lastFrameTime = now;
        if (dt > 0.1f) {
            dt = 0.1f;
        }
        double targetY = camera.method_19326().field_1351;
        float targetYaw = camera.method_19330();
        float targetPitch = camera.method_19329();
        if (!this.initialized) {
            this.smoothedY = targetY;
            this.currentYSmoothTime = LethalConfig.fallSmoothTime;
            this.renderYaw = targetYaw;
            this.renderPitch = targetPitch;
            this.initialized = true;
        }
        if (LethalConfig.mouseSmoothTime <= 0.001f) {
            this.renderYaw = targetYaw;
            this.renderPitch = targetPitch;
        } else {
            while (this.renderYaw - targetYaw > 180.0f) {
                this.renderYaw -= 360.0f;
            }
            while (this.renderYaw - targetYaw < -180.0f) {
                this.renderYaw += 360.0f;
            }
            this.renderYaw = SpringDamper.smoothDamp(this.renderYaw, targetYaw, this.yawRef, LethalConfig.mouseSmoothTime, Float.MAX_VALUE, dt, false);
            this.renderPitch = SpringDamper.smoothDamp(this.renderPitch, targetPitch, this.pitchRef, LethalConfig.mouseSmoothTime, Float.MAX_VALUE, dt, false);
        }
        ((CameraAccessor)camera).invokeSetRotation(this.renderYaw, this.renderPitch);
        this.airTime = !player.method_24828() ? (this.airTime += dt) : 0.0f;
        float targetSmoothTime = targetY > this.smoothedY ? LethalConfig.riseSmoothTime : LethalConfig.fallSmoothTime;
        this.currentYSmoothTime = this.lerp(this.currentYSmoothTime, targetSmoothTime, dt * 10.0f);
        this.smoothedY = SpringDamper.smoothDamp((float)this.smoothedY, (float)targetY, this.yVelocity, this.currentYSmoothTime, Float.MAX_VALUE, dt, true);
        ((CameraAccessor)camera).invokeSetPos(camera.method_19326().field_1352, this.smoothedY, camera.method_19326().field_1350);
    }

    private float lerp(float a, float b, float t) {
        return a + (b - a) * Math.min(1.0f, Math.max(0.0f, t));
    }
}

