/*
 * Decompiled with CFR 0.152.
 */
package asa.camera.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;

@Environment(value=EnvType.CLIENT)
public class LethalConfig {
    public static Preset currentPreset = Preset.SMOOTH;
    public static float jumpSmoothing = 15.0f;
    public static float mouseSmoothTime = 0.04f;
    public static float riseSmoothTime = 0.05f;
    public static float fallSmoothTime = 0.05f;
    public static boolean cameraBobbing = true;
    public static boolean handBobbing = true;
    public static boolean enabled = true;
    private static final Path CONFIG_FILE = FabricLoader.getInstance().getConfigDir().resolve("lethalcamera.json");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    public static void load() {
        if (!Files.exists(CONFIG_FILE, new LinkOption[0])) {
            LethalConfig.applyPreset(Preset.SMOOTH);
            LethalConfig.save();
            return;
        }
        try {
            String json = Files.readString(CONFIG_FILE);
            ConfigData loaded = (ConfigData)GSON.fromJson(json, ConfigData.class);
            if (loaded != null) {
                currentPreset = loaded.preset;
                jumpSmoothing = loaded.jumpSmoothing;
                mouseSmoothTime = loaded.mouseSmoothTime;
                riseSmoothTime = loaded.riseSmoothTime;
                fallSmoothTime = loaded.fallSmoothTime;
                enabled = loaded.enabled;
                cameraBobbing = loaded.cameraBobbing;
                handBobbing = loaded.handBobbing;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void save() {
        ConfigData data = new ConfigData();
        data.preset = currentPreset;
        data.jumpSmoothing = jumpSmoothing;
        data.mouseSmoothTime = mouseSmoothTime;
        data.riseSmoothTime = riseSmoothTime;
        data.fallSmoothTime = fallSmoothTime;
        data.enabled = enabled;
        data.cameraBobbing = cameraBobbing;
        data.handBobbing = handBobbing;
        try {
            Files.writeString(CONFIG_FILE, (CharSequence)GSON.toJson((Object)data), new OpenOption[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void applyPreset(Preset p) {
        currentPreset = p;
        switch (p.ordinal()) {
            case 0: {
                mouseSmoothTime = 0.0f;
                riseSmoothTime = 0.01f;
                fallSmoothTime = 0.01f;
                jumpSmoothing = 50.0f;
                cameraBobbing = true;
                handBobbing = true;
                break;
            }
            case 1: {
                mouseSmoothTime = 0.05f;
                riseSmoothTime = 0.1f;
                fallSmoothTime = 0.05f;
                jumpSmoothing = 15.0f;
                cameraBobbing = false;
                handBobbing = true;
                break;
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static enum Preset {
        VANILLA,
        SMOOTH,
        CUSTOM;

    }

    @Environment(value=EnvType.CLIENT)
    private static class ConfigData {
        Preset preset = Preset.SMOOTH;
        float jumpSmoothing = 15.0f;
        float mouseSmoothTime = 0.04f;
        float riseSmoothTime = 0.05f;
        float fallSmoothTime = 0.05f;
        boolean enabled = true;
        boolean cameraBobbing = true;
        boolean handBobbing = true;

        private ConfigData() {
        }
    }
}

